/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.payment.model.impl;

import com.liferay.commerce.payment.model.CommercePaymentEntryAudit;
import com.liferay.commerce.payment.model.CommercePaymentEntryAuditModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommercePaymentEntryAudit service. Represents a row in the &quot;CommercePaymentEntryAudit&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommercePaymentEntryAuditModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePaymentEntryAuditImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommercePaymentEntryAuditImpl
 * @generated
 */
@JSON(strict = true)
public class CommercePaymentEntryAuditModelImpl
	extends BaseModelImpl<CommercePaymentEntryAudit>
	implements CommercePaymentEntryAuditModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce payment entry audit model instance should use the <code>CommercePaymentEntryAudit</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommercePaymentEntryAudit";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT},
		{"commercePaymentEntryAuditId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP},
		{"commercePaymentEntryId", Types.BIGINT}, {"amount", Types.DECIMAL},
		{"currencyCode", Types.VARCHAR}, {"logType", Types.VARCHAR},
		{"logTypeSettings", Types.CLOB}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commercePaymentEntryAuditId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commercePaymentEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("amount", Types.DECIMAL);
		TABLE_COLUMNS_MAP.put("currencyCode", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("logType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("logTypeSettings", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommercePaymentEntryAudit (mvccVersion LONG default 0 not null,commercePaymentEntryAuditId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commercePaymentEntryId LONG,amount BIGDECIMAL null,currencyCode VARCHAR(75) null,logType VARCHAR(75) null,logTypeSettings TEXT null)";

	public static final String TABLE_SQL_DROP =
		"drop table CommercePaymentEntryAudit";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commercePaymentEntryAudit.createDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommercePaymentEntryAudit.createDate DESC";

	public static final String ORDER_BY_SQL_INLINE_DISTINCT =
		" ORDER BY commercePaymentEntryAudit.createDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCEPAYMENTENTRYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREATEDATE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public CommercePaymentEntryAuditModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commercePaymentEntryAuditId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommercePaymentEntryAuditId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commercePaymentEntryAuditId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommercePaymentEntryAudit.class;
	}

	@Override
	public String getModelClassName() {
		return CommercePaymentEntryAudit.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommercePaymentEntryAudit, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommercePaymentEntryAudit, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePaymentEntryAudit, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((CommercePaymentEntryAudit)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommercePaymentEntryAudit, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommercePaymentEntryAudit, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommercePaymentEntryAudit)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommercePaymentEntryAudit, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommercePaymentEntryAudit, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<CommercePaymentEntryAudit, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<CommercePaymentEntryAudit, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<CommercePaymentEntryAudit, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", CommercePaymentEntryAudit::getMvccVersion);
			attributeGetterFunctions.put(
				"commercePaymentEntryAuditId",
				CommercePaymentEntryAudit::getCommercePaymentEntryAuditId);
			attributeGetterFunctions.put(
				"companyId", CommercePaymentEntryAudit::getCompanyId);
			attributeGetterFunctions.put(
				"userId", CommercePaymentEntryAudit::getUserId);
			attributeGetterFunctions.put(
				"userName", CommercePaymentEntryAudit::getUserName);
			attributeGetterFunctions.put(
				"createDate", CommercePaymentEntryAudit::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", CommercePaymentEntryAudit::getModifiedDate);
			attributeGetterFunctions.put(
				"commercePaymentEntryId",
				CommercePaymentEntryAudit::getCommercePaymentEntryId);
			attributeGetterFunctions.put(
				"amount", CommercePaymentEntryAudit::getAmount);
			attributeGetterFunctions.put(
				"currencyCode", CommercePaymentEntryAudit::getCurrencyCode);
			attributeGetterFunctions.put(
				"logType", CommercePaymentEntryAudit::getLogType);
			attributeGetterFunctions.put(
				"logTypeSettings",
				CommercePaymentEntryAudit::getLogTypeSettings);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<CommercePaymentEntryAudit, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<CommercePaymentEntryAudit, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<CommercePaymentEntryAudit, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<CommercePaymentEntryAudit, Long>)
					CommercePaymentEntryAudit::setMvccVersion);
			attributeSetterBiConsumers.put(
				"commercePaymentEntryAuditId",
				(BiConsumer<CommercePaymentEntryAudit, Long>)
					CommercePaymentEntryAudit::setCommercePaymentEntryAuditId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<CommercePaymentEntryAudit, Long>)
					CommercePaymentEntryAudit::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<CommercePaymentEntryAudit, Long>)
					CommercePaymentEntryAudit::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<CommercePaymentEntryAudit, String>)
					CommercePaymentEntryAudit::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<CommercePaymentEntryAudit, Date>)
					CommercePaymentEntryAudit::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<CommercePaymentEntryAudit, Date>)
					CommercePaymentEntryAudit::setModifiedDate);
			attributeSetterBiConsumers.put(
				"commercePaymentEntryId",
				(BiConsumer<CommercePaymentEntryAudit, Long>)
					CommercePaymentEntryAudit::setCommercePaymentEntryId);
			attributeSetterBiConsumers.put(
				"amount",
				(BiConsumer<CommercePaymentEntryAudit, BigDecimal>)
					CommercePaymentEntryAudit::setAmount);
			attributeSetterBiConsumers.put(
				"currencyCode",
				(BiConsumer<CommercePaymentEntryAudit, String>)
					CommercePaymentEntryAudit::setCurrencyCode);
			attributeSetterBiConsumers.put(
				"logType",
				(BiConsumer<CommercePaymentEntryAudit, String>)
					CommercePaymentEntryAudit::setLogType);
			attributeSetterBiConsumers.put(
				"logTypeSettings",
				(BiConsumer<CommercePaymentEntryAudit, String>)
					CommercePaymentEntryAudit::setLogTypeSettings);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCommercePaymentEntryAuditId() {
		return _commercePaymentEntryAuditId;
	}

	@Override
	public void setCommercePaymentEntryAuditId(
		long commercePaymentEntryAuditId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePaymentEntryAuditId = commercePaymentEntryAuditId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommercePaymentEntryId() {
		return _commercePaymentEntryId;
	}

	@Override
	public void setCommercePaymentEntryId(long commercePaymentEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commercePaymentEntryId = commercePaymentEntryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommercePaymentEntryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("commercePaymentEntryId"));
	}

	@JSON
	@Override
	public BigDecimal getAmount() {
		return _amount;
	}

	@Override
	public void setAmount(BigDecimal amount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_amount = amount;
	}

	@JSON
	@Override
	public String getCurrencyCode() {
		if (_currencyCode == null) {
			return "";
		}
		else {
			return _currencyCode;
		}
	}

	@Override
	public void setCurrencyCode(String currencyCode) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_currencyCode = currencyCode;
	}

	@JSON
	@Override
	public String getLogType() {
		if (_logType == null) {
			return "";
		}
		else {
			return _logType;
		}
	}

	@Override
	public void setLogType(String logType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_logType = logType;
	}

	@JSON
	@Override
	public String getLogTypeSettings() {
		if (_logTypeSettings == null) {
			return "";
		}
		else {
			return _logTypeSettings;
		}
	}

	@Override
	public void setLogTypeSettings(String logTypeSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_logTypeSettings = logTypeSettings;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommercePaymentEntryAudit.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommercePaymentEntryAudit toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommercePaymentEntryAudit>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommercePaymentEntryAuditImpl commercePaymentEntryAuditImpl =
			new CommercePaymentEntryAuditImpl();

		commercePaymentEntryAuditImpl.setMvccVersion(getMvccVersion());
		commercePaymentEntryAuditImpl.setCommercePaymentEntryAuditId(
			getCommercePaymentEntryAuditId());
		commercePaymentEntryAuditImpl.setCompanyId(getCompanyId());
		commercePaymentEntryAuditImpl.setUserId(getUserId());
		commercePaymentEntryAuditImpl.setUserName(getUserName());
		commercePaymentEntryAuditImpl.setCreateDate(getCreateDate());
		commercePaymentEntryAuditImpl.setModifiedDate(getModifiedDate());
		commercePaymentEntryAuditImpl.setCommercePaymentEntryId(
			getCommercePaymentEntryId());
		commercePaymentEntryAuditImpl.setAmount(getAmount());
		commercePaymentEntryAuditImpl.setCurrencyCode(getCurrencyCode());
		commercePaymentEntryAuditImpl.setLogType(getLogType());
		commercePaymentEntryAuditImpl.setLogTypeSettings(getLogTypeSettings());

		commercePaymentEntryAuditImpl.resetOriginalValues();

		return commercePaymentEntryAuditImpl;
	}

	@Override
	public CommercePaymentEntryAudit cloneWithOriginalValues() {
		CommercePaymentEntryAuditImpl commercePaymentEntryAuditImpl =
			new CommercePaymentEntryAuditImpl();

		commercePaymentEntryAuditImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		commercePaymentEntryAuditImpl.setCommercePaymentEntryAuditId(
			this.<Long>getColumnOriginalValue("commercePaymentEntryAuditId"));
		commercePaymentEntryAuditImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		commercePaymentEntryAuditImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		commercePaymentEntryAuditImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		commercePaymentEntryAuditImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		commercePaymentEntryAuditImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		commercePaymentEntryAuditImpl.setCommercePaymentEntryId(
			this.<Long>getColumnOriginalValue("commercePaymentEntryId"));
		commercePaymentEntryAuditImpl.setAmount(
			this.<BigDecimal>getColumnOriginalValue("amount"));
		commercePaymentEntryAuditImpl.setCurrencyCode(
			this.<String>getColumnOriginalValue("currencyCode"));
		commercePaymentEntryAuditImpl.setLogType(
			this.<String>getColumnOriginalValue("logType"));
		commercePaymentEntryAuditImpl.setLogTypeSettings(
			this.<String>getColumnOriginalValue("logTypeSettings"));

		return commercePaymentEntryAuditImpl;
	}

	@Override
	public int compareTo(CommercePaymentEntryAudit commercePaymentEntryAudit) {
		int value = 0;

		value = DateUtil.compareTo(
			getCreateDate(), commercePaymentEntryAudit.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommercePaymentEntryAudit)) {
			return false;
		}

		CommercePaymentEntryAudit commercePaymentEntryAudit =
			(CommercePaymentEntryAudit)object;

		long primaryKey = commercePaymentEntryAudit.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommercePaymentEntryAudit> toCacheModel() {
		CommercePaymentEntryAuditCacheModel
			commercePaymentEntryAuditCacheModel =
				new CommercePaymentEntryAuditCacheModel();

		commercePaymentEntryAuditCacheModel.mvccVersion = getMvccVersion();

		commercePaymentEntryAuditCacheModel.commercePaymentEntryAuditId =
			getCommercePaymentEntryAuditId();

		commercePaymentEntryAuditCacheModel.companyId = getCompanyId();

		commercePaymentEntryAuditCacheModel.userId = getUserId();

		commercePaymentEntryAuditCacheModel.userName = getUserName();

		String userName = commercePaymentEntryAuditCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commercePaymentEntryAuditCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commercePaymentEntryAuditCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commercePaymentEntryAuditCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commercePaymentEntryAuditCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commercePaymentEntryAuditCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commercePaymentEntryAuditCacheModel.commercePaymentEntryId =
			getCommercePaymentEntryId();

		commercePaymentEntryAuditCacheModel.amount = getAmount();

		commercePaymentEntryAuditCacheModel.currencyCode = getCurrencyCode();

		String currencyCode = commercePaymentEntryAuditCacheModel.currencyCode;

		if ((currencyCode != null) && (currencyCode.length() == 0)) {
			commercePaymentEntryAuditCacheModel.currencyCode = null;
		}

		commercePaymentEntryAuditCacheModel.logType = getLogType();

		String logType = commercePaymentEntryAuditCacheModel.logType;

		if ((logType != null) && (logType.length() == 0)) {
			commercePaymentEntryAuditCacheModel.logType = null;
		}

		commercePaymentEntryAuditCacheModel.logTypeSettings =
			getLogTypeSettings();

		String logTypeSettings =
			commercePaymentEntryAuditCacheModel.logTypeSettings;

		if ((logTypeSettings != null) && (logTypeSettings.length() == 0)) {
			commercePaymentEntryAuditCacheModel.logTypeSettings = null;
		}

		return commercePaymentEntryAuditCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommercePaymentEntryAudit, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommercePaymentEntryAudit, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommercePaymentEntryAudit, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommercePaymentEntryAudit)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommercePaymentEntryAudit>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						CommercePaymentEntryAudit.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _commercePaymentEntryAuditId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commercePaymentEntryId;
	private BigDecimal _amount;
	private String _currencyCode;
	private String _logType;
	private String _logTypeSettings;

	public <T> T getColumnValue(String columnName) {
		Function<CommercePaymentEntryAudit, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommercePaymentEntryAudit)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"commercePaymentEntryAuditId", _commercePaymentEntryAuditId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"commercePaymentEntryId", _commercePaymentEntryId);
		_columnOriginalValues.put("amount", _amount);
		_columnOriginalValues.put("currencyCode", _currencyCode);
		_columnOriginalValues.put("logType", _logType);
		_columnOriginalValues.put("logTypeSettings", _logTypeSettings);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("commercePaymentEntryAuditId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("commercePaymentEntryId", 128L);

		columnBitmasks.put("amount", 256L);

		columnBitmasks.put("currencyCode", 512L);

		columnBitmasks.put("logType", 1024L);

		columnBitmasks.put("logTypeSettings", 2048L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommercePaymentEntryAudit _escapedModel;

}