/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.service.impl;

import com.liferay.commerce.payment.model.CommercePaymentEntryAudit;
import com.liferay.commerce.payment.service.base.CommercePaymentEntryAuditLocalServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.commerce.payment.model.CommercePaymentEntryAudit"}, service={AopService.class})
public class CommercePaymentEntryAuditLocalServiceImpl
extends CommercePaymentEntryAuditLocalServiceBaseImpl {
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CommercePaymentEntryAudit addCommercePaymentEntryAudit(long userId, long commercePaymentEntryId, BigDecimal amount, String currencyCode, String logType, String logTypeSettings, ServiceContext serviceContext) throws PortalException {
        CommercePaymentEntryAudit commercePaymentEntryAudit = this.commercePaymentEntryAuditPersistence.create(this.counterLocalService.increment());
        User user = this._userLocalService.getUser(userId);
        commercePaymentEntryAudit.setCompanyId(user.getCompanyId());
        commercePaymentEntryAudit.setUserId(user.getUserId());
        commercePaymentEntryAudit.setUserName(user.getFullName());
        commercePaymentEntryAudit.setCommercePaymentEntryId(commercePaymentEntryId);
        commercePaymentEntryAudit.setAmount(amount);
        commercePaymentEntryAudit.setCurrencyCode(currencyCode);
        commercePaymentEntryAudit.setLogType(logType);
        commercePaymentEntryAudit.setLogTypeSettings(logTypeSettings);
        commercePaymentEntryAudit = (CommercePaymentEntryAudit)this.commercePaymentEntryAuditPersistence.update((BaseModel)commercePaymentEntryAudit);
        this._resourceLocalService.addModelResources((AuditedModel)commercePaymentEntryAudit, serviceContext);
        return commercePaymentEntryAudit;
    }

    @Override
    public CommercePaymentEntryAudit deleteCommercePaymentEntryAudit(long commercePaymentEntryAuditId) throws PortalException {
        CommercePaymentEntryAudit commercePaymentEntryAudit = this.commercePaymentEntryAuditPersistence.remove(commercePaymentEntryAuditId);
        this._resourceLocalService.deleteResource(commercePaymentEntryAudit.getCompanyId(), CommercePaymentEntryAudit.class.getName(), 4, commercePaymentEntryAudit.getCommercePaymentEntryAuditId());
        return commercePaymentEntryAudit;
    }

    public void deleteCommercePaymentEntryAudits(long commercePaymentEntryId) throws PortalException {
        List commercePaymentEntryAudits = this.commercePaymentEntryAuditPersistence.findByCommercePaymentEntryId(commercePaymentEntryId);
        for (CommercePaymentEntryAudit commercePaymentEntryAudit : commercePaymentEntryAudits) {
            this.commercePaymentEntryAuditLocalService.deleteCommercePaymentEntryAudit(commercePaymentEntryAudit.getCommercePaymentEntryAuditId());
        }
    }

    public List<CommercePaymentEntryAudit> getCommercePaymentEntryAudits(long commercePaymentEntryId, int start, int end, OrderByComparator<CommercePaymentEntryAudit> orderByComparator) {
        return this.commercePaymentEntryAuditPersistence.findByCommercePaymentEntryId(commercePaymentEntryId, start, end, orderByComparator);
    }

    public int getCommercePaymentEntryAuditsCount(long commercePaymentEntryId) {
        return this.commercePaymentEntryAuditPersistence.countByCommercePaymentEntryId(commercePaymentEntryId);
    }

    public BaseModelSearchResult<CommercePaymentEntryAudit> searchCommercePaymentEntryAudits(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, String orderByField, boolean reverse) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(companyId, keywords, params, start, end, orderByField, reverse));
        SearchHits searchHits = searchResponse.getSearchHits();
        List commercePaymentEntries = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long commercePaymentEntryAuditId = document.getLong("entryClassPK");
            CommercePaymentEntryAudit commercePaymentEntryAudit = this.fetchCommercePaymentEntryAudit(commercePaymentEntryAuditId);
            if (commercePaymentEntryAudit == null) {
                Indexer commercePaymentEntryAuditIndexer = IndexerRegistryUtil.getIndexer(CommercePaymentEntryAudit.class);
                commercePaymentEntryAuditIndexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return commercePaymentEntryAudit;
        });
        return new BaseModelSearchResult(commercePaymentEntries, searchResponse.getTotalHits());
    }

    private SearchRequest _getSearchRequest(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, String orderByField, boolean reverse) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{CommercePaymentEntryAudit.class.getName()}).emptySearchEnabled(true).highlightEnabled(false).withSearchContext(searchContext -> this._populateSearchContext((SearchContext)searchContext, companyId, keywords, params));
        if (start != -1) {
            searchRequestBuilder.from(Integer.valueOf(start));
            searchRequestBuilder.size(Integer.valueOf(end));
        }
        if (Validator.isNotNull((String)orderByField)) {
            SortOrder sortOrder = SortOrder.ASC;
            if (reverse) {
                sortOrder = SortOrder.DESC;
            }
            FieldSort fieldSort = this._sorts.field(this._sortFieldBuilder.getSortField(CommercePaymentEntryAudit.class, orderByField), sortOrder);
            searchRequestBuilder.sorts(new Sort[]{fieldSort});
        }
        return searchRequestBuilder.build();
    }

    private void _populateSearchContext(SearchContext searchContext, long companyId, String keywords, LinkedHashMap<String, Object> params) {
        long permissionUserId;
        Object[] logTypes;
        searchContext.setCompanyId(companyId);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (MapUtil.isEmpty(params)) {
            return;
        }
        long[] commercePaymentEntryIds = (long[])params.get("commercePaymentEntryIds");
        if (ArrayUtil.isNotEmpty((long[])commercePaymentEntryIds)) {
            searchContext.setAttribute("commercePaymentEntryIds", (Serializable)commercePaymentEntryIds);
        }
        if (ArrayUtil.isNotEmpty((Object[])(logTypes = (String[])params.get("logTypes")))) {
            searchContext.setAttribute("logTypes", (Serializable)logTypes);
        }
        if ((permissionUserId = GetterUtil.getLong((Object)params.get("permissionUserId"))) > 0L) {
            searchContext.setUserId(permissionUserId);
        }
    }
}

