/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.util;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.util.CommercePaymentHttpHelper;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.encryptor.Encryptor;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.security.Key;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommercePaymentHttpHelper.class})
public class CommercePaymentHttpHelperImpl
implements CommercePaymentHttpHelper {
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private Encryptor _encryptor;
    @Reference
    private Portal _portal;

    public CommerceOrder getCommerceOrder(HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = null;
        long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
        String uuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"uuid");
        String guestToken = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"guestToken");
        if (Validator.isNotNull((String)guestToken)) {
            guestToken = guestToken.replaceAll(" ", "+");
            commerceOrder = this._commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
            Company company = this._portal.getCompany(httpServletRequest);
            User guestUser = company.getGuestUser();
            String orderGuestToken = this._getGuestToken(company, commerceOrder.getCommerceOrderId());
            if (!guestToken.equals(orderGuestToken)) {
                throw new PrincipalException.MustHavePermission(guestUser.getUserId(), CommerceOrder.class.getName(), commerceOrder.getCommerceOrderId(), new String[]{"VIEW"});
            }
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)guestUser));
        } else {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)this._portal.getUser(httpServletRequest)));
            commerceOrder = this._commerceOrderService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
        }
        return commerceOrder;
    }

    private String _getGuestToken(Company company, long commerceOrderId) throws Exception {
        Key key = company.getKeyObj();
        return this._encryptor.encrypt(key, String.valueOf(commerceOrderId));
    }
}

