/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.servlet;

import com.liferay.commerce.checkout.helper.CommerceCheckoutStepHttpHelper;
import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.engine.CommerceSubscriptionEngine;
import com.liferay.commerce.payment.gateway.CommercePaymentGateway;
import com.liferay.commerce.payment.integration.CommercePaymentIntegration;
import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.service.CommercePaymentEntryLocalService;
import com.liferay.commerce.payment.util.CommercePaymentHelper;
import com.liferay.commerce.payment.util.CommercePaymentHttpHelper;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.http.whiteboard.context.path=/commerce-payment", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.payment.internal.servlet.CommercePaymentServlet", "osgi.http.whiteboard.servlet.pattern=/commerce-payment/*"}, service={Servlet.class})
public class CommercePaymentServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(CommercePaymentServlet.class);
    private long _commerceChannelId;
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceCheckoutStepHttpHelper _commerceCheckoutStepHttpHelper;
    private long _commerceOrderId;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommercePaymentEngine _commercePaymentEngine;
    @Reference
    private CommercePaymentEntryLocalService _commercePaymentEntryLocalService;
    @Reference
    private CommercePaymentGateway _commercePaymentGateway;
    @Reference
    private CommercePaymentHelper _commercePaymentHelper;
    @Reference
    private CommercePaymentHttpHelper _commercePaymentHttpHelper;
    private CommercePaymentIntegration _commercePaymentIntegration;
    @Reference
    private CommerceSubscriptionEngine _commerceSubscriptionEngine;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    private String _redirect;
    @Reference
    private UserLocalService _userLocalService;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            CommerceOrder commerceOrder;
            if (PortalSessionThreadLocal.getHttpSession() == null) {
                PortalSessionThreadLocal.setHttpSession((HttpSession)httpServletRequest.getSession());
            }
            URL portalURL = new URL(this._portal.getPortalURL(httpServletRequest));
            String entryKey = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"entryKey");
            if (Validator.isBlank((String)entryKey)) {
                commerceOrder = this._commercePaymentHttpHelper.getCommerceOrder(httpServletRequest);
                this._commerceOrderId = commerceOrder.getCommerceOrderId();
                CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
                this._commerceChannelId = commerceChannel.getCommerceChannelId();
                this._commercePaymentIntegration = this._commercePaymentHelper.getCommercePaymentIntegration(this._commerceChannelId, commerceOrder.getCommercePaymentMethodKey());
            } else {
                this._commercePaymentIntegration = this._commercePaymentHelper.getCommercePaymentIntegration(this._commerceChannelId, entryKey);
            }
            commerceOrder = this._commerceOrderLocalService.getCommerceOrder(this._commerceOrderId);
            if (this._commercePaymentIntegration != null) {
                this._managePaymentIntegration(httpServletRequest, httpServletResponse, this._commerceChannelId, commerceOrder, this._commercePaymentIntegration, portalURL);
            } else {
                this._managePaymentMethod(httpServletRequest, httpServletResponse, commerceOrder, portalURL);
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            try {
                CommerceOrder commerceOrder = this._commerceOrderLocalService.fetchCommerceOrder(this._commerceOrderId);
                if (commerceOrder != null && commerceOrder.getPaymentStatus() != 0) {
                    PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)this._portal.getUser(httpServletRequest)));
                    this._commercePaymentEngine.updateOrderPaymentStatus(this._commerceOrderId, 4, "", "");
                }
                httpServletResponse.sendRedirect(this._portal.getPortalURL(httpServletRequest));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
    }

    private String _getApplicationContextURL(long entryId, String entryKey, HttpServletRequest httpServletRequest, String queryString, String redirect) {
        StringBundler sb = new StringBundler(13);
        sb.append(this._portal.getPortalURL(httpServletRequest));
        sb.append(this._portal.getPathModule());
        sb.append('/');
        sb.append("commerce-payment");
        sb.append('?');
        if (Validator.isNotNull((String)redirect)) {
            sb.append("redirect=");
            sb.append(URLCodec.encodeURL((String)redirect));
            sb.append('&');
        }
        sb.append("entryId=");
        sb.append(entryId);
        sb.append("&entryKey=");
        sb.append(entryKey);
        sb.append(queryString);
        return sb.toString();
    }

    private Map<String, String> _getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(StringUtil.toUpperCase((String)CamelCaseUtil.fromCamelCase((String)name, (char)'_')), value);
        }
        return map;
    }

    private void _managePaymentIntegration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long commerceChannelId, CommerceOrder commerceOrder, CommercePaymentIntegration commercePaymentIntegration, URL portalURL) throws Exception {
        long entryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"entryId");
        CommercePaymentEntry commercePaymentEntry = this._commercePaymentEntryLocalService.fetchCommercePaymentEntry(entryId);
        if (commercePaymentEntry == null) {
            this._redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"nextStep");
            URL url = new URL(this._redirect);
            if (!Objects.equals(portalURL.getHost(), url.getHost())) {
                throw new ServletException();
            }
            User currentUser = this._portal.getUser(httpServletRequest);
            if (currentUser == null) {
                currentUser = this._userLocalService.getUserById(commerceOrder.getUserId());
            }
            CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
            commercePaymentEntry = this._commercePaymentEntryLocalService.addCommercePaymentEntry(currentUser.getUserId(), this._portal.getClassNameId(CommerceOrder.class), commerceOrder.getCommerceOrderId(), commerceChannelId, commerceOrder.getTotal(), null, null, commerceCurrency.getCode(), this._language.getLanguageId(httpServletRequest), null, null, commerceOrder.getCommercePaymentMethodKey(), commercePaymentIntegration.getPaymentIntegrationType(), null, null, 0, ServiceContextFactory.getInstance((HttpServletRequest)httpServletRequest));
            commercePaymentEntry.setCallbackURL(this._getApplicationContextURL(commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentIntegration.getKey(), httpServletRequest, "&orderType=normal", this._redirect));
            commercePaymentEntry.setCancelURL(this._getApplicationContextURL(commercePaymentEntry.getCommercePaymentEntryId(), commercePaymentIntegration.getKey(), httpServletRequest, "&cancel=true", this._redirect));
            commercePaymentEntry = this._commercePaymentEntryLocalService.updateCommercePaymentEntry(this._commercePaymentGateway.setUpPayment(httpServletRequest, commercePaymentEntry));
        } else {
            String token;
            boolean cancel = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"cancel");
            if (cancel) {
                if (commercePaymentEntry.getPaymentStatus() == 18) {
                    PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)this._portal.getUser(httpServletRequest)));
                    this._commercePaymentEngine.updateOrderPaymentStatus(this._commerceOrderId, 8, "", "");
                    commercePaymentEntry.setPaymentStatus(8);
                    commercePaymentEntry = this._commercePaymentEntryLocalService.updateCommercePaymentEntry(commercePaymentEntry);
                    if (ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"redirect", (boolean)true)) {
                        httpServletResponse.sendRedirect(this._redirect);
                    }
                    return;
                }
                this._commercePaymentGateway.cancel(httpServletRequest, commercePaymentEntry);
            }
            if (!Validator.isBlank((String)(token = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"token")))) {
                commercePaymentEntry.setTransactionCode(token);
            }
            if (commercePaymentEntry.getPaymentStatus() == 18) {
                commercePaymentEntry = this._commercePaymentGateway.authorize(httpServletRequest, commercePaymentEntry);
            } else if (commercePaymentEntry.getPaymentStatus() == 2) {
                commercePaymentEntry = this._commercePaymentGateway.capture(httpServletRequest, commercePaymentEntry);
            }
        }
        int paymentStatus = commercePaymentEntry.getPaymentStatus();
        if (4 == paymentStatus) {
            httpServletResponse.sendRedirect(this._redirect);
            return;
        }
        if (!(commercePaymentIntegration.getPaymentIntegrationType() != 1 && commercePaymentIntegration.getPaymentIntegrationType() != 4 || 18 != paymentStatus && 2 != paymentStatus)) {
            if (Validator.isNull((String)commercePaymentEntry.getRedirectURL())) {
                if (18 == paymentStatus) {
                    if (!ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"redirect", (boolean)true)) {
                        return;
                    }
                    if (4 == (commercePaymentEntry = this._commercePaymentGateway.authorize(httpServletRequest, commercePaymentEntry)).getPaymentStatus()) {
                        httpServletResponse.sendRedirect(this._redirect);
                        return;
                    }
                } else {
                    this._commercePaymentGateway.capture(httpServletRequest, commercePaymentEntry);
                    httpServletResponse.sendRedirect(this._redirect);
                    return;
                }
            }
            URL redirectURL = new URL(commercePaymentEntry.getRedirectURL());
            if (Objects.equals(portalURL.getHost(), redirectURL.getHost())) {
                Map<String, String> paramsMap = this._getQueryMap(redirectURL.getQuery());
                Set<Map.Entry<String, String>> entries = paramsMap.entrySet();
                for (Map.Entry<String, String> param : entries) {
                    httpServletRequest.setAttribute(param.getKey(), (Object)param.getValue());
                }
                RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(redirectURL.getPath());
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendRedirect(redirectURL.toString());
            }
            return;
        }
        if (commercePaymentIntegration.getPaymentIntegrationType() == 2 || commercePaymentIntegration.getPaymentIntegrationType() == 5 || commercePaymentIntegration.getPaymentIntegrationType() == 3 || commercePaymentIntegration.getPaymentIntegrationType() == 0) {
            if (commercePaymentEntry.getPaymentStatus() == 18) {
                commercePaymentEntry = this._commercePaymentGateway.authorize(httpServletRequest, commercePaymentEntry);
            }
            if (commercePaymentEntry.getPaymentStatus() == 2) {
                this._commercePaymentGateway.capture(httpServletRequest, commercePaymentEntry);
            }
        }
        httpServletResponse.sendRedirect(this._redirect);
    }

    private void _managePaymentMethod(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, CommerceOrder commerceOrder, URL portalURL) throws Exception {
        int commercePaymentMethodType;
        this._redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"nextStep");
        URL url = new URL(this._redirect);
        if (!Objects.equals(portalURL.getHost(), url.getHost())) {
            throw new ServletException();
        }
        if (this._commerceCheckoutStepHttpHelper.isCommercePaymentComplete(httpServletRequest, commerceOrder)) {
            this._commercePaymentEngine.completePayment(this._commerceOrderId, null, httpServletRequest);
            httpServletResponse.sendRedirect(this._redirect);
            return;
        }
        CommercePaymentResult commercePaymentResult = this._startPayment(httpServletRequest);
        if (commercePaymentResult.isSuccess() && commercePaymentResult.isOnlineRedirect()) {
            URL redirectURL = new URL(commercePaymentResult.getRedirectUrl());
            if (Objects.equals(portalURL.getHost(), redirectURL.getHost())) {
                Map<String, String> paramsMap = this._getQueryMap(redirectURL.getQuery());
                Set<Map.Entry<String, String>> entries = paramsMap.entrySet();
                for (Map.Entry<String, String> param : entries) {
                    httpServletRequest.setAttribute(param.getKey(), (Object)param.getValue());
                }
                RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(redirectURL.getPath());
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            } else {
                httpServletResponse.sendRedirect(redirectURL.toString());
            }
        }
        if (2 == (commercePaymentMethodType = this._commercePaymentEngine.getCommercePaymentMethodType(this._commerceOrderId)) || commercePaymentMethodType == -1) {
            this._commercePaymentEngine.completePayment(this._commerceOrderId, null, httpServletRequest);
            httpServletResponse.sendRedirect(this._redirect);
        }
        if (commercePaymentResult.isSuccess() && 0 == commercePaymentMethodType) {
            if (commerceOrder.isSubscriptionOrder()) {
                this._commerceSubscriptionEngine.completeRecurringPayment(this._commerceOrderId, commercePaymentResult.getAuthTransactionId(), httpServletRequest);
            } else {
                this._commercePaymentEngine.completePayment(this._commerceOrderId, commercePaymentResult.getAuthTransactionId(), httpServletRequest);
            }
            httpServletResponse.sendRedirect(this._redirect);
        }
        if (!commercePaymentResult.isSuccess() && !httpServletResponse.isCommitted()) {
            httpServletResponse.sendRedirect(this._redirect);
        }
    }

    private CommercePaymentResult _startPayment(HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(this._commerceOrderId);
        if (commerceOrder.isSubscriptionOrder() && !this._commercePaymentHelper.isDeliveryOnlySubscription(commerceOrder)) {
            return this._commerceSubscriptionEngine.processRecurringPayment(this._commerceOrderId, this._redirect, httpServletRequest);
        }
        return this._commercePaymentEngine.processPayment(this._commerceOrderId, this._redirect, httpServletRequest);
    }
}

