/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.MissingFilter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import org.osgi.service.component.annotations.Component;

@Component(property={"indexer.class.name=com.liferay.commerce.payment.model.CommercePaymentEntryAudit"}, service={ModelPreFilterContributor.class})
public class CommercePaymentEntryAuditModelPreFilterContributor
implements ModelPreFilterContributor {
    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this._filterByCommercePaymentEntryIds(booleanFilter, searchContext);
        this._filterByLogTypes(booleanFilter, searchContext);
    }

    private void _filterByCommercePaymentEntryIds(BooleanFilter booleanFilter, SearchContext searchContext) {
        long[] commercePaymentEntryIds = GetterUtil.getLongValues((Object)searchContext.getAttribute("commercePaymentEntryIds"), null);
        if (commercePaymentEntryIds.length < 1) {
            return;
        }
        BooleanFilter commercePaymentEntryIdBooleanFilter = new BooleanFilter();
        for (long commercePaymentEntryId : commercePaymentEntryIds) {
            TermFilter termFilter = new TermFilter("commercePaymentEntryId", String.valueOf(commercePaymentEntryId));
            commercePaymentEntryIdBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
        }
        commercePaymentEntryIdBooleanFilter.add((Filter)new MissingFilter("commercePaymentEntryId"), BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)commercePaymentEntryIdBooleanFilter, BooleanClauseOccur.MUST);
    }

    private void _filterByLogTypes(BooleanFilter booleanFilter, SearchContext searchContext) {
        String[] logTypes = GetterUtil.getStringValues((Object)searchContext.getAttribute("logTypes"));
        if (logTypes.length < 1) {
            return;
        }
        BooleanFilter logTypeBooleanFilter = new BooleanFilter();
        for (String logType : logTypes) {
            TermFilter termFilter = new TermFilter("logType", logType);
            logTypeBooleanFilter.add((Filter)termFilter, BooleanClauseOccur.SHOULD);
        }
        logTypeBooleanFilter.add((Filter)new MissingFilter("logType"), BooleanClauseOccur.SHOULD);
        booleanFilter.add((Filter)logTypeBooleanFilter, BooleanClauseOccur.MUST);
    }
}

