/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.payment.model.impl;

import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRelQualifier;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelQualifierLocalServiceUtil;

/**
 * The extended model base implementation for the CommercePaymentMethodGroupRelQualifier service. Represents a row in the &quot;CPMethodGroupRelQualifier&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePaymentMethodGroupRelQualifierImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommercePaymentMethodGroupRelQualifierImpl
 * @see CommercePaymentMethodGroupRelQualifier
 * @generated
 */
public abstract class CommercePaymentMethodGroupRelQualifierBaseImpl
	extends CommercePaymentMethodGroupRelQualifierModelImpl
	implements CommercePaymentMethodGroupRelQualifier {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce payment method group rel qualifier model instance should use the <code>CommercePaymentMethodGroupRelQualifier</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommercePaymentMethodGroupRelQualifierLocalServiceUtil.
				addCommercePaymentMethodGroupRelQualifier(this);
		}
		else {
			CommercePaymentMethodGroupRelQualifierLocalServiceUtil.
				updateCommercePaymentMethodGroupRelQualifier(this);
		}
	}

}