/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.payment.model.impl;

import com.liferay.commerce.payment.model.CommercePaymentEntry;
import com.liferay.commerce.payment.service.CommercePaymentEntryLocalServiceUtil;

/**
 * The extended model base implementation for the CommercePaymentEntry service. Represents a row in the &quot;CommercePaymentEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommercePaymentEntryImpl}.
 * </p>
 *
 * @author Luca Pellizzon
 * @see CommercePaymentEntryImpl
 * @see CommercePaymentEntry
 * @generated
 */
public abstract class CommercePaymentEntryBaseImpl
	extends CommercePaymentEntryModelImpl implements CommercePaymentEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce payment entry model instance should use the <code>CommercePaymentEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommercePaymentEntryLocalServiceUtil.addCommercePaymentEntry(this);
		}
		else {
			CommercePaymentEntryLocalServiceUtil.updateCommercePaymentEntry(
				this);
		}
	}

}