/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.servlet;

import com.liferay.commerce.checkout.helper.CommerceCheckoutStepHttpHelper;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.engine.CommerceSubscriptionEngine;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.util.CommercePaymentHttpHelper;
import com.liferay.commerce.payment.util.CommercePaymentUtils;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"osgi.http.whiteboard.context.path=/commerce-payment", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.payment.internal.servlet.CommercePaymentServlet", "osgi.http.whiteboard.servlet.pattern=/commerce-payment/*"}, service={Servlet.class})
public class CommercePaymentServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(CommercePaymentServlet.class);
    @Reference
    private CommerceCheckoutStepHttpHelper _commerceCheckoutStepHttpHelper;
    private long _commerceOrderId;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommercePaymentEngine _commercePaymentEngine;
    @Reference
    private CommercePaymentHttpHelper _commercePaymentHttpHelper;
    @Reference
    private CommercePaymentUtils _commercePaymentUtils;
    @Reference
    private CommerceSubscriptionEngine _commerceSubscriptionEngine;
    private String _nextUrl;
    @Reference
    private Portal _portal;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            int commercePaymentMethodType;
            if (PortalSessionThreadLocal.getHttpSession() == null) {
                PortalSessionThreadLocal.setHttpSession((HttpSession)httpServletRequest.getSession());
            }
            URL portalURL = new URL(this._portal.getPortalURL(httpServletRequest));
            this._nextUrl = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"nextStep");
            URL nextURL = new URL(this._nextUrl);
            if (!Objects.equals(portalURL.getHost(), nextURL.getHost())) {
                throw new ServletException();
            }
            CommerceOrder commerceOrder = this._commercePaymentHttpHelper.getCommerceOrder(httpServletRequest);
            this._commerceOrderId = commerceOrder.getCommerceOrderId();
            if (!this._commerceCheckoutStepHttpHelper.isActivePaymentMethodCommerceCheckoutStep(httpServletRequest, commerceOrder)) {
                this._commercePaymentEngine.completePayment(this._commerceOrderId, null, httpServletRequest);
                httpServletResponse.sendRedirect(this._nextUrl);
                return;
            }
            CommercePaymentResult commercePaymentResult = this._startPayment(httpServletRequest);
            if (commercePaymentResult.isSuccess() && commercePaymentResult.isOnlineRedirect()) {
                URL redirectURL = new URL(commercePaymentResult.getRedirectUrl());
                if (Objects.equals(portalURL.getHost(), redirectURL.getHost())) {
                    Map<String, String> paramsMap = this._getQueryMap(redirectURL.getQuery());
                    Set<Map.Entry<String, String>> entries = paramsMap.entrySet();
                    for (Map.Entry<String, String> param : entries) {
                        httpServletRequest.setAttribute(param.getKey(), (Object)param.getValue());
                    }
                    RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(redirectURL.getPath());
                    requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                } else {
                    httpServletResponse.sendRedirect(redirectURL.toString());
                }
            }
            if (2 == (commercePaymentMethodType = this._commercePaymentEngine.getCommercePaymentMethodType(this._commerceOrderId)) || commercePaymentMethodType == -1) {
                this._commercePaymentEngine.completePayment(this._commerceOrderId, null, httpServletRequest);
                httpServletResponse.sendRedirect(this._nextUrl);
            }
            if (commercePaymentResult.isSuccess() && 0 == commercePaymentMethodType) {
                if (commerceOrder.isSubscriptionOrder()) {
                    this._commerceSubscriptionEngine.completeRecurringPayment(this._commerceOrderId, commercePaymentResult.getAuthTransactionId(), httpServletRequest);
                } else {
                    this._commercePaymentEngine.completePayment(this._commerceOrderId, commercePaymentResult.getAuthTransactionId(), httpServletRequest);
                }
                httpServletResponse.sendRedirect(this._nextUrl);
            }
            if (!commercePaymentResult.isSuccess() && !httpServletResponse.isCommitted()) {
                httpServletResponse.sendRedirect(this._nextUrl);
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            try {
                this._commercePaymentEngine.updateOrderPaymentStatus(this._commerceOrderId, 4, "", "");
                httpServletResponse.sendRedirect(this._nextUrl);
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
            }
        }
    }

    private Map<String, String> _getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(StringUtil.toUpperCase((String)CamelCaseUtil.fromCamelCase((String)name, (char)'_')), value);
        }
        return map;
    }

    private CommercePaymentResult _startPayment(HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(this._commerceOrderId);
        if (commerceOrder.isSubscriptionOrder() && !this._commercePaymentUtils.isDeliveryOnlySubscription(commerceOrder)) {
            return this._commerceSubscriptionEngine.processRecurringPayment(this._commerceOrderId, this._nextUrl, httpServletRequest);
        }
        return this._commercePaymentEngine.processPayment(this._commerceOrderId, this._nextUrl, httpServletRequest);
    }
}

