/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.engine;

import com.liferay.commerce.context.CommerceGroupThreadLocal;
import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderType;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelQualifierLocalService;
import com.liferay.commerce.payment.util.CommercePaymentUtils;
import com.liferay.commerce.payment.util.comparator.CommercePaymentMethodPriorityComparator;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderPaymentLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CommercePaymentEngine.class})
public class CommercePaymentEngineImpl
implements CommercePaymentEngine {
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderPaymentLocalService _commerceOrderPaymentLocalService;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private CommercePaymentMethodGroupRelQualifierLocalService _commercePaymentMethodGroupRelQualifierLocalService;
    @Reference
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @Reference
    private CommercePaymentUtils _commercePaymentUtils;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult cancelPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCancelEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId, transactionId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.cancelPayment(commercePaymentRequest);
        this.updateOrderPaymentStatus(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId(), String.valueOf(commercePaymentResult.getResultMessages()));
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult capturePayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCaptureEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId, transactionId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.capturePayment(commercePaymentRequest);
        this.updateOrderPaymentStatus(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId(), String.valueOf(commercePaymentResult.getResultMessages()));
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult completePayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        if (BigDecimal.ZERO.compareTo(commerceOrder.getTotal()) == 0) {
            this.updateOrderPaymentStatus(commerceOrderId, 0, transactionId, "");
            return this._commercePaymentUtils.emptyResult(commerceOrderId, transactionId);
        }
        if (commercePaymentMethod == null || !commercePaymentMethod.isCompleteEnabled()) {
            this._completeOrderWithoutPaymentMethod(commerceOrderId, httpServletRequest);
            return this._commercePaymentUtils.emptyResult(commerceOrderId, transactionId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.completePayment(commercePaymentRequest);
        this.updateOrderPaymentStatus(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId(), String.valueOf(commercePaymentResult.getResultMessages()));
        return commercePaymentResult;
    }

    public String getCommerceOrderPaymentMethodName(CommerceOrder commerceOrder, HttpServletRequest httpServletRequest, Locale locale) throws PortalException {
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (Validator.isNull((String)commercePaymentMethodKey)) {
            return "";
        }
        CommercePaymentMethodGroupRel commercePaymentMethod = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commerceOrder.getGroupId(), commercePaymentMethodKey);
        if (commercePaymentMethod == null) {
            return "";
        }
        String name = commercePaymentMethod.getName(locale);
        if (!commercePaymentMethod.isActive()) {
            name = StringBundler.concat((String[])new String[]{name, " (", this._language.get(httpServletRequest, "inactive"), ")"});
        }
        return name;
    }

    public int getCommercePaymentMethodGroupRelsCount(long groupId) {
        return this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRelsCount(groupId, true);
    }

    public int getCommercePaymentMethodType(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (commercePaymentMethodKey.isEmpty()) {
            return -1;
        }
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodKey);
        return commercePaymentMethod.getPaymentType();
    }

    public List<CommercePaymentMethod> getEnabledCommercePaymentMethodsForOrder(long groupId, long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        boolean subscriptionOrder = commerceOrder.isSubscriptionOrder();
        CommerceAddress commerceAddress = commerceOrder.getBillingAddress();
        if (commerceAddress == null) {
            commerceAddress = commerceOrder.getShippingAddress();
        }
        if (commerceAddress != null) {
            return this._getCommercePaymentMethodsList(this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, commerceAddress.getCountryId(), true), commerceOrder.getCommerceOrderTypeId(), subscriptionOrder);
        }
        return this._getCommercePaymentMethodsList(this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, true), commerceOrder.getCommerceOrderTypeId(), subscriptionOrder);
    }

    public String getPaymentMethodImageURL(long groupId, String paymentMethodKey, ThemeDisplay themeDisplay) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(groupId, paymentMethodKey);
        return commercePaymentMethodGroupRel.getImageURL(themeDisplay);
    }

    public String getPaymentMethodName(String paymentMethodKey, Locale locale) {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(paymentMethodKey);
        return commercePaymentMethod.getName(locale);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult partiallyRefundPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isPartialRefundEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId, transactionId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), null, null, httpServletRequest, commercePaymentMethod);
        return commercePaymentMethod.partiallyRefundPayment(commercePaymentRequest);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult postProcessPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        return this._commercePaymentUtils.emptyResult(commerceOrderId, transactionId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult processPayment(long commerceOrderId, String nextUrl, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessPaymentEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId, "");
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), null, nextUrl, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.processPayment(commercePaymentRequest);
        this.updateOrderPaymentStatus(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId(), String.valueOf(commercePaymentResult.getResultMessages()));
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult refundPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isRefundEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId, transactionId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        return commercePaymentMethod.refundPayment(commercePaymentRequest);
    }

    public CommerceOrder updateOrderPaymentStatus(long commerceOrderId, int paymentStatus, String transactionId, String result) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CommerceGroupThreadLocal.set((Group)this._groupLocalService.fetchGroup(commerceOrder.getGroupId()));
        commerceOrder = this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, paymentStatus, transactionId);
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, paymentStatus, result);
        if (paymentStatus == 0 && commerceOrder.getOrderStatus() != 1) {
            long userId = commerceOrder.getUserId();
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker != null) {
                userId = permissionChecker.getUserId();
            }
            commerceOrder = this._commerceOrderEngine.transitionCommerceOrder(commerceOrder, 1, userId);
        }
        return commerceOrder;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult voidTransaction(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isVoidEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId, transactionId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), null, null, httpServletRequest, commercePaymentMethod);
        return commercePaymentMethod.voidTransaction(commercePaymentRequest);
    }

    private void _completeOrderWithoutPaymentMethod(long commerceOrderId, HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CommerceGroupThreadLocal.set((Group)this._groupLocalService.fetchGroup(commerceOrder.getGroupId()));
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(this._portal.getUserId(httpServletRequest), commerceOrderId, 0, "");
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, 0, "");
    }

    private List<CommercePaymentMethod> _getCommercePaymentMethodsList(List<CommercePaymentMethodGroupRel> commercePaymentMethodGroupRels, long commerceOrderTypeId, boolean subscriptionOrder) {
        LinkedList<CommercePaymentMethod> commercePaymentMethods = new LinkedList<CommercePaymentMethod>();
        ListUtil.sort(commercePaymentMethodGroupRels, (Comparator)new CommercePaymentMethodPriorityComparator());
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            List commercePaymentMethodGroupRelQualifiers = this._commercePaymentMethodGroupRelQualifierLocalService.getCommercePaymentMethodGroupRelQualifiers(CommerceOrderType.class.getName(), commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
            if (commerceOrderTypeId > 0L && ListUtil.isNotEmpty((List)commercePaymentMethodGroupRelQualifiers) && !ListUtil.exists((List)commercePaymentMethodGroupRelQualifiers, commercePaymentMethodGroupRelQualifier -> {
                long classPK = commercePaymentMethodGroupRelQualifier.getClassPK();
                return classPK == commerceOrderTypeId;
            })) continue;
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodGroupRel.getEngineKey());
            if (!permissionChecker.hasPermission(commercePaymentMethodGroupRel.getGroupId(), CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId(), "VIEW") || subscriptionOrder && !commercePaymentMethod.isProcessRecurringEnabled()) continue;
            commercePaymentMethods.add(commercePaymentMethod);
        }
        return commercePaymentMethods;
    }
}

