/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.service.impl;

import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.base.CommercePaymentMethodGroupRelServiceBaseImpl;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceAddressRestrictionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommercePaymentMethodGroupRelServiceImpl
extends CommercePaymentMethodGroupRelServiceBaseImpl {
    private static volatile ModelResourcePermission<CommerceChannel> _commerceChannelModelResourcePermission = ModelResourcePermissionFactory.getInstance(CommercePaymentMethodGroupRelServiceImpl.class, (String)"_commerceChannelModelResourcePermission", CommerceChannel.class);
    @ServiceReference(type=CommerceAddressRestrictionLocalService.class)
    private CommerceAddressRestrictionLocalService _commerceAddressRestrictionLocalService;
    @ServiceReference(type=CommerceChannelLocalService.class)
    private CommerceChannelLocalService _commerceChannelLocalService;

    public CommerceAddressRestriction addCommerceAddressRestriction(long userId, long groupId, long classPK, long countryId) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.addCommerceAddressRestriction(userId, groupId, classPK, countryId);
    }

    @Deprecated
    public CommerceAddressRestriction addCommerceAddressRestriction(long classPK, long countryId, ServiceContext serviceContext) throws PortalException {
        return this.commercePaymentMethodGroupRelService.addCommerceAddressRestriction(serviceContext.getUserId(), serviceContext.getScopeGroupId(), classPK, countryId);
    }

    public CommercePaymentMethodGroupRel addCommercePaymentMethodGroupRel(long userId, long groupId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, String engineKey, double priority, boolean active) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.addCommercePaymentMethodGroupRel(userId, groupId, nameMap, descriptionMap, imageFile, engineKey, priority, active);
    }

    public void deleteCommerceAddressRestriction(long commerceAddressRestrictionId) throws PortalException {
        CommerceAddressRestriction commerceAddressRestriction = this._commerceAddressRestrictionLocalService.fetchCommerceAddressRestriction(commerceAddressRestrictionId);
        if (commerceAddressRestriction != null) {
            this._checkCommerceChannel(commerceAddressRestriction.getGroupId());
        }
        this.commercePaymentMethodGroupRelLocalService.deleteCommerceAddressRestriction(commerceAddressRestrictionId);
    }

    public void deleteCommerceAddressRestrictions(long commercePaymentMethodGroupRelId) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commercePaymentMethodGroupRelId);
        this._checkCommerceChannel(commercePaymentMethodGroupRel.getGroupId());
        this._commerceAddressRestrictionLocalService.deleteCommerceAddressRestrictions(CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
    }

    public void deleteCommercePaymentMethodGroupRel(long commercePaymentMethodGroupRelId) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commercePaymentMethodGroupRelId);
        this._checkCommerceChannel(commercePaymentMethodGroupRel.getGroupId());
        this.commercePaymentMethodGroupRelLocalService.deleteCommercePaymentMethodGroupRel(commercePaymentMethodGroupRel);
    }

    public CommercePaymentMethodGroupRel fetchCommercePaymentMethodGroupRel(long groupId, String engineKey) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(groupId, engineKey);
        if (commercePaymentMethodGroupRel != null) {
            this._checkCommerceChannel(commercePaymentMethodGroupRel.getGroupId());
        }
        return commercePaymentMethodGroupRel;
    }

    public List<CommerceAddressRestriction> getCommerceAddressRestrictions(long classPK, int start, int end, OrderByComparator<CommerceAddressRestriction> orderByComparator) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(classPK);
        if (commercePaymentMethodGroupRel == null) {
            return Collections.emptyList();
        }
        this._checkCommerceChannel(commercePaymentMethodGroupRel.getGroupId());
        return this.commercePaymentMethodGroupRelLocalService.getCommerceAddressRestrictions(classPK, start, end, orderByComparator);
    }

    public int getCommerceAddressRestrictionsCount(long classPK) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(classPK);
        if (commercePaymentMethodGroupRel == null) {
            return 0;
        }
        this._checkCommerceChannel(commercePaymentMethodGroupRel.getGroupId());
        return this.commercePaymentMethodGroupRelLocalService.getCommerceAddressRestrictionsCount(classPK);
    }

    public CommercePaymentMethodGroupRel getCommercePaymentMethodGroupRel(long commercePaymentMethodGroupRelId) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commercePaymentMethodGroupRelId);
        this._checkCommerceChannel(commercePaymentMethodGroupRel.getGroupId());
        return commercePaymentMethodGroupRel;
    }

    public CommercePaymentMethodGroupRel getCommercePaymentMethodGroupRel(long groupId, String engineKey) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(groupId, engineKey);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, boolean active) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, active);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, boolean active, int start, int end) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, active, start, end);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, boolean active, int start, int end, OrderByComparator<CommercePaymentMethodGroupRel> orderByComparator) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, active, start, end, orderByComparator);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, int start, int end, OrderByComparator<CommercePaymentMethodGroupRel> orderByComparator) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, start, end, orderByComparator);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, long countryId, boolean active) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, countryId, active);
    }

    public int getCommercePaymentMethodGroupRelsCount(long groupId) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRelsCount(groupId);
    }

    public int getCommercePaymentMethodGroupRelsCount(long groupId, boolean active) throws PortalException {
        this._checkCommerceChannel(groupId);
        return this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRelsCount(groupId, active);
    }

    public CommercePaymentMethodGroupRel setActive(long commercePaymentMethodGroupRelId, boolean active) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(commercePaymentMethodGroupRelId);
        if (commercePaymentMethodGroupRel != null) {
            this._checkCommerceChannel(commercePaymentMethodGroupRel.getGroupId());
        }
        return this.commercePaymentMethodGroupRelLocalService.setActive(commercePaymentMethodGroupRelId, active);
    }

    public CommercePaymentMethodGroupRel updateCommercePaymentMethodGroupRel(long commercePaymentMethodGroupRelId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, double priority, boolean active) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commercePaymentMethodGroupRelId);
        this._checkCommerceChannel(commercePaymentMethodGroupRel.getGroupId());
        return this.commercePaymentMethodGroupRelLocalService.updateCommercePaymentMethodGroupRel(commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId(), nameMap, descriptionMap, imageFile, priority, active);
    }

    private void _checkCommerceChannel(long groupId) throws PortalException {
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByGroupId(groupId);
        _commerceChannelModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceChannel, "UPDATE");
    }
}

