/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.upgrade.v1_0_1;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CommercePaymentMethodGroupRelUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;

    public CommercePaymentMethodGroupRelUpgradeProcess(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery("select CPaymentMethodGroupRelId, groupId from CommercePaymentMethodGroupRel");){
            PreparedStatement ps = null;
            while (rs.next()) {
                long cPaymentMethodGroupRelId = rs.getLong("CPaymentMethodGroupRelId");
                long groupId = rs.getLong("groupId");
                long channelGroupId = this._getCommerceChannelGroupIdBySiteGroupId(groupId);
                if (channelGroupId == 0L) continue;
                ps = this.connection.prepareStatement("update CommercePaymentMethodGroupRel set groupId = ? where CPaymentMethodGroupRelId = ?");
                ps.setLong(1, channelGroupId);
                ps.setLong(2, cPaymentMethodGroupRelId);
                ps.executeUpdate();
            }
        }
    }

    private long _getCommerceChannelGroupIdBySiteGroupId(long groupId) throws SQLException {
        long companyId = 0L;
        long commerceChannelId = 0L;
        String sql = "select * from CommerceChannel where siteGroupId = " + groupId;
        try (Statement s = this.connection.createStatement();){
            s.setMaxRows(1);
            try (ResultSet rs = s.executeQuery(sql);){
                if (rs.next()) {
                    companyId = rs.getLong("companyId");
                    commerceChannelId = rs.getLong("commerceChannelId");
                }
            }
        }
        long classNameId = this._classNameLocalService.getClassNameId(CommerceChannel.class.getName());
        Group group = this._groupLocalService.fetchGroup(companyId, classNameId, commerceChannelId);
        if (group != null) {
            return group.getGroupId();
        }
        return 0L;
    }
}

