/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.engine;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.model.CommerceOrderItem;
import com.liferay.commerce.model.CommerceSubscriptionEntry;
import com.liferay.commerce.payment.engine.CommerceSubscriptionEngine;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.request.CommercePaymentRequestProvider;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.util.CommercePaymentUtils;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderPaymentLocalService;
import com.liferay.commerce.service.CommerceSubscriptionEntryLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Portal;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceSubscriptionEngine.class})
public class CommerceSubscriptionEngineImpl
implements CommerceSubscriptionEngine {
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderPaymentLocalService _commerceOrderPaymentLocalService;
    @Reference
    private CommercePaymentUtils _commercePaymentUtils;
    @Reference
    private CommerceSubscriptionEntryLocalService _commerceSubscriptionEntryLocalService;
    @Reference
    private Portal _portal;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean activateRecurringDelivery(long commerceSubscriptionEntryId) throws Exception {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        if (Objects.equals(0, commerceSubscriptionEntry.getSubscriptionStatus())) {
            this._commerceSubscriptionEntryLocalService.updateDeliverySubscriptionStatus(commerceSubscriptionEntryId, 0);
            return true;
        }
        return false;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean activateRecurringPayment(long commerceSubscriptionEntryId) throws Exception {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        CommerceOrderItem commerceOrderItem = commerceSubscriptionEntry.fetchCommerceOrderItem();
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrder.getCommerceOrderId());
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessRecurringEnabled()) {
            return false;
        }
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._commercePaymentUtils.getCommercePaymentRequestProvider(commercePaymentMethod);
        CommercePaymentRequest commercePaymentRequest = commercePaymentRequestProvider.getCommercePaymentRequest(null, commerceOrder.getCommerceOrderId(), null, null, null, commerceOrder.getTransactionId());
        boolean activateSubscription = commercePaymentMethod.activateRecurringPayment(commercePaymentRequest);
        if (activateSubscription) {
            this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntry.getCommerceSubscriptionEntryId(), 0);
        }
        return activateSubscription;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean cancelRecurringDelivery(long commerceSubscriptionEntryId) throws Exception {
        this._commerceSubscriptionEntryLocalService.updateDeliverySubscriptionStatus(commerceSubscriptionEntryId, 2);
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean cancelRecurringPayment(long commerceSubscriptionEntryId) throws Exception {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        CommerceOrderItem commerceOrderItem = commerceSubscriptionEntry.fetchCommerceOrderItem();
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrder.getCommerceOrderId());
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessRecurringEnabled()) {
            return false;
        }
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._commercePaymentUtils.getCommercePaymentRequestProvider(commercePaymentMethod);
        CommercePaymentRequest commercePaymentRequest = commercePaymentRequestProvider.getCommercePaymentRequest(null, commerceOrder.getCommerceOrderId(), null, null, null, commerceOrder.getTransactionId());
        boolean activateSubscription = commercePaymentMethod.cancelRecurringPayment(commercePaymentRequest);
        if (activateSubscription) {
            this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntry.getCommerceSubscriptionEntryId(), 2);
        }
        return activateSubscription;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CommercePaymentResult completeRecurringPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCompleteRecurringEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.completeRecurringPayment(commercePaymentRequest);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), "");
        return commercePaymentResult;
    }

    public boolean getSubscriptionValidity(long commerceOrderId) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessRecurringEnabled()) {
            return false;
        }
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._commercePaymentUtils.getCommercePaymentRequestProvider(commercePaymentMethod);
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = commercePaymentRequestProvider.getCommercePaymentRequest(null, commerceOrderId, null, null, null, commerceOrder.getTransactionId());
        return commercePaymentMethod.getSubscriptionValidity(commercePaymentRequest);
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public CommercePaymentResult processRecurringPayment(long commerceOrderId, String checkoutStepUrl, HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessRecurringEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), null, checkoutStepUrl, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.processRecurringPayment(commercePaymentRequest);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), "");
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean suspendRecurringDelivery(long commerceSubscriptionEntryId) throws Exception {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        if (Objects.equals(0, commerceSubscriptionEntry.getSubscriptionStatus()) || Objects.equals(1, commerceSubscriptionEntry.getSubscriptionStatus())) {
            this._commerceSubscriptionEntryLocalService.updateDeliverySubscriptionStatus(commerceSubscriptionEntryId, 1);
            return true;
        }
        return false;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean suspendRecurringPayment(long commerceSubscriptionEntryId) throws Exception {
        CommerceSubscriptionEntry commerceSubscriptionEntry = this._commerceSubscriptionEntryLocalService.getCommerceSubscriptionEntry(commerceSubscriptionEntryId);
        CommerceOrderItem commerceOrderItem = commerceSubscriptionEntry.fetchCommerceOrderItem();
        CommerceOrder commerceOrder = commerceOrderItem.getCommerceOrder();
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrder.getCommerceOrderId());
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessRecurringEnabled()) {
            return false;
        }
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._commercePaymentUtils.getCommercePaymentRequestProvider(commercePaymentMethod);
        CommercePaymentRequest commercePaymentRequest = commercePaymentRequestProvider.getCommercePaymentRequest(null, commerceOrder.getCommerceOrderId(), null, null, null, commerceOrder.getTransactionId());
        boolean suspendSubscription = commercePaymentMethod.suspendRecurringPayment(commercePaymentRequest);
        if (suspendSubscription) {
            this._commerceSubscriptionEntryLocalService.updateSubscriptionStatus(commerceSubscriptionEntry.getCommerceSubscriptionEntryId(), 1);
        }
        return suspendSubscription;
    }
}

