/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.service.impl;

import com.liferay.commerce.model.CommerceAddressRestriction;
import com.liferay.commerce.payment.exception.CommercePaymentMethodGroupRelEngineKeyException;
import com.liferay.commerce.payment.exception.CommercePaymentMethodGroupRelNameException;
import com.liferay.commerce.payment.exception.NoSuchPaymentMethodGroupRelException;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.service.base.CommercePaymentMethodGroupRelLocalServiceBaseImpl;
import com.liferay.commerce.product.service.CPDefinitionLocalService;
import com.liferay.commerce.product.service.CommerceCatalogService;
import com.liferay.commerce.product.util.CPDefinitionHelper;
import com.liferay.commerce.service.CommerceAddressRestrictionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CommercePaymentMethodGroupRelLocalServiceImpl
extends CommercePaymentMethodGroupRelLocalServiceBaseImpl {
    @ServiceReference(type=CommerceAddressRestrictionLocalService.class)
    private CommerceAddressRestrictionLocalService _commerceAddressRestrictionLocalService;
    @ServiceReference(type=CommerceCatalogService.class)
    private CommerceCatalogService _commerceCatalogService;
    @ServiceReference(type=CommercePaymentMethodRegistry.class)
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @ServiceReference(type=CPDefinitionHelper.class)
    private CPDefinitionHelper _cpDefinitionHelper;
    @ServiceReference(type=CPDefinitionLocalService.class)
    private CPDefinitionLocalService _cpDefinitionLocalService;

    public CommerceAddressRestriction addCommerceAddressRestriction(long commercePaymentMethodGroupRelId, long commerceCountryId, ServiceContext serviceContext) throws PortalException {
        return this._commerceAddressRestrictionLocalService.addCommerceAddressRestriction(CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRelId, commerceCountryId, serviceContext);
    }

    public CommercePaymentMethodGroupRel addCommercePaymentMethodGroupRel(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, String engineKey, Map<String, String> engineParameterMap, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        if (imageFile != null && !imageFile.exists()) {
            imageFile = null;
        }
        this.validate(nameMap, engineKey);
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelPersistence.create(this.counterLocalService.increment());
        commercePaymentMethodGroupRel.setGroupId(serviceContext.getScopeGroupId());
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        commercePaymentMethodGroupRel.setCompanyId(user.getCompanyId());
        commercePaymentMethodGroupRel.setUserId(user.getUserId());
        commercePaymentMethodGroupRel.setUserName(user.getFullName());
        commercePaymentMethodGroupRel.setNameMap(nameMap);
        commercePaymentMethodGroupRel.setDescriptionMap(descriptionMap);
        if (imageFile != null) {
            commercePaymentMethodGroupRel.setImageId(this.counterLocalService.increment());
        }
        commercePaymentMethodGroupRel.setEngineKey(engineKey);
        commercePaymentMethodGroupRel.setPriority(priority);
        commercePaymentMethodGroupRel.setActive(active);
        commercePaymentMethodGroupRel = (CommercePaymentMethodGroupRel)this.commercePaymentMethodGroupRelPersistence.update((BaseModel)commercePaymentMethodGroupRel);
        if (imageFile != null) {
            this.imageLocalService.updateImage(commercePaymentMethodGroupRel.getImageId(), imageFile);
        }
        return commercePaymentMethodGroupRel;
    }

    public void deleteCommerceAddressRestriction(long commerceAddressRestrictionId) throws PortalException {
        this._commerceAddressRestrictionLocalService.deleteCommerceAddressRestriction(commerceAddressRestrictionId);
    }

    @Override
    public CommercePaymentMethodGroupRel deleteCommercePaymentMethodGroupRel(CommercePaymentMethodGroupRel commercePaymentMethodGroupRel) throws PortalException {
        this.commercePaymentMethodGroupRelPersistence.remove((BaseModel)commercePaymentMethodGroupRel);
        if (commercePaymentMethodGroupRel.getImageId() > 0L) {
            this.imageLocalService.deleteImage(commercePaymentMethodGroupRel.getImageId());
        }
        this._commerceAddressRestrictionLocalService.deleteCommerceAddressRestrictions(CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId());
        return commercePaymentMethodGroupRel;
    }

    @Override
    public CommercePaymentMethodGroupRel deleteCommercePaymentMethodGroupRel(long commercePaymentMethodGroupRelId) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelPersistence.findByPrimaryKey(commercePaymentMethodGroupRelId);
        return this.commercePaymentMethodGroupRelLocalService.deleteCommercePaymentMethodGroupRel(commercePaymentMethodGroupRel);
    }

    public void deleteCommercePaymentMethodGroupRels(long groupId) throws PortalException {
        List commercePaymentMethodGroupRels = this.commercePaymentMethodGroupRelPersistence.findByGroupId(groupId);
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            this.commercePaymentMethodGroupRelLocalService.deleteCommercePaymentMethodGroupRel(commercePaymentMethodGroupRel);
        }
    }

    public CommercePaymentMethodGroupRel fetchCommercePaymentMethodGroupRel(long groupId, String engineKey) {
        return this.commercePaymentMethodGroupRelPersistence.fetchByG_E(groupId, engineKey);
    }

    public List<CommerceAddressRestriction> getCommerceAddressRestrictions(long commercePaymentMethodGroupRelId, int start, int end, OrderByComparator<CommerceAddressRestriction> orderByComparator) {
        return this._commerceAddressRestrictionLocalService.getCommerceAddressRestrictions(CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRelId, start, end, orderByComparator);
    }

    public int getCommerceAddressRestrictionsCount(long commercePaymentMethodGroupRelId) {
        return this._commerceAddressRestrictionLocalService.getCommerceAddressRestrictionsCount(CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRelId);
    }

    public CommercePaymentMethodGroupRel getCommercePaymentMethodGroupRel(long groupId, String engineKey) throws NoSuchPaymentMethodGroupRelException {
        return this.commercePaymentMethodGroupRelPersistence.findByG_E(groupId, engineKey);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId) {
        return this.commercePaymentMethodGroupRelPersistence.findByGroupId(groupId);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, boolean active) {
        return this.commercePaymentMethodGroupRelPersistence.findByG_A(groupId, active);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, boolean active, int start, int end) {
        return this.commercePaymentMethodGroupRelPersistence.findByG_A(groupId, active, start, end);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, boolean active, int start, int end, OrderByComparator<CommercePaymentMethodGroupRel> orderByComparator) {
        return this.commercePaymentMethodGroupRelPersistence.findByG_A(groupId, active, start, end, orderByComparator);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, int start, int end, OrderByComparator<CommercePaymentMethodGroupRel> orderByComparator) {
        return this.commercePaymentMethodGroupRelPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommercePaymentMethodGroupRel> getCommercePaymentMethodGroupRels(long groupId, long commerceCountryId, boolean active) {
        ArrayList<CommercePaymentMethodGroupRel> filteredCommercePaymentMethodGroupRels = new ArrayList<CommercePaymentMethodGroupRel>();
        List commercePaymentMethodGroupRels = this.commercePaymentMethodGroupRelPersistence.findByG_A(groupId, active);
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            boolean restricted = this._commerceAddressRestrictionLocalService.isCommerceAddressRestricted(CommercePaymentMethodGroupRel.class.getName(), commercePaymentMethodGroupRel.getCommercePaymentMethodGroupRelId(), commerceCountryId);
            if (restricted) continue;
            filteredCommercePaymentMethodGroupRels.add(commercePaymentMethodGroupRel);
        }
        return filteredCommercePaymentMethodGroupRels;
    }

    public int getCommercePaymentMethodGroupRelsCount(long groupId) {
        return this.commercePaymentMethodGroupRelPersistence.countByGroupId(groupId);
    }

    public int getCommercePaymentMethodGroupRelsCount(long groupId, boolean active) {
        return this.commercePaymentMethodGroupRelPersistence.countByG_A(groupId, active);
    }

    public CommercePaymentMethodGroupRel setActive(long commercePaymentMethodGroupRelId, boolean active) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelPersistence.findByPrimaryKey(commercePaymentMethodGroupRelId);
        commercePaymentMethodGroupRel.setActive(active);
        return (CommercePaymentMethodGroupRel)this.commercePaymentMethodGroupRelPersistence.update((BaseModel)commercePaymentMethodGroupRel);
    }

    public CommercePaymentMethodGroupRel updateCommercePaymentMethodGroupRel(long commercePaymentMethodGroupRelId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, File imageFile, Map<String, String> engineParameterMap, double priority, boolean active, ServiceContext serviceContext) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this.commercePaymentMethodGroupRelPersistence.findByPrimaryKey(commercePaymentMethodGroupRelId);
        if (imageFile != null && !imageFile.exists()) {
            imageFile = null;
        }
        commercePaymentMethodGroupRel.setNameMap(nameMap);
        commercePaymentMethodGroupRel.setDescriptionMap(descriptionMap);
        if (imageFile != null && commercePaymentMethodGroupRel.getImageId() <= 0L) {
            commercePaymentMethodGroupRel.setImageId(this.counterLocalService.increment());
        }
        commercePaymentMethodGroupRel.setPriority(priority);
        commercePaymentMethodGroupRel.setActive(active);
        commercePaymentMethodGroupRel = (CommercePaymentMethodGroupRel)this.commercePaymentMethodGroupRelPersistence.update((BaseModel)commercePaymentMethodGroupRel);
        if (imageFile != null) {
            this.imageLocalService.updateImage(commercePaymentMethodGroupRel.getImageId(), imageFile);
        }
        return commercePaymentMethodGroupRel;
    }

    protected void validate(Map<Locale, String> nameMap, String engineKey) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        String name = nameMap.get(locale);
        if (Validator.isNull((String)name)) {
            throw new CommercePaymentMethodGroupRelNameException();
        }
        if (Validator.isNull((String)engineKey)) {
            throw new CommercePaymentMethodGroupRelEngineKeyException();
        }
    }
}

