/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.util;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.request.CommercePaymentRequestProvider;
import com.liferay.commerce.payment.request.CommercePaymentRequestProviderRegistry;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.payment.util.CommercePaymentUtils;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommercePaymentUtils.class})
public class CommercePaymentUtilsImpl
implements CommercePaymentUtils {
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @Reference
    private CommercePaymentRequestProviderRegistry _commercePaymentRequestProviderRegistry;
    @Reference
    private Portal _portal;

    public CommercePaymentResult emptyResult(long commerceOrderId) {
        return new CommercePaymentResult(null, commerceOrderId, -1, false, null, null, Collections.emptyList(), false);
    }

    public CommercePaymentMethod getCommercePaymentMethod(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (commercePaymentMethodKey.isEmpty()) {
            return null;
        }
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.fetchCommercePaymentMethodGroupRel(commerceChannel.getSiteGroupId(), commercePaymentMethodKey);
        if (commercePaymentMethodGroupRel != null && commercePaymentMethodGroupRel.isActive()) {
            return this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodGroupRel.getEngineKey());
        }
        return null;
    }

    public CommercePaymentRequest getCommercePaymentRequest(CommerceOrder commerceOrder, Locale locale, String transactionId, String checkoutStepUrl, HttpServletRequest httpServletRequest, CommercePaymentMethod commercePaymentMethod) throws PortalException {
        String cancelUrl = null;
        String returnUrl = null;
        if (1 == commercePaymentMethod.getPaymentType()) {
            cancelUrl = this._getCancelUrl(httpServletRequest, commerceOrder, checkoutStepUrl, commercePaymentMethod);
            returnUrl = this._getReturnUrl(httpServletRequest, commerceOrder, checkoutStepUrl, commercePaymentMethod);
        }
        CommercePaymentRequestProvider commercePaymentRequestProvider = this.getCommercePaymentRequestProvider(commercePaymentMethod);
        return commercePaymentRequestProvider.getCommercePaymentRequest(cancelUrl, commerceOrder.getCommerceOrderId(), httpServletRequest, locale, returnUrl, transactionId);
    }

    public CommercePaymentRequestProvider getCommercePaymentRequestProvider(CommercePaymentMethod commercePaymentMethod) {
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._commercePaymentRequestProviderRegistry.getCommercePaymentRequestProvider(commercePaymentMethod.getKey());
        if (commercePaymentRequestProvider == null) {
            commercePaymentRequestProvider = this._commercePaymentRequestProviderRegistry.getCommercePaymentRequestProvider("default");
        }
        return commercePaymentRequestProvider;
    }

    private StringBundler _getBaseUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod, int extraCapacity) {
        StringBundler sb = new StringBundler(extraCapacity + (Validator.isNotNull((String)redirect) ? 13 : 11));
        sb.append(this._portal.getPortalURL(httpServletRequest));
        sb.append(this._portal.getPathModule());
        sb.append('/');
        sb.append(commercePaymentMethod.getServletPath());
        sb.append('?');
        sb.append("groupId=");
        sb.append(commerceOrder.getGroupId());
        sb.append("&uuid=");
        sb.append(URLCodec.encodeURL((String)commerceOrder.getUuid()));
        if (Validator.isNotNull((String)redirect)) {
            sb.append("&redirect=");
            sb.append(URLCodec.encodeURL((String)redirect));
        }
        return sb;
    }

    private String _getCancelUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod) {
        StringBundler sb = this._getBaseUrl(httpServletRequest, commerceOrder, redirect, commercePaymentMethod, 1);
        sb.append("&cancel=true");
        return sb.toString();
    }

    private String _getReturnUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod) {
        StringBundler sb = this._getBaseUrl(httpServletRequest, commerceOrder, redirect, commercePaymentMethod, 0);
        return sb.toString();
    }
}

