/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.internal.engine;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.order.engine.CommerceOrderEngine;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.engine.CommerceSubscriptionEngine;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.request.CommercePaymentRequestProvider;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.result.CommerceSubscriptionStatusResult;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.payment.util.CommercePaymentUtils;
import com.liferay.commerce.payment.util.comparator.CommercePaymentMethodPriorityComparator;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderPaymentLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommercePaymentEngine.class})
public class CommercePaymentEngineImpl
implements CommercePaymentEngine {
    private static final Log _log = LogFactoryUtil.getLog(CommercePaymentEngineImpl.class);
    @Reference
    private CommerceOrderEngine _commerceOrderEngine;
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderPaymentLocalService _commerceOrderPaymentLocalService;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @Reference
    private CommercePaymentUtils _commercePaymentUtils;
    @Reference
    private CommerceSubscriptionEngine _commerceSubscriptionEngine;
    @Reference
    private Portal _portal;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult cancelPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCancelEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.cancelPayment(commercePaymentRequest);
        this.updateOrderPaymentStatus(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        return commercePaymentResult;
    }

    @Deprecated
    public CommercePaymentResult cancelRecurringPayment(long commerceOrderId) {
        try {
            CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
            boolean cancelRecurringPayment = this._commerceSubscriptionEngine.cancelRecurringPayment(commerceOrderId);
            return new CommercePaymentResult(commerceOrder.getTransactionId(), commerceOrderId, 8, false, null, null, Collections.emptyList(), cancelRecurringPayment);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult capturePayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCaptureEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.capturePayment(commercePaymentRequest);
        this.updateOrderPaymentStatus(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult completePayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCompleteEnabled()) {
            this._completeOrderWithoutPaymentMethod(commerceOrderId, httpServletRequest);
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.completePayment(commercePaymentRequest);
        CommerceOrder commerceOrder = this.updateOrderPaymentStatus(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        if (commercePaymentMethod.getPaymentType() == 2 && commerceOrder.getPaymentStatus() == 1) {
            this._commerceOrderEngine.transitionCommerceOrder(commerceOrder, 1, this._portal.getUserId(httpServletRequest));
        }
        return commercePaymentResult;
    }

    @Deprecated
    public CommercePaymentResult completeRecurringPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        return this._commerceSubscriptionEngine.completeRecurringPayment(commerceOrderId, transactionId, httpServletRequest);
    }

    public String getCommerceOrderPaymentMethodName(CommerceOrder commerceOrder, HttpServletRequest httpServletRequest, Locale locale) throws PortalException {
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (Validator.isNull((String)commercePaymentMethodKey)) {
            return "";
        }
        CommercePaymentMethodGroupRel commercePaymentMethod = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commerceOrder.getGroupId(), commercePaymentMethodKey);
        if (commercePaymentMethod == null) {
            return "";
        }
        String name = commercePaymentMethod.getName(locale);
        if (!commercePaymentMethod.isActive()) {
            name = StringBundler.concat((String[])new String[]{name, " (", LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"inactive"), ")"});
        }
        return name;
    }

    public int getCommercePaymentMethodGroupRelsCount(long groupId) {
        return this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRelsCount(groupId, true);
    }

    public int getCommercePaymentMethodType(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (commercePaymentMethodKey.isEmpty()) {
            return -1;
        }
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodKey);
        return commercePaymentMethod.getPaymentType();
    }

    @Deprecated
    public List<CommercePaymentMethod> getEnabledCommercePaymentMethodsForOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        boolean subscriptionOrder = commerceOrder.isSubscriptionOrder();
        CommerceAddress commerceAddress = commerceOrder.getBillingAddress();
        if (commerceAddress == null) {
            commerceAddress = commerceOrder.getShippingAddress();
        }
        if (commerceAddress != null) {
            return this._getCommercePaymentMethodsList(this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(commerceOrder.getGroupId(), commerceAddress.getCommerceCountryId(), true), subscriptionOrder);
        }
        return this._getCommercePaymentMethodsList(this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(commerceOrder.getGroupId(), true), subscriptionOrder);
    }

    public List<CommercePaymentMethod> getEnabledCommercePaymentMethodsForOrder(long groupId, long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        boolean subscriptionOrder = commerceOrder.isSubscriptionOrder();
        CommerceAddress commerceAddress = commerceOrder.getBillingAddress();
        if (commerceAddress == null) {
            commerceAddress = commerceOrder.getShippingAddress();
        }
        if (commerceAddress != null) {
            return this._getCommercePaymentMethodsList(this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, commerceAddress.getCommerceCountryId(), true), subscriptionOrder);
        }
        return this._getCommercePaymentMethodsList(this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(groupId, true), subscriptionOrder);
    }

    @Deprecated
    public int getOrderStatusUpdateMaxIntervalMinutes(long commerceOrderId) throws PortalException {
        return 0;
    }

    public String getPaymentMethodImageURL(ThemeDisplay themeDisplay, String paymentMethodKey) throws PortalException {
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(themeDisplay.getSiteGroupId(), paymentMethodKey);
        return commercePaymentMethodGroupRel.getImageURL(themeDisplay);
    }

    public String getPaymentMethodName(String paymentMethodKey, Locale locale) {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(paymentMethodKey);
        return commercePaymentMethod.getName(locale);
    }

    @Deprecated
    public CommerceSubscriptionStatusResult getSubscriptionPaymentDetails(long commerceOrderId) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessRecurringEnabled()) {
            return null;
        }
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._commercePaymentUtils.getCommercePaymentRequestProvider(commercePaymentMethod);
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = commercePaymentRequestProvider.getCommercePaymentRequest(null, commerceOrderId, null, null, null, commerceOrder.getTransactionId());
        return commercePaymentMethod.getSubscriptionPaymentDetails(commercePaymentRequest);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult partiallyRefundPayment(long commerceOrderId) {
        return this._commercePaymentUtils.emptyResult(commerceOrderId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult postProcessPayment(long commerceOrderId) throws Exception {
        return this._commercePaymentUtils.emptyResult(commerceOrderId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult processPayment(long commerceOrderId, String nextUrl, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessPaymentEnabled()) {
            this._completeOrderWithoutPaymentMethod(commerceOrderId, httpServletRequest);
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), null, nextUrl, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.processPayment(commercePaymentRequest);
        this.updateOrderPaymentStatus(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        return commercePaymentResult;
    }

    @Deprecated
    public CommercePaymentResult processRecurringPayment(long commerceOrderId, String nextUrl, HttpServletRequest httpServletRequest) throws Exception {
        return this._commerceSubscriptionEngine.processRecurringPayment(commerceOrderId, nextUrl, httpServletRequest);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult refundPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isRefundEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        return commercePaymentMethod.refundPayment(commercePaymentRequest);
    }

    public CommercePaymentResult startPayment(long commerceOrderId, String nextUrl, HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        if (commerceOrder.isSubscriptionOrder()) {
            return this.processRecurringPayment(commerceOrderId, nextUrl, httpServletRequest);
        }
        return this.processPayment(commerceOrderId, nextUrl, httpServletRequest);
    }

    @Deprecated
    public boolean suspendSubscription(long commerceSubscriptionEntryId) throws Exception {
        return this._commerceSubscriptionEngine.suspendRecurringPayment(commerceSubscriptionEntryId);
    }

    public CommerceOrder updateOrderPaymentStatus(long commerceOrderId, int paymentStatus, String transactionId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        commerceOrder = this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, paymentStatus, transactionId);
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, paymentStatus, "");
        return commerceOrder;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult voidTransaction(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentUtils.getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isVoidEnabled()) {
            return this._commercePaymentUtils.emptyResult(commerceOrderId);
        }
        CommercePaymentRequest commercePaymentRequest = this._commercePaymentUtils.getCommercePaymentRequest(this._commerceOrderLocalService.getCommerceOrder(commerceOrderId), this._portal.getLocale(httpServletRequest), null, null, httpServletRequest, commercePaymentMethod);
        return commercePaymentMethod.voidTransaction(commercePaymentRequest);
    }

    private void _completeOrderWithoutPaymentMethod(long commerceOrderId, HttpServletRequest httpServletRequest) throws PortalException {
        long userId = this._portal.getUserId(httpServletRequest);
        CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrder(commerceOrderId);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(userId, commerceOrderId, 0, "");
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, 0, "");
        this._commerceOrderEngine.transitionCommerceOrder(commerceOrder, 1, userId);
    }

    private List<CommercePaymentMethod> _getCommercePaymentMethodsList(List<CommercePaymentMethodGroupRel> commercePaymentMethodGroupRels, boolean subscriptionOrder) {
        ListUtil.sort(commercePaymentMethodGroupRels, (Comparator)new CommercePaymentMethodPriorityComparator());
        LinkedList<CommercePaymentMethod> commercePaymentMethods = new LinkedList<CommercePaymentMethod>();
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodGroupRel.getEngineKey());
            if (subscriptionOrder && !commercePaymentMethod.isProcessRecurringEnabled()) continue;
            commercePaymentMethods.add(commercePaymentMethod);
        }
        return commercePaymentMethods;
    }
}

