/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.servlet;

import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/commerce-payment", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.payment.servlet.CommercePaymentServlet", "osgi.http.whiteboard.servlet.pattern=/commerce-payment/*"}, service={Servlet.class})
public class CommercePaymentServlet
extends HttpServlet {
    private long _commerceOrderId;
    @Reference
    private CommercePaymentEngine _commercePaymentEngine;
    private String _confirmationStepUrl;
    @Reference
    private Portal _portal;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            int commercePaymentMethodType;
            HttpSession httpSession = httpServletRequest.getSession();
            if (PortalSessionThreadLocal.getHttpSession() == null) {
                PortalSessionThreadLocal.setHttpSession((HttpSession)httpSession);
            }
            User user = this._portal.getUser(httpServletRequest);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            this._commerceOrderId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"commerceOrderId");
            this._confirmationStepUrl = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"confirmationStep");
            CommercePaymentResult commercePaymentResult = this._startPayment(httpServletRequest);
            if (commercePaymentResult.isOnlineRedirect()) {
                httpServletResponse.sendRedirect(commercePaymentResult.getRedirectUrl());
            }
            if (2 == (commercePaymentMethodType = this._commercePaymentEngine.getCommercePaymentMethodType(this._commerceOrderId)) || commercePaymentMethodType == -1) {
                this._commercePaymentEngine.completePayment(this._commerceOrderId, null, httpServletRequest);
                httpServletResponse.sendRedirect(this._confirmationStepUrl);
            }
        }
        catch (Exception e) {
            this._portal.sendError(e, httpServletRequest, httpServletResponse);
        }
    }

    private CommercePaymentResult _startPayment(HttpServletRequest httpServletRequest) throws Exception {
        return this._commercePaymentEngine.startPayment(this._commerceOrderId, this._confirmationStepUrl, httpServletRequest);
    }
}

