/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.engine.impl;

import com.liferay.commerce.model.CommerceAddress;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.CommercePaymentMethodRegistry;
import com.liferay.commerce.payment.model.CommercePaymentMethodGroupRel;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.request.CommercePaymentRequestProvider;
import com.liferay.commerce.payment.request.CommercePaymentRequestProviderRegistry;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.payment.service.CommercePaymentMethodGroupRelLocalService;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.commerce.service.CommerceOrderPaymentLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommercePaymentEngine.class})
public class CommercePaymentEngineImpl
implements CommercePaymentEngine {
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommerceOrderPaymentLocalService _commerceOrderPaymentLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private CommercePaymentMethodGroupRelLocalService _commercePaymentMethodGroupRelLocalService;
    @Reference
    private CommercePaymentMethodRegistry _commercePaymentMethodRegistry;
    @Reference
    private CommercePaymentRequestProviderRegistry _commercePaymentRequestProviderRegistry;
    @Reference
    private Portal _portal;

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult cancelPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCancelEnabled()) {
            return this._emptyResult(commerceOrderId);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = this._getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.cancelPayment(commercePaymentRequest);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, 8, transactionId);
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), "");
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult cancelRecurringPayment(long commerceOrderId) {
        return new CommercePaymentResult(null, commerceOrderId, -1, false, null, null, Collections.emptyList(), false);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult capturePayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCaptureEnabled()) {
            return this._emptyResult(commerceOrderId);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = this._getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.capturePayment(commercePaymentRequest);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), "");
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult completePayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCompleteEnabled()) {
            this._completeOrderWithoutPaymentMethod(commerceOrderId);
            return this._emptyResult(commerceOrderId);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = this._getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.completePayment(commercePaymentRequest);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), "");
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult completeRecurringPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isCompleteRecurringEnabled()) {
            return this._emptyResult(commerceOrderId);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = this._getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.completeRecurringPayment(commercePaymentRequest);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, commercePaymentResult.getNewPaymentStatus(), "");
        return commercePaymentResult;
    }

    public String getCommerceOrderPaymentMethodName(CommerceOrder commerceOrder, HttpServletRequest httpServletRequest, Locale locale) throws PortalException {
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (Validator.isNull((String)commercePaymentMethodKey)) {
            return "";
        }
        CommercePaymentMethodGroupRel commercePaymentMethod = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commerceOrder.getGroupId(), commercePaymentMethodKey);
        if (commercePaymentMethod == null) {
            return "";
        }
        String name = commercePaymentMethod.getName(locale);
        if (!commercePaymentMethod.isActive()) {
            name = StringBundler.concat((String[])new String[]{name, " (", LanguageUtil.get((HttpServletRequest)httpServletRequest, (String)"inactive"), ")"});
        }
        return name;
    }

    public int getCommercePaymentMethodGroupRelsCount(long groupId) {
        return this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRelsCount(groupId, true);
    }

    public int getCommercePaymentMethodType(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (commercePaymentMethodKey.isEmpty()) {
            return -1;
        }
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodKey);
        return commercePaymentMethod.getPaymentType();
    }

    public List<CommercePaymentMethod> getEnabledCommercePaymentMethodsForOrder(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        boolean subscriptionOrder = commerceOrder.isSubscriptionOrder();
        CommerceAddress commerceAddress = commerceOrder.getBillingAddress();
        if (commerceAddress != null) {
            return this._getCommercePaymentMethodsList(this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(commerceOrder.getGroupId(), commerceAddress.getCommerceCountryId(), true), subscriptionOrder);
        }
        return this._getCommercePaymentMethodsList(this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRels(commerceOrder.getGroupId(), true), subscriptionOrder);
    }

    public String getPaymentMethodName(String paymentMethodKey, Locale locale) {
        CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(paymentMethodKey);
        return commercePaymentMethod.getName(locale);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult partiallyRefundPayment(long commerceOrderId) {
        return this._emptyResult(commerceOrderId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult postProcessPayment(long commerceOrderId) throws Exception {
        return this._emptyResult(commerceOrderId);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult processPayment(long commerceOrderId, String checkoutStepUrl, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessPaymentEnabled()) {
            return this._emptyResult(commerceOrderId);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = this._getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), null, checkoutStepUrl, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.processPayment(commercePaymentRequest);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult processRecurringPayment(long commerceOrderId, String checkoutStepUrl, HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        CommercePaymentMethod commercePaymentMethod = this._getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isProcessRecurringEnabled()) {
            return this._emptyResult(commerceOrderId);
        }
        CommercePaymentRequest commercePaymentRequest = this._getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), null, checkoutStepUrl, httpServletRequest, commercePaymentMethod);
        CommercePaymentResult commercePaymentResult = commercePaymentMethod.processRecurringPayment(commercePaymentRequest);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, commercePaymentResult.getNewPaymentStatus(), commercePaymentResult.getAuthTransactionId());
        return commercePaymentResult;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult refundPayment(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isRefundEnabled()) {
            return this._emptyResult(commerceOrderId);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = this._getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), transactionId, null, httpServletRequest, commercePaymentMethod);
        return commercePaymentMethod.refundPayment(commercePaymentRequest);
    }

    public CommercePaymentResult startPayment(long commerceOrderId, String checkoutStepUrl, HttpServletRequest httpServletRequest) throws Exception {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        if (commerceOrder.isSubscriptionOrder()) {
            return this.processRecurringPayment(commerceOrderId, checkoutStepUrl, httpServletRequest);
        }
        return this.processPayment(commerceOrderId, checkoutStepUrl, httpServletRequest);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false, rollbackFor={Exception.class})
    public CommercePaymentResult voidTransaction(long commerceOrderId, String transactionId, HttpServletRequest httpServletRequest) throws Exception {
        CommercePaymentMethod commercePaymentMethod = this._getCommercePaymentMethod(commerceOrderId);
        if (commercePaymentMethod == null || !commercePaymentMethod.isVoidEnabled()) {
            return this._emptyResult(commerceOrderId);
        }
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        CommercePaymentRequest commercePaymentRequest = this._getCommercePaymentRequest(commerceOrder, this._portal.getLocale(httpServletRequest), null, null, httpServletRequest, commercePaymentMethod);
        return commercePaymentMethod.voidTransaction(commercePaymentRequest);
    }

    private void _completeOrderWithoutPaymentMethod(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        this._commerceOrderLocalService.updatePaymentStatusAndTransactionId(commerceOrder.getUserId(), commerceOrderId, 0, "");
        this._commerceOrderPaymentLocalService.addCommerceOrderPayment(commerceOrderId, 0, "");
    }

    private CommercePaymentResult _emptyResult(long commerceOrderId) {
        return new CommercePaymentResult(null, commerceOrderId, -1, false, null, null, Collections.emptyList(), false);
    }

    private StringBundler _getBaseUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod, int extraCapacity) {
        StringBundler sb = new StringBundler(extraCapacity + (Validator.isNotNull((String)redirect) ? 13 : 11));
        sb.append(this._portal.getPortalURL(httpServletRequest));
        sb.append(this._portal.getPathModule());
        sb.append('/');
        sb.append(commercePaymentMethod.getServletPath());
        sb.append('?');
        sb.append("groupId=");
        sb.append(commerceOrder.getGroupId());
        sb.append("&uuid=");
        sb.append(URLCodec.encodeURL((String)commerceOrder.getUuid()));
        if (Validator.isNotNull((String)redirect)) {
            sb.append("&redirect=");
            sb.append(URLCodec.encodeURL((String)redirect));
        }
        return sb;
    }

    private String _getCancelUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod) {
        StringBundler sb = this._getBaseUrl(httpServletRequest, commerceOrder, redirect, commercePaymentMethod, 2);
        sb.append("&cancel=");
        sb.append("true");
        return sb.toString();
    }

    private CommercePaymentMethod _getCommercePaymentMethod(long commerceOrderId) throws PortalException {
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(commerceOrderId);
        String commercePaymentMethodKey = commerceOrder.getCommercePaymentMethodKey();
        if (commercePaymentMethodKey.isEmpty()) {
            return null;
        }
        CommercePaymentMethodGroupRel commercePaymentMethodGroupRel = this._commercePaymentMethodGroupRelLocalService.getCommercePaymentMethodGroupRel(commerceOrder.getGroupId(), commercePaymentMethodKey);
        if (commercePaymentMethodGroupRel != null && commercePaymentMethodGroupRel.isActive()) {
            return this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodGroupRel.getEngineKey());
        }
        return null;
    }

    private List<CommercePaymentMethod> _getCommercePaymentMethodsList(List<CommercePaymentMethodGroupRel> commercePaymentMethodGroupRels, boolean subscriptionOrder) {
        ArrayList<CommercePaymentMethod> commercePaymentMethods = new ArrayList<CommercePaymentMethod>();
        for (CommercePaymentMethodGroupRel commercePaymentMethodGroupRel : commercePaymentMethodGroupRels) {
            CommercePaymentMethod commercePaymentMethod = this._commercePaymentMethodRegistry.getCommercePaymentMethod(commercePaymentMethodGroupRel.getEngineKey());
            if (subscriptionOrder && !commercePaymentMethod.isProcessRecurringEnabled()) continue;
            commercePaymentMethods.add(commercePaymentMethod);
        }
        return commercePaymentMethods;
    }

    private CommercePaymentRequest _getCommercePaymentRequest(CommerceOrder commerceOrder, Locale locale, String transactionId, String checkoutStepUrl, HttpServletRequest httpServletRequest, CommercePaymentMethod commercePaymentMethod) throws PortalException {
        String cancelUrl = null;
        String returnUrl = null;
        if (1 == commercePaymentMethod.getPaymentType()) {
            cancelUrl = this._getCancelUrl(httpServletRequest, commerceOrder, checkoutStepUrl, commercePaymentMethod);
            returnUrl = this._getReturnUrl(httpServletRequest, commerceOrder, checkoutStepUrl, commercePaymentMethod);
        }
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._getCommercePaymentRequestProvider(commercePaymentMethod);
        return commercePaymentRequestProvider.getCommercePaymentRequest(cancelUrl, commerceOrder.getCommerceOrderId(), httpServletRequest, locale, returnUrl, transactionId);
    }

    private CommercePaymentRequestProvider _getCommercePaymentRequestProvider(CommercePaymentMethod commercePaymentMethod) {
        CommercePaymentRequestProvider commercePaymentRequestProvider = this._commercePaymentRequestProviderRegistry.getCommercePaymentRequestProvider(commercePaymentMethod.getKey());
        if (commercePaymentRequestProvider == null) {
            commercePaymentRequestProvider = this._commercePaymentRequestProviderRegistry.getCommercePaymentRequestProvider("default");
        }
        return commercePaymentRequestProvider;
    }

    private String _getReturnUrl(HttpServletRequest httpServletRequest, CommerceOrder commerceOrder, String redirect, CommercePaymentMethod commercePaymentMethod) {
        StringBundler sb = this._getBaseUrl(httpServletRequest, commerceOrder, redirect, commercePaymentMethod, 0);
        return sb.toString();
    }
}

