/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.payment.method.mercanet.internal.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Luca Pellizzon
 */
@ExtendedObjectClassDefinition(
	category = "payment", scope = ExtendedObjectClassDefinition.Scope.GROUP
)
@Meta.OCD(
	id = "com.liferay.commerce.payment.method.mercanet.internal.configuration.MercanetGroupServiceConfiguration",
	localization = "content/Language",
	name = "commerce-payment-method-mercanet-group-service-configuration-name"
)
public interface MercanetGroupServiceConfiguration {

	@Meta.AD(name = "merchant-id", required = false)
	public String merchantId();

	@Meta.AD(name = "environment", required = false)
	public String environment();

	@Meta.AD(name = "secret-key", required = false)
	public String secretKey();

	@Meta.AD(name = "key-version", required = false)
	public String keyVersion();

}