/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.payment.method.mercanet.internal.connector;

/**
 * @author Luca Pellizzon
 */
public enum Environment {

	PROD(
		"https://payment-webinit.mercanet.bnpparibas.net/rs-services/v2" +
			"/paymentInit"),
	SIMU(
		"https://payment-webinit.simu.mercanet.bnpparibas.net/rs-services/v2" +
			"/paymentInit"),
	TEST(
		"https://payment-webinit-mercanet.test.sips-atos.com/rs-services/v2" +
			"/paymentInit");

	public String getUrl() {
		return _url;
	}

	private Environment(String url) {
		_url = url;
	}

	private final String _url;

}