/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.method.mercanet.internal.connector;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.commerce.payment.method.mercanet.internal.connector.Environment;
import com.liferay.portal.kernel.util.Validator;
import com.worldline.sips.model.InitializationResponse;
import com.worldline.sips.model.PaymentRequest;
import com.worldline.sips.model.PaypageResponse;
import com.worldline.sips.util.SealCalculator;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class PaypageClient {
    private final Environment _environment;
    private final Integer _keyVersion;
    private final String _merchantId;
    private final String _secretKey;

    public PaypageClient(Environment environment, String merchantId, Integer keyVersion, String secretKey) throws Exception {
        if (environment == null) {
            throw new Exception("Invalid environment specified");
        }
        if (Validator.isBlank((String)merchantId)) {
            throw new Exception("Invalid merchant ID specified");
        }
        if (keyVersion == null) {
            throw new Exception("Invalid key version specified");
        }
        if (Validator.isBlank((String)secretKey)) {
            throw new Exception("Invalid key specified");
        }
        this._environment = environment;
        this._keyVersion = keyVersion;
        this._merchantId = merchantId;
        this._secretKey = secretKey;
    }

    public PaypageResponse decodeResponse(Map<String, String> parameters) throws Exception {
        this._verifySeal(parameters.get("Data"), parameters.get("Seal"));
        return (PaypageResponse)new ObjectMapper().convertValue(parameters, PaypageResponse.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InitializationResponse initialize(PaymentRequest paymentRequest) throws Exception {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        try (CloseableHttpClient httpClient = httpClientBuilder.build();){
            paymentRequest.setMerchantId(this._merchantId);
            paymentRequest.setKeyVersion(this._keyVersion);
            paymentRequest.setSeal(SealCalculator.calculate((String)SealCalculator.getSealString((PaymentRequest)paymentRequest), (String)this._secretKey));
            StringEntity requestEntity = new StringEntity(new ObjectMapper().writeValueAsString((Object)paymentRequest), ContentType.APPLICATION_JSON);
            HttpPost postMethod = new HttpPost(this._getEnvironmentUrl());
            postMethod.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse rawResponse = httpClient.execute((HttpUriRequest)postMethod);
            InitializationResponse initializationResponse = (InitializationResponse)new ObjectMapper().readValue(EntityUtils.toString((HttpEntity)rawResponse.getEntity()), InitializationResponse.class);
            this._verifySeal(initializationResponse);
            InitializationResponse initializationResponse2 = initializationResponse;
            return initializationResponse2;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new Exception("Exception while parsing PaymentRequest", e);
        }
        catch (IOException ioe) {
            throw new Exception("Exception while processing response from server", ioe);
        }
    }

    private URI _getEnvironmentUrl() {
        return URI.create(this._environment.getUrl());
    }

    private void _verifySeal(InitializationResponse initializationResponse) throws Exception {
        String correctSeal;
        if (initializationResponse.getSeal() != null && !Objects.equals(correctSeal = SealCalculator.calculate((String)SealCalculator.getSealString((InitializationResponse)initializationResponse), (String)this._secretKey), initializationResponse.getSeal())) {
            throw new Exception("The initialization response has been tampered with");
        }
    }

    private void _verifySeal(String data, String seal) throws Exception {
        String correctSeal = DigestUtils.sha256Hex((String)(data + this._secretKey));
        if (!Objects.equals(correctSeal, seal)) {
            throw new Exception("The payment page response has been tampered with");
        }
    }
}

