/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.method.mercanet.internal.servlet;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.method.mercanet.internal.configuration.MercanetGroupServiceConfiguration;
import com.liferay.commerce.payment.method.mercanet.internal.connector.Environment;
import com.liferay.commerce.payment.method.mercanet.internal.connector.PaypageClient;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.worldline.sips.model.PaypageResponse;
import com.worldline.sips.model.ResponseCode;
import com.worldline.sips.model.ResponseData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/mercanet-payment", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.payment.method.mercanet.internal.servlet.MercanetServlet", "osgi.http.whiteboard.servlet.pattern=/mercanet-payment/*"}, service={Servlet.class})
public class MercanetServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(MercanetServlet.class);
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommercePaymentEngine _commercePaymentEngine;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.web.symbolicname=com.liferay.commerce.payment.method.mercanet)")
    private ServletContext _servletContext;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            HttpSession httpSession = httpServletRequest.getSession();
            if (PortalSessionThreadLocal.getHttpSession() == null) {
                PortalSessionThreadLocal.setHttpSession((HttpSession)httpSession);
            }
            User user = this._portal.getUser(httpServletRequest);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher("/mercanet_form/mercanet-form.jsp");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String type = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"type");
            String data = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"Data");
            Map<String, String> parameterMap = this._getResponseParameters(data);
            if (Objects.equals("normal", type)) {
                HttpSession httpSession = httpServletRequest.getSession();
                if (PortalSessionThreadLocal.getHttpSession() == null) {
                    PortalSessionThreadLocal.setHttpSession((HttpSession)httpSession);
                }
                User user = this._portal.getUser(httpServletRequest);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
                if (!Objects.equals(parameterMap.get("responseCode"), "00")) {
                    String orderId = parameterMap.get("orderId");
                    long commerceOrderId = GetterUtil.getLong((String)orderId);
                    String transactionReference = parameterMap.get("transactionReference");
                    this._commercePaymentEngine.cancelPayment(commerceOrderId, transactionReference, httpServletRequest);
                }
                httpServletResponse.sendRedirect(redirect);
            }
            if (Objects.equals("automatic", type)) {
                long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
                String uuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"uuid");
                CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
                MercanetGroupServiceConfiguration mercanetGroupServiceConfiguration = this._getConfiguration(commerceOrder.getGroupId());
                String environment = StringUtil.toUpperCase((String)mercanetGroupServiceConfiguration.environment());
                String keyVersion = mercanetGroupServiceConfiguration.keyVersion();
                PaypageClient paypageClient = new PaypageClient(Environment.valueOf(environment), mercanetGroupServiceConfiguration.merchantId(), Integer.valueOf(keyVersion), mercanetGroupServiceConfiguration.secretKey());
                HashMap<String, String> verifyMap = new HashMap<String, String>();
                verifyMap.put("Data", data);
                String seal = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"Seal");
                verifyMap.put("Seal", seal);
                PaypageResponse paypageResponse = paypageClient.decodeResponse(verifyMap);
                ResponseData responseData = paypageResponse.getData();
                ResponseCode responseCode = responseData.getResponseCode();
                if (Objects.equals(responseCode.getCode(), "00") && Objects.equals(responseData.getMerchantId(), mercanetGroupServiceConfiguration.merchantId()) && Objects.equals(parameterMap.get("customerId"), String.valueOf(commerceOrder.getUserId())) && Objects.equals(parameterMap.get("orderId"), String.valueOf(commerceOrder.getCommerceOrderId())) && Objects.equals(responseData.getTransactionReference(), commerceOrder.getTransactionId())) {
                    this._commercePaymentEngine.completePayment(commerceOrder.getCommerceOrderId(), commerceOrder.getTransactionId(), httpServletRequest);
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private MercanetGroupServiceConfiguration _getConfiguration(Long groupId) throws ConfigurationException {
        return (MercanetGroupServiceConfiguration)this._configurationProvider.getConfiguration(MercanetGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId.longValue(), "com.liferay.commerce.payment.method.mercanet"));
    }

    private Map<String, String> _getResponseParameters(String data) {
        String[] params;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params = data.split("\\|")) {
            String[] kvp = StringUtil.split((String)param, (char)'=');
            map.put(kvp[0], kvp[1]);
        }
        return map;
    }
}

