/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.method.mercanet.internal;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.mercanet.internal.MercanetCommercePaymentRequest;
import com.liferay.commerce.payment.method.mercanet.internal.configuration.MercanetGroupServiceConfiguration;
import com.liferay.commerce.payment.method.mercanet.internal.connector.Environment;
import com.liferay.commerce.payment.method.mercanet.internal.connector.PaypageClient;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceChannelLocalService;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.worldline.sips.model.CaptureMode;
import com.worldline.sips.model.Currency;
import com.worldline.sips.model.InitializationResponse;
import com.worldline.sips.model.OrderChannel;
import com.worldline.sips.model.PaymentRequest;
import com.worldline.sips.model.RedirectionStatusCode;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.payment.engine.method.key=mercanet"}, service={CommercePaymentMethod.class})
public class MercanetCommercePaymentMethod
implements CommercePaymentMethod {
    public static final String KEY = "mercanet";
    @Reference
    private CommerceChannelLocalService _commerceChannelLocalService;
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;

    public CommercePaymentResult cancelPayment(CommercePaymentRequest commercePaymentRequest) throws Exception {
        MercanetCommercePaymentRequest mercanetCommercePaymentRequest = (MercanetCommercePaymentRequest)commercePaymentRequest;
        return new CommercePaymentResult(mercanetCommercePaymentRequest.getTransactionId(), mercanetCommercePaymentRequest.getCommerceOrderId(), 8, false, null, null, Collections.emptyList(), true);
    }

    public CommercePaymentResult completePayment(CommercePaymentRequest commercePaymentRequest) throws Exception {
        MercanetCommercePaymentRequest mercanetCommercePaymentRequest = (MercanetCommercePaymentRequest)commercePaymentRequest;
        return new CommercePaymentResult(mercanetCommercePaymentRequest.getTransactionId(), mercanetCommercePaymentRequest.getCommerceOrderId(), 0, false, null, null, Collections.emptyList(), true);
    }

    public String getDescription(Locale locale) {
        ResourceBundle resourceBundle = this._getResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"mercanet-description");
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        ResourceBundle resourceBundle = this._getResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)KEY);
    }

    public int getPaymentType() {
        return 1;
    }

    public String getServletPath() {
        return "mercanet-payment";
    }

    public boolean isCancelEnabled() {
        return true;
    }

    public boolean isCompleteEnabled() {
        return true;
    }

    public boolean isProcessPaymentEnabled() {
        return true;
    }

    public CommercePaymentResult processPayment(CommercePaymentRequest commercePaymentRequest) throws Exception {
        MercanetCommercePaymentRequest mercanetCommercePaymentRequest = (MercanetCommercePaymentRequest)commercePaymentRequest;
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(mercanetCommercePaymentRequest.getCommerceOrderId());
        CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        if (!Objects.equals(commerceCurrency.getCode(), "EUR")) {
            throw new Exception("Mercanet accepts only EUR currency");
        }
        PaymentRequest paymentRequest = new PaymentRequest();
        int normalizedMultiplier = (int)Math.pow(10.0, commerceCurrency.getMaxFractionDigits());
        BigDecimal orderTotal = commerceOrder.getTotal();
        BigDecimal normalizedOrderTotal = orderTotal.multiply(new BigDecimal(normalizedMultiplier));
        paymentRequest.setAmount(Integer.valueOf(normalizedOrderTotal.intValue()));
        URL returnUrl = new URL(mercanetCommercePaymentRequest.getReturnUrl());
        Map parameters = this._http.getParameterMap(returnUrl.getQuery());
        URL baseUrl = new URL(returnUrl.getProtocol(), returnUrl.getHost(), returnUrl.getPort(), returnUrl.getPath());
        StringBundler automaticUrlSB = new StringBundler(5);
        automaticUrlSB.append(baseUrl.toString());
        automaticUrlSB.append("?groupId=");
        automaticUrlSB.append(((String[])parameters.get("groupId"))[0]);
        automaticUrlSB.append("&type=automatic&uuid=");
        automaticUrlSB.append(((String[])parameters.get("uuid"))[0]);
        URL automaticUrl = new URL(automaticUrlSB.toString());
        paymentRequest.setAutomaticResponseUrl(automaticUrl);
        paymentRequest.setCaptureMode(CaptureMode.IMMEDIATE);
        paymentRequest.setCurrencyCode(Currency.EUR);
        paymentRequest.setCustomerId(String.valueOf(commerceOrder.getUserId()));
        StringBundler normalUrlSB = new StringBundler(4);
        normalUrlSB.append(baseUrl.toString());
        normalUrlSB.append("?redirect=");
        String encodeURL = URLCodec.encodeURL((String)((String[])parameters.get("redirect"))[0]);
        normalUrlSB.append(encodeURL);
        normalUrlSB.append("&type=normal");
        URL normalUrl = new URL(normalUrlSB.toString());
        paymentRequest.setNormalReturnUrl(normalUrl);
        paymentRequest.setOrderChannel(OrderChannel.INTERNET);
        paymentRequest.setOrderId(String.valueOf(commerceOrder.getCommerceOrderId()));
        String transactionUuid = PortalUUIDUtil.generate();
        String transactionId = transactionUuid.replace("-", "");
        paymentRequest.setTransactionReference(transactionId);
        CommerceChannel commerceChannel = this._commerceChannelLocalService.getCommerceChannelByOrderGroupId(commerceOrder.getGroupId());
        MercanetGroupServiceConfiguration mercanetGroupServiceConfiguration = this._getConfiguration(commerceChannel.getSiteGroupId());
        String environment = StringUtil.toUpperCase((String)mercanetGroupServiceConfiguration.environment());
        String keyVersion = mercanetGroupServiceConfiguration.keyVersion();
        PaypageClient paypageClient = new PaypageClient(Environment.valueOf(environment), mercanetGroupServiceConfiguration.merchantId(), Integer.valueOf(keyVersion), mercanetGroupServiceConfiguration.secretKey());
        InitializationResponse initializationResponse = paypageClient.initialize(paymentRequest);
        List<String> resultMessage = Collections.singletonList(initializationResponse.getRedirectionStatusMessage());
        RedirectionStatusCode responseCode = initializationResponse.getRedirectionStatusCode();
        if (!Objects.equals(responseCode.getCode(), "00")) {
            return new CommercePaymentResult(transactionId, commerceOrder.getCommerceOrderId(), 4, true, null, null, resultMessage, false);
        }
        URL redirectionUrl = initializationResponse.getRedirectionUrl();
        String url = StringBundler.concat((String[])new String[]{this._getServletUrl(mercanetCommercePaymentRequest), "?redirectUrl=", URLCodec.encodeURL((String)redirectionUrl.toString()), "&redirectionData=", URLEncoder.encode(initializationResponse.getRedirectionData(), "UTF-8"), "&seal=", URLEncoder.encode(initializationResponse.getSeal(), "UTF-8")});
        return new CommercePaymentResult(transactionId, commerceOrder.getCommerceOrderId(), 2, true, url, null, resultMessage, true);
    }

    private MercanetGroupServiceConfiguration _getConfiguration(long groupId) throws ConfigurationException {
        return (MercanetGroupServiceConfiguration)this._configurationProvider.getConfiguration(MercanetGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.commerce.payment.method.mercanet"));
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
    }

    private String _getServletUrl(MercanetCommercePaymentRequest mercanetCommercePaymentRequest) {
        return StringBundler.concat((String[])new String[]{this._portal.getPortalURL(mercanetCommercePaymentRequest.getHttpServletRequest()), this._portal.getPathModule(), "/", "mercanet-payment"});
    }
}

