/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.method.mercanet.internal;

import com.liferay.commerce.currency.model.CommerceCurrency;
import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.method.CommercePaymentMethod;
import com.liferay.commerce.payment.method.mercanet.internal.MercanetCommercePaymentRequest;
import com.liferay.commerce.payment.method.mercanet.internal.configuration.MercanetGroupServiceConfiguration;
import com.liferay.commerce.payment.method.mercanet.internal.connector.Environment;
import com.liferay.commerce.payment.method.mercanet.internal.connector.PaypageClient;
import com.liferay.commerce.payment.request.CommercePaymentRequest;
import com.liferay.commerce.payment.result.CommercePaymentResult;
import com.liferay.commerce.service.CommerceOrderService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.worldline.sips.model.CaptureMode;
import com.worldline.sips.model.Currency;
import com.worldline.sips.model.InitializationResponse;
import com.worldline.sips.model.OrderChannel;
import com.worldline.sips.model.PaymentRequest;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"commerce.payment.engine.method.key=mercanet"}, service={CommercePaymentMethod.class})
public class MercanetCommercePaymentMethod
implements CommercePaymentMethod {
    public static final String KEY = "mercanet";
    @Reference
    private CommerceOrderService _commerceOrderService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;

    public CommercePaymentResult completePayment(CommercePaymentRequest commercePaymentRequest) throws Exception {
        MercanetCommercePaymentRequest authorizeNetCommercePaymentRequest = (MercanetCommercePaymentRequest)commercePaymentRequest;
        return new CommercePaymentResult(null, authorizeNetCommercePaymentRequest.getCommerceOrderId(), 0, false, null, null, Collections.emptyList(), true);
    }

    public String getDescription(Locale locale) {
        ResourceBundle resourceBundle = this._getResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"mercanet-description");
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)KEY);
    }

    public int getPaymentType() {
        return 1;
    }

    public String getServletPath() {
        return "mercanet-payment";
    }

    public boolean isCompleteEnabled() {
        return true;
    }

    public boolean isProcessPaymentEnabled() {
        return true;
    }

    public CommercePaymentResult processPayment(CommercePaymentRequest commercePaymentRequest) throws Exception {
        MercanetCommercePaymentRequest mercanetCommercePaymentRequest = (MercanetCommercePaymentRequest)commercePaymentRequest;
        CommerceOrder commerceOrder = this._commerceOrderService.getCommerceOrder(mercanetCommercePaymentRequest.getCommerceOrderId());
        CommerceCurrency commerceCurrency = commerceOrder.getCommerceCurrency();
        if (!Objects.equals(commerceCurrency.getCode(), "EUR")) {
            throw new Exception("Mercanet acccept only EUR currency");
        }
        PaymentRequest paymentRequest = new PaymentRequest();
        int normalizedMultiplier = (int)Math.pow(10.0, commerceCurrency.getMaxFractionDigits());
        BigDecimal orderTotal = commerceOrder.getTotal();
        BigDecimal powOrderTotal = orderTotal.multiply(new BigDecimal(normalizedMultiplier));
        paymentRequest.setAmount(Integer.valueOf(powOrderTotal.intValue()));
        URL returnUrl = new URL(mercanetCommercePaymentRequest.getReturnUrl());
        Map<String, String> parameters = this._getQueryMap(returnUrl.getQuery());
        URL baseUrl = new URL(returnUrl.getProtocol(), returnUrl.getHost(), returnUrl.getPort(), returnUrl.getPath());
        StringBuilder normalUrl = new StringBuilder(baseUrl.toString());
        normalUrl.append("?");
        normalUrl.append("type=normal");
        normalUrl.append("&");
        normalUrl.append("redirect=");
        normalUrl.append(parameters.get("redirect"));
        StringBuilder automaticUrl = new StringBuilder(baseUrl.toString());
        automaticUrl.append("?");
        automaticUrl.append("type=automatic");
        automaticUrl.append("&");
        automaticUrl.append("groupId=");
        automaticUrl.append(parameters.get("groupId"));
        automaticUrl.append("&");
        automaticUrl.append("uuid=");
        automaticUrl.append(parameters.get("uuid"));
        URL normalURL = new URL(normalUrl.toString());
        URL automaticURL = new URL(automaticUrl.toString());
        paymentRequest.setAutomaticResponseUrl(automaticURL);
        paymentRequest.setNormalReturnUrl(normalURL);
        paymentRequest.setCaptureMode(CaptureMode.IMMEDIATE);
        paymentRequest.setCurrencyCode(Currency.EUR);
        paymentRequest.setCustomerId(String.valueOf(commerceOrder.getUserId()));
        paymentRequest.setOrderChannel(OrderChannel.INTERNET);
        paymentRequest.setOrderId(String.valueOf(commerceOrder.getCommerceOrderId()));
        StringBuilder transactionReference = new StringBuilder();
        transactionReference.append(commerceOrder.getCompanyId());
        transactionReference.append(commerceOrder.getGroupId());
        transactionReference.append(commerceOrder.getCommerceOrderId());
        paymentRequest.setTransactionReference(transactionReference.toString());
        MercanetGroupServiceConfiguration mercanetGroupServiceConfiguration = this._getConfiguration(commerceOrder.getGroupId());
        String environment = mercanetGroupServiceConfiguration.environment();
        String upperCaseEnvironment = StringUtil.toUpperCase((String)environment);
        String keyVersion = mercanetGroupServiceConfiguration.keyVersion();
        PaypageClient paypageClient = new PaypageClient(Environment.valueOf(upperCaseEnvironment), mercanetGroupServiceConfiguration.merchantId(), Integer.valueOf(keyVersion), mercanetGroupServiceConfiguration.secretKey());
        InitializationResponse initializationResponse = paypageClient.initialize(paymentRequest);
        URL redirectionUrl = initializationResponse.getRedirectionUrl();
        String url = StringBundler.concat((String[])new String[]{this._getServletUrl(mercanetCommercePaymentRequest), "?", "redirectUrl=", redirectionUrl.toString(), "&", "redirectionData=", URLEncoder.encode(initializationResponse.getRedirectionData(), "UTF-8"), "&", "seal=", URLEncoder.encode(initializationResponse.getSeal(), "UTF-8")});
        List<String> resultMessage = Collections.singletonList(initializationResponse.getRedirectionStatusMessage());
        return new CommercePaymentResult(transactionReference.toString(), commerceOrder.getCommerceOrderId(), -1, true, url, null, resultMessage, true);
    }

    private MercanetGroupServiceConfiguration _getConfiguration(Long groupId) throws ConfigurationException {
        return (MercanetGroupServiceConfiguration)this._configurationProvider.getConfiguration(MercanetGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId.longValue(), "com.liferay.commerce.payment.method.mercanet"));
    }

    private Map<String, String> _getQueryMap(String query) {
        String[] params = query.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }

    private ResourceBundle _getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
    }

    private String _getServletUrl(MercanetCommercePaymentRequest authorizeNetCommercePaymentRequest) {
        return StringBundler.concat((String[])new String[]{this._portal.getPortalURL(authorizeNetCommercePaymentRequest.getHttpServletRequest()), this._portal.getPathModule(), "/", "mercanet-payment"});
    }
}

