/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.payment.method.mercanet.internal.servlet;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.payment.engine.CommercePaymentEngine;
import com.liferay.commerce.payment.method.mercanet.internal.configuration.MercanetGroupServiceConfiguration;
import com.liferay.commerce.payment.method.mercanet.internal.connector.Environment;
import com.liferay.commerce.payment.method.mercanet.internal.connector.PaypageClient;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.worldline.sips.model.PaypageResponse;
import com.worldline.sips.model.ResponseCode;
import com.worldline.sips.model.ResponseData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.path=/mercanet-payment", "osgi.http.whiteboard.servlet.name=com.liferay.commerce.payment.method.mercanet.internal.servlet.MercanetServlet", "osgi.http.whiteboard.servlet.pattern=/mercanet-payment/*"}, service={Servlet.class})
public class MercanetServlet
extends HttpServlet {
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private CommercePaymentEngine _commercePaymentEngine;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private Portal _portal;
    @Reference(target="(osgi.web.symbolicname=com.liferay.commerce.payment.method.mercanet)")
    private ServletContext _servletContext;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            HttpSession httpSession = httpServletRequest.getSession();
            if (PortalSessionThreadLocal.getHttpSession() == null) {
                PortalSessionThreadLocal.setHttpSession((HttpSession)httpSession);
            }
            User user = this._portal.getUser(httpServletRequest);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher("/mercanet_form/mercanet-form.jsp");
            requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Exception e) {
            this._portal.sendError(e, httpServletRequest, httpServletResponse);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        try {
            String type = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"type");
            if (Objects.equals("normal", type)) {
                HttpSession httpSession = httpServletRequest.getSession();
                if (PortalSessionThreadLocal.getHttpSession() == null) {
                    PortalSessionThreadLocal.setHttpSession((HttpSession)httpSession);
                }
                User user = this._portal.getUser(httpServletRequest);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                String redirect = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"redirect");
                httpServletResponse.sendRedirect(redirect);
            }
            if (Objects.equals("automatic", type)) {
                long groupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"groupId");
                String uuid = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"uuid");
                String data = httpServletRequest.getParameter("Data");
                Map<String, String> parametersMap = this._getResponseParameters(data);
                CommerceOrder commerceOrder = this._commerceOrderLocalService.getCommerceOrderByUuidAndGroupId(uuid, groupId);
                MercanetGroupServiceConfiguration mercanetGroupServiceConfiguration = this._getConfiguration(commerceOrder.getGroupId());
                String environment = mercanetGroupServiceConfiguration.environment();
                String upperCaseEnvironment = StringUtil.toUpperCase((String)environment);
                String keyVersion = mercanetGroupServiceConfiguration.keyVersion();
                PaypageClient paypageClient = new PaypageClient(Environment.valueOf(upperCaseEnvironment), mercanetGroupServiceConfiguration.merchantId(), Integer.valueOf(keyVersion), mercanetGroupServiceConfiguration.secretKey());
                String seal = httpServletRequest.getParameter("Seal");
                HashMap<String, String> verifyMap = new HashMap<String, String>();
                verifyMap.put("Data", data);
                verifyMap.put("Seal", seal);
                PaypageResponse paypageResponse = paypageClient.decodeResponse(verifyMap);
                ResponseData responseData = paypageResponse.getData();
                StringBuilder transactionReference = new StringBuilder();
                transactionReference.append(commerceOrder.getCompanyId());
                transactionReference.append(commerceOrder.getGroupId());
                transactionReference.append(commerceOrder.getCommerceOrderId());
                ResponseCode responseCode = responseData.getResponseCode();
                if (Objects.equals(responseCode.getCode(), "00") && Objects.equals(responseData.getMerchantId(), mercanetGroupServiceConfiguration.merchantId()) && Objects.equals(parametersMap.get("customerId"), String.valueOf(commerceOrder.getUserId())) && Objects.equals(parametersMap.get("orderId"), String.valueOf(commerceOrder.getCommerceOrderId())) && Objects.equals(responseData.getTransactionReference(), transactionReference.toString())) {
                    this._commercePaymentEngine.completePayment(commerceOrder.getCommerceOrderId(), transactionReference.toString(), httpServletRequest);
                }
            }
        }
        catch (Exception e) {
            this._portal.sendError(e, httpServletRequest, httpServletResponse);
        }
    }

    private MercanetGroupServiceConfiguration _getConfiguration(Long groupId) throws ConfigurationException {
        return (MercanetGroupServiceConfiguration)this._configurationProvider.getConfiguration(MercanetGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId.longValue(), "com.liferay.commerce.payment.method.mercanet"));
    }

    private Map<String, String> _getResponseParameters(String data) {
        String[] params = data.split("\\|");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String param : params) {
            String name = param.split("=")[0];
            String value = param.split("=")[1];
            map.put(name, value);
        }
        return map;
    }
}

