/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.notification.model.impl;

import com.liferay.commerce.notification.model.CommerceNotificationAttachment;
import com.liferay.commerce.notification.service.CommerceNotificationAttachmentLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceNotificationAttachment service. Represents a row in the &quot;CNotificationAttachment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceNotificationAttachmentImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceNotificationAttachmentImpl
 * @see CommerceNotificationAttachment
 * @deprecated
 * @generated
 */
@Deprecated
public abstract class CommerceNotificationAttachmentBaseImpl
	extends CommerceNotificationAttachmentModelImpl
	implements CommerceNotificationAttachment {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce notification attachment model instance should use the <code>CommerceNotificationAttachment</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceNotificationAttachmentLocalServiceUtil.
				addCommerceNotificationAttachment(this);
		}
		else {
			CommerceNotificationAttachmentLocalServiceUtil.
				updateCommerceNotificationAttachment(this);
		}
	}

}