/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.notification.internal.instance.lifecycle;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.rest.dto.v1_0.NotificationTemplate;
import com.liferay.notification.rest.dto.v1_0.util.NotificationUtil;
import com.liferay.notification.service.NotificationTemplateLocalService;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagListener;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=-2147483648"}, service={PortalInstanceLifecycleListener.class})
public class AddCommerceOrderNotificationPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(AddCommerceOrderNotificationPortalInstanceLifecycleListener.class);
    @Reference
    private NotificationTemplateLocalService _notificationTemplateLocalService;
    @Reference(target="(component.name=com.liferay.notification.internal.type.EmailNotificationType)")
    private NotificationType _notificationType;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    private ServiceRegistration<FeatureFlagListener> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        block3: {
            if (!FeatureFlagManagerUtil.isEnabled((long)company.getCompanyId(), (String)"LPD-24498")) {
                return;
            }
            try {
                this._verifyCommerceOrderNotificationTemplate(company.getCompanyId());
                this._verifyCommerceOrderObjectAction(company.getCompanyId());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(FeatureFlagListener.class, (Object)new FeatureFlagListenerImpl(), MapUtil.singletonDictionary((Object)"featureFlagKey", (Object)"LPD-24498"));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private User _getAdminUser(long companyId) throws Exception {
        Role role = this._roleLocalService.getRole(companyId, "Administrator");
        List users = this._userLocalService.getRoleUsers(role.getRoleId());
        if (users.isEmpty()) {
            throw new NoSuchUserException(StringBundler.concat((Object[])new Object[]{"No user exists in company ", companyId, " with role ", role.getName()}));
        }
        return (User)users.get(0);
    }

    private void _verifyCommerceOrderNotificationTemplate(long companyId) throws Exception {
        com.liferay.notification.model.NotificationTemplate serviceBuilderNotificationTemplate = this._notificationTemplateLocalService.fetchNotificationTemplateByExternalReferenceCode("L_COMMERCE_ORDER_TEMPLATE", companyId);
        if (this._notificationType == null || serviceBuilderNotificationTemplate != null) {
            return;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        URL url = clazz.getResource("dependencies/notification-template.json");
        URLConnection urlConnection = url.openConnection();
        String json = StringUtil.read((InputStream)urlConnection.getInputStream());
        if (Validator.isNull((String)json)) {
            return;
        }
        NotificationTemplate notificationTemplate = NotificationTemplate.toDTO((String)json);
        NotificationContext notificationContext = NotificationUtil.toNotificationContext((NotificationTemplate)notificationTemplate, (ObjectFieldLocalService)this._objectFieldLocalService);
        User user = this._getAdminUser(companyId);
        notificationContext.setNotificationRecipient(NotificationUtil.toNotificationRecipient((User)user, (long)0L));
        notificationContext.setNotificationRecipientSettings(NotificationUtil.toNotificationRecipientSetting((long)0L, (NotificationType)this._notificationTypeServiceTracker.getNotificationType(notificationTemplate.getType()), (Object[])notificationTemplate.getRecipients(), (User)user));
        notificationContext.setNotificationTemplate(NotificationUtil.toNotificationTemplate((long)0L, (NotificationTemplate)notificationTemplate, (ObjectDefinitionLocalService)this._objectDefinitionLocalService, (User)user));
        this._notificationTemplateLocalService.addNotificationTemplate(notificationContext);
    }

    private void _verifyCommerceOrderObjectAction(long companyId) throws Exception {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode("L_COMMERCE_ORDER", companyId);
        if (objectDefinition == null) {
            return;
        }
        ObjectAction objectAction = this._objectActionLocalService.fetchObjectAction("L_COMMERCE_ORDER_NOTIFICATION", objectDefinition.getObjectDefinitionId());
        if (objectAction != null) {
            return;
        }
        User user = this._getAdminUser(companyId);
        this._objectActionLocalService.addObjectAction("L_COMMERCE_ORDER_NOTIFICATION", user.getUserId(), objectDefinition.getObjectDefinitionId(), false, "orderStatus == 1", "", null, Collections.singletonMap(LocaleUtil.getDefault(), "Commerce Order Notification"), "commerceOrderNotification", "notification", "liferay/commerce_order_status", UnicodePropertiesBuilder.create((boolean)true).put("notificationTemplateExternalReferenceCode", "L_COMMERCE_ORDER_TEMPLATE").put("type", "email").build(), false);
    }

    private class FeatureFlagListenerImpl
    implements FeatureFlagListener {
        private FeatureFlagListenerImpl() {
        }

        public void onValue(long companyId, String featureFlagKey, boolean enabled) {
            block3: {
                if (!enabled) {
                    return;
                }
                try {
                    AddCommerceOrderNotificationPortalInstanceLifecycleListener.this._verifyCommerceOrderNotificationTemplate(companyId);
                    AddCommerceOrderNotificationPortalInstanceLifecycleListener.this._verifyCommerceOrderObjectAction(companyId);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block3;
                    _log.debug((Throwable)exception);
                }
            }
        }
    }
}

