/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.notification.service.impl;

import com.liferay.commerce.notification.exception.CommerceNotificationTemplateFromException;
import com.liferay.commerce.notification.exception.CommerceNotificationTemplateNameException;
import com.liferay.commerce.notification.exception.CommerceNotificationTemplateTypeException;
import com.liferay.commerce.notification.model.CommerceNotificationTemplate;
import com.liferay.commerce.notification.service.CommerceNotificationQueueEntryLocalService;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateCommerceAccountGroupRelLocalService;
import com.liferay.commerce.notification.service.base.CommerceNotificationTemplateLocalServiceBaseImpl;
import com.liferay.commerce.notification.type.CommerceNotificationType;
import com.liferay.commerce.notification.type.CommerceNotificationTypeRegistry;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"model.class.name=com.liferay.commerce.notification.model.CommerceNotificationTemplate"}, service={AopService.class})
public class CommerceNotificationTemplateLocalServiceImpl
extends CommerceNotificationTemplateLocalServiceBaseImpl {
    @Reference
    private CommerceNotificationQueueEntryLocalService _commerceNotificationQueueEntryLocalService;
    @Reference
    private CommerceNotificationTemplateCommerceAccountGroupRelLocalService _commerceNotificationTemplateCommerceAccountGroupRelLocalService;
    @Reference
    private CommerceNotificationTypeRegistry _commerceNotificationTypeRegistry;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CommerceNotificationTemplate addCommerceNotificationTemplate(long userId, long groupId, String name, String description, String from, Map<Locale, String> fromNameMap, String to, String cc, String bcc, String type, boolean enabled, Map<Locale, String> subjectMap, Map<Locale, String> bodyMap, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this._validate(name, from, type);
        long commerceNotificationTemplateId = this.counterLocalService.increment();
        CommerceNotificationTemplate commerceNotificationTemplate = this.commerceNotificationTemplatePersistence.create(commerceNotificationTemplateId);
        commerceNotificationTemplate.setGroupId(groupId);
        commerceNotificationTemplate.setCompanyId(user.getCompanyId());
        commerceNotificationTemplate.setUserId(user.getUserId());
        commerceNotificationTemplate.setUserName(user.getFullName());
        commerceNotificationTemplate.setName(name);
        commerceNotificationTemplate.setDescription(description);
        commerceNotificationTemplate.setFrom(from);
        commerceNotificationTemplate.setFromNameMap(fromNameMap);
        commerceNotificationTemplate.setTo(to);
        commerceNotificationTemplate.setCc(cc);
        commerceNotificationTemplate.setBcc(bcc);
        commerceNotificationTemplate.setType(type);
        commerceNotificationTemplate.setEnabled(enabled);
        commerceNotificationTemplate.setSubjectMap(subjectMap);
        commerceNotificationTemplate.setBodyMap(bodyMap);
        commerceNotificationTemplate.setExpandoBridgeAttributes(serviceContext);
        commerceNotificationTemplate = (CommerceNotificationTemplate)this.commerceNotificationTemplatePersistence.update((BaseModel)commerceNotificationTemplate);
        this._resourceLocalService.addModelResources((AuditedModel)commerceNotificationTemplate, serviceContext);
        return commerceNotificationTemplate;
    }

    @Deprecated
    public CommerceNotificationTemplate addCommerceNotificationTemplate(String name, String description, String from, Map<Locale, String> fromNameMap, String to, String cc, String bcc, String type, boolean enabled, Map<Locale, String> subjectMap, Map<Locale, String> bodyMap, ServiceContext serviceContext) throws PortalException {
        return this.commerceNotificationTemplateLocalService.addCommerceNotificationTemplate(serviceContext.getUserId(), serviceContext.getScopeGroupId(), name, description, from, fromNameMap, to, cc, bcc, type, enabled, subjectMap, bodyMap, serviceContext);
    }

    @Override
    @SystemEvent(type=1)
    public CommerceNotificationTemplate deleteCommerceNotificationTemplate(CommerceNotificationTemplate commerceNotificationTemplate) throws PortalException {
        this._commerceNotificationQueueEntryLocalService.updateCommerceNotificationQueueEntriesTemplateIds(commerceNotificationTemplate.getCommerceNotificationTemplateId());
        this._commerceNotificationTemplateCommerceAccountGroupRelLocalService.deleteCNTemplateCommerceAccountGroupRelsByCommerceNotificationTemplateId(commerceNotificationTemplate.getCommerceNotificationTemplateId());
        this.commerceNotificationTemplatePersistence.remove((BaseModel)commerceNotificationTemplate);
        this._resourceLocalService.deleteResource(commerceNotificationTemplate.getCompanyId(), CommerceNotificationTemplate.class.getName(), 4, commerceNotificationTemplate.getCommerceNotificationTemplateId());
        this._expandoRowLocalService.deleteRows(commerceNotificationTemplate.getCommerceNotificationTemplateId());
        return commerceNotificationTemplate;
    }

    @Override
    public CommerceNotificationTemplate deleteCommerceNotificationTemplate(long commerceNotificationTemplateId) throws PortalException {
        CommerceNotificationTemplate commerceNotificationTemplate = this.commerceNotificationTemplatePersistence.findByPrimaryKey(commerceNotificationTemplateId);
        return this.commerceNotificationTemplateLocalService.deleteCommerceNotificationTemplate(commerceNotificationTemplate);
    }

    public void deleteCommerceNotificationTemplates(long groupId) throws PortalException {
        List commerceNotificationTemplates = this.commerceNotificationTemplatePersistence.findByGroupId(groupId);
        for (CommerceNotificationTemplate commerceNotificationTemplate : commerceNotificationTemplates) {
            this.commerceNotificationTemplateLocalService.deleteCommerceNotificationTemplate(commerceNotificationTemplate);
        }
    }

    public List<CommerceNotificationTemplate> getCommerceNotificationTemplates(long groupId, boolean enabled, int start, int end, OrderByComparator<CommerceNotificationTemplate> orderByComparator) {
        return this.commerceNotificationTemplatePersistence.findByG_E(groupId, enabled, start, end, orderByComparator);
    }

    public List<CommerceNotificationTemplate> getCommerceNotificationTemplates(long groupId, int start, int end, OrderByComparator<CommerceNotificationTemplate> orderByComparator) {
        return this.commerceNotificationTemplatePersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<CommerceNotificationTemplate> getCommerceNotificationTemplates(long groupId, String type, boolean enabled) {
        return this.commerceNotificationTemplatePersistence.findByG_T_E(groupId, type, enabled);
    }

    public int getCommerceNotificationTemplatesCount(long groupId) {
        return this.commerceNotificationTemplatePersistence.countByGroupId(groupId);
    }

    public int getCommerceNotificationTemplatesCount(long groupId, boolean enabled) {
        return this.commerceNotificationTemplatePersistence.countByG_E(groupId, enabled);
    }

    public CommerceNotificationTemplate updateCommerceNotificationTemplate(long commerceNotificationTemplateId, String name, String description, String from, Map<Locale, String> fromNameMap, String to, String cc, String bcc, String type, boolean enabled, Map<Locale, String> subjectMap, Map<Locale, String> bodyMap, ServiceContext serviceContext) throws PortalException {
        CommerceNotificationTemplate commerceNotificationTemplate = this.commerceNotificationTemplatePersistence.findByPrimaryKey(commerceNotificationTemplateId);
        this._validate(name, from, type);
        commerceNotificationTemplate.setName(name);
        commerceNotificationTemplate.setDescription(description);
        commerceNotificationTemplate.setFrom(from);
        commerceNotificationTemplate.setFromNameMap(fromNameMap);
        commerceNotificationTemplate.setTo(to);
        commerceNotificationTemplate.setCc(cc);
        commerceNotificationTemplate.setBcc(bcc);
        commerceNotificationTemplate.setType(type);
        commerceNotificationTemplate.setEnabled(enabled);
        commerceNotificationTemplate.setSubjectMap(subjectMap);
        commerceNotificationTemplate.setBodyMap(bodyMap);
        commerceNotificationTemplate.setExpandoBridgeAttributes(serviceContext);
        return (CommerceNotificationTemplate)this.commerceNotificationTemplatePersistence.update((BaseModel)commerceNotificationTemplate);
    }

    private void _validate(String name, String from, String type) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CommerceNotificationTemplateNameException();
        }
        if (Validator.isNull((String)from)) {
            throw new CommerceNotificationTemplateFromException();
        }
        CommerceNotificationType commerceNotificationType = this._commerceNotificationTypeRegistry.getCommerceNotificationType(type);
        if (commerceNotificationType == null) {
            throw new CommerceNotificationTemplateTypeException();
        }
    }
}

