/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.notification.internal.messaging;

import com.liferay.commerce.notification.internal.configuration.CommerceNotificationQueueEntryConfiguration;
import com.liferay.commerce.notification.service.CommerceNotificationQueueEntryLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.SystemSettingsLocator;
import java.util.Date;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.commerce.notification.internal.configuration.CommerceNotificationQueueConfiguration"}, enabled=false, immediate=true, service={CheckCommerceNotificationQueueEntryMessageListener.class})
public class CheckCommerceNotificationQueueEntryMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(CheckCommerceNotificationQueueEntryMessageListener.class);
    private volatile CommerceNotificationQueueEntryConfiguration _commerceNotificationQueueEntryConfiguration;
    @Reference
    private CommerceNotificationQueueEntryLocalService _commerceNotificationQueueEntryLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    @Activate
    @Modified
    protected void activate() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        String className = clazz.getName();
        try {
            this._commerceNotificationQueueEntryConfiguration = (CommerceNotificationQueueEntryConfiguration)this._configurationProvider.getConfiguration(CommerceNotificationQueueEntryConfiguration.class, (SettingsLocator)new SystemSettingsLocator("com.liferay.commerce.notification"));
        }
        catch (ConfigurationException configurationException) {
            _log.error((Object)configurationException, (Throwable)configurationException);
        }
        Trigger trigger = this._triggerFactory.createTrigger(className, className, null, null, this._commerceNotificationQueueEntryConfiguration.checkInterval(), TimeUnit.MINUTE);
        SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl(className, trigger);
        this._schedulerEngineHelper.register((MessageListener)this, (SchedulerEntry)schedulerEntry, "liferay/scheduler_dispatch");
    }

    @Deactivate
    protected void deactivate() {
        this._schedulerEngineHelper.unregister((MessageListener)this);
    }

    protected void doReceive(Message message) throws Exception {
        this._commerceNotificationQueueEntryLocalService.sendCommerceNotificationQueueEntries();
        int deleteInterval = this._commerceNotificationQueueEntryConfiguration.deleteInterval();
        Date date = new Date(System.currentTimeMillis() - (long)deleteInterval * 60000L);
        this._commerceNotificationQueueEntryLocalService.deleteCommerceNotificationQueueEntries(date);
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

