/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.notification.internal.util;

import com.liferay.commerce.notification.model.CommerceNotificationTemplate;
import com.liferay.commerce.notification.service.CommerceNotificationQueueEntryLocalService;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateLocalService;
import com.liferay.commerce.notification.type.CommerceNotificationType;
import com.liferay.commerce.notification.type.CommerceNotificationTypeRegistry;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.order.CommerceDefinitionTermContributor;
import com.liferay.commerce.order.CommerceDefinitionTermContributorRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, service={CommerceNotificationHelper.class})
public class CommerceNotificationHelperImpl
implements CommerceNotificationHelper {
    private static final int _BODYFIELD = 2;
    private static final int _SUBJECTFIELD = 1;
    private static final int _TOFIELD = 3;
    private static final Log _log = LogFactoryUtil.getLog(CommerceNotificationHelperImpl.class);
    private static final Pattern _placeholderPattern = Pattern.compile("\\[%[^\\[%]+%\\]", 2);
    @Reference
    private CommerceDefinitionTermContributorRegistry _commerceDefinitionTermContributorRegistry;
    @Reference
    private CommerceNotificationQueueEntryLocalService _commerceNotificationQueueEntryLocalService;
    @Reference
    private CommerceNotificationTemplateLocalService _commerceNotificationTemplateLocalService;
    @Reference
    private CommerceNotificationTypeRegistry _commerceNotificationTypeRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void sendNotifications(long groupId, long userId, String key, Object object) throws PortalException {
        if (Validator.isBlank((String)key)) {
            return;
        }
        CommerceNotificationType commerceNotificationType = this._commerceNotificationTypeRegistry.getCommerceNotificationType(key);
        if (commerceNotificationType == null) {
            return;
        }
        List commerceNotificationTemplates = this._commerceNotificationTemplateLocalService.getCommerceNotificationTemplates(groupId, commerceNotificationType.getKey(), true);
        for (CommerceNotificationTemplate commerceNotificationTemplate : commerceNotificationTemplates) {
            this.sendNotification(userId, commerceNotificationTemplate, commerceNotificationType, object);
        }
    }

    protected String formatString(CommerceNotificationType commerceNotificationType, int fieldType, String content, Object object, Locale locale) throws PortalException {
        if (Validator.isNull((String)content)) {
            return "";
        }
        HashSet<String> placeholders = new HashSet<String>();
        Matcher matcher = _placeholderPattern.matcher(content);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        List definitionTermContributors = fieldType == 3 ? this._commerceDefinitionTermContributorRegistry.getDefinitionTermContributorsByContributorKey("RecipientTerms") : this._commerceDefinitionTermContributorRegistry.getDefinitionTermContributorsByNotificationTypeKey(commerceNotificationType.getKey());
        for (CommerceDefinitionTermContributor definitionTermContributor : definitionTermContributors) {
            for (String placeholder : placeholders) {
                content = StringUtil.replace((String)content, (String)placeholder, (String)definitionTermContributor.getFilledTerm(placeholder, object, locale));
            }
        }
        return content;
    }

    protected void sendNotification(long userId, CommerceNotificationTemplate commerceNotificationTemplate, CommerceNotificationType commerceNotificationType, Object object) throws PortalException {
        String[] toUserStrings;
        long groupId = commerceNotificationTemplate.getGroupId();
        User user = this._userLocalService.getUser(userId);
        Locale siteDefaultLocale = this._portal.getSiteDefaultLocale(groupId);
        Locale userLocale = user.getLocale();
        String fromName = commerceNotificationTemplate.getFromName(user.getLanguageId());
        String subject = this.formatString(commerceNotificationType, 1, commerceNotificationTemplate.getSubject(userLocale), object, userLocale);
        String body = this.formatString(commerceNotificationType, 2, commerceNotificationTemplate.getBody(userLocale), object, userLocale);
        if (Validator.isNull((String)fromName)) {
            fromName = commerceNotificationTemplate.getFromName(this._portal.getSiteDefaultLocale(groupId));
        }
        if (Validator.isNull((String)subject)) {
            subject = this.formatString(commerceNotificationType, 1, commerceNotificationTemplate.getSubject(siteDefaultLocale), object, siteDefaultLocale);
        }
        if (Validator.isNull((String)body)) {
            this.formatString(commerceNotificationType, 2, commerceNotificationTemplate.getBody(siteDefaultLocale), object, siteDefaultLocale);
        }
        String to = this.formatString(commerceNotificationType, 3, commerceNotificationTemplate.getTo(), object, userLocale);
        EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
        for (String toUserString : toUserStrings = StringUtil.split((String)to)) {
            User toUser = this._userLocalService.fetchUser(GetterUtil.getLong((String)toUserString));
            if (toUser == null && emailAddressValidator.validate(user.getCompanyId(), toUserString)) {
                toUser = this._userLocalService.fetchUserByEmailAddress(user.getCompanyId(), toUserString);
            }
            if (toUser == null) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("No User found with key: " + toUserString));
                continue;
            }
            this._addNotificationQueueEntry(groupId, commerceNotificationType, commerceNotificationTemplate, fromName, toUser, subject, body, object);
        }
    }

    private void _addNotificationQueueEntry(long groupId, CommerceNotificationType commerceNotificationType, CommerceNotificationTemplate commerceNotificationTemplate, String fromName, User toUser, String subject, String body, Object object) throws PortalException {
        this._commerceNotificationQueueEntryLocalService.addCommerceNotificationQueueEntry(toUser.getUserId(), groupId, commerceNotificationType.getClassName(object), commerceNotificationType.getClassPK(object), commerceNotificationTemplate.getCommerceNotificationTemplateId(), commerceNotificationTemplate.getFrom(), fromName, toUser.getEmailAddress(), toUser.getFullName(), commerceNotificationTemplate.getCc(), commerceNotificationTemplate.getBcc(), subject, body, 0.0);
    }
}

