/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.notification.model.impl;

import com.liferay.commerce.notification.model.CommerceNotificationQueueEntry;
import com.liferay.commerce.notification.model.CommerceNotificationQueueEntryModel;
import com.liferay.commerce.notification.model.CommerceNotificationQueueEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceNotificationQueueEntry service. Represents a row in the &quot;CommerceNotificationQueueEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceNotificationQueueEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceNotificationQueueEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceNotificationQueueEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceNotificationQueueEntryModelImpl
	extends BaseModelImpl<CommerceNotificationQueueEntry>
	implements CommerceNotificationQueueEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce notification queue entry model instance should use the <code>CommerceNotificationQueueEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceNotificationQueueEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"CNotificationQueueEntryId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT},
		{"commerceNotificationTemplateId", Types.BIGINT},
		{"from_", Types.VARCHAR}, {"fromName", Types.VARCHAR},
		{"to_", Types.VARCHAR}, {"toName", Types.VARCHAR},
		{"cc", Types.VARCHAR}, {"bcc", Types.VARCHAR},
		{"subject", Types.VARCHAR}, {"body", Types.CLOB},
		{"priority", Types.DOUBLE}, {"sent", Types.BOOLEAN},
		{"sentDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("CNotificationQueueEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceNotificationTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("from_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fromName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("to_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("toName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("cc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("bcc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("body", Types.CLOB);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("sent", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("sentDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceNotificationQueueEntry (CNotificationQueueEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,commerceNotificationTemplateId LONG,from_ VARCHAR(75) null,fromName VARCHAR(75) null,to_ VARCHAR(75) null,toName VARCHAR(75) null,cc VARCHAR(255) null,bcc VARCHAR(255) null,subject VARCHAR(255) null,body TEXT null,priority DOUBLE,sent BOOLEAN,sentDate DATE null)";

	public static final String TABLE_SQL_DROP =
		"drop table CommerceNotificationQueueEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceNotificationQueueEntry.priority DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceNotificationQueueEntry.priority DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean ENTITY_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean FINDER_CACHE_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static final boolean COLUMN_BITMASK_ENABLED = true;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMMERCENOTIFICATIONTEMPLATEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SENT_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SENTDATE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PRIORITY_COLUMN_BITMASK = 64L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static CommerceNotificationQueueEntry toModel(
		CommerceNotificationQueueEntrySoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommerceNotificationQueueEntry model =
			new CommerceNotificationQueueEntryImpl();

		model.setCommerceNotificationQueueEntryId(
			soapModel.getCommerceNotificationQueueEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setCommerceNotificationTemplateId(
			soapModel.getCommerceNotificationTemplateId());
		model.setFrom(soapModel.getFrom());
		model.setFromName(soapModel.getFromName());
		model.setTo(soapModel.getTo());
		model.setToName(soapModel.getToName());
		model.setCc(soapModel.getCc());
		model.setBcc(soapModel.getBcc());
		model.setSubject(soapModel.getSubject());
		model.setBody(soapModel.getBody());
		model.setPriority(soapModel.getPriority());
		model.setSent(soapModel.isSent());
		model.setSentDate(soapModel.getSentDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<CommerceNotificationQueueEntry> toModels(
		CommerceNotificationQueueEntrySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceNotificationQueueEntry> models =
			new ArrayList<CommerceNotificationQueueEntry>(soapModels.length);

		for (CommerceNotificationQueueEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"));

	public CommerceNotificationQueueEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceNotificationQueueEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceNotificationQueueEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceNotificationQueueEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceNotificationQueueEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceNotificationQueueEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationQueueEntry, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceNotificationQueueEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceNotificationQueueEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceNotificationQueueEntry, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceNotificationQueueEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceNotificationQueueEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceNotificationQueueEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map
		<String, Function<CommerceNotificationQueueEntry, Object>>
			_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<CommerceNotificationQueueEntry, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<CommerceNotificationQueueEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String,
					 Function<CommerceNotificationQueueEntry, Object>>();
		Map<String, BiConsumer<CommerceNotificationQueueEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceNotificationQueueEntry, ?>>();

		attributeGetterFunctions.put(
			"commerceNotificationQueueEntryId",
			CommerceNotificationQueueEntry::
				getCommerceNotificationQueueEntryId);
		attributeSetterBiConsumers.put(
			"commerceNotificationQueueEntryId",
			(BiConsumer<CommerceNotificationQueueEntry, Long>)
				CommerceNotificationQueueEntry::
					setCommerceNotificationQueueEntryId);
		attributeGetterFunctions.put(
			"groupId", CommerceNotificationQueueEntry::getGroupId);
		attributeSetterBiConsumers.put(
			"groupId",
			(BiConsumer<CommerceNotificationQueueEntry, Long>)
				CommerceNotificationQueueEntry::setGroupId);
		attributeGetterFunctions.put(
			"companyId", CommerceNotificationQueueEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<CommerceNotificationQueueEntry, Long>)
				CommerceNotificationQueueEntry::setCompanyId);
		attributeGetterFunctions.put(
			"userId", CommerceNotificationQueueEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<CommerceNotificationQueueEntry, Long>)
				CommerceNotificationQueueEntry::setUserId);
		attributeGetterFunctions.put(
			"userName", CommerceNotificationQueueEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", CommerceNotificationQueueEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<CommerceNotificationQueueEntry, Date>)
				CommerceNotificationQueueEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", CommerceNotificationQueueEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<CommerceNotificationQueueEntry, Date>)
				CommerceNotificationQueueEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"classNameId", CommerceNotificationQueueEntry::getClassNameId);
		attributeSetterBiConsumers.put(
			"classNameId",
			(BiConsumer<CommerceNotificationQueueEntry, Long>)
				CommerceNotificationQueueEntry::setClassNameId);
		attributeGetterFunctions.put(
			"classPK", CommerceNotificationQueueEntry::getClassPK);
		attributeSetterBiConsumers.put(
			"classPK",
			(BiConsumer<CommerceNotificationQueueEntry, Long>)
				CommerceNotificationQueueEntry::setClassPK);
		attributeGetterFunctions.put(
			"commerceNotificationTemplateId",
			CommerceNotificationQueueEntry::getCommerceNotificationTemplateId);
		attributeSetterBiConsumers.put(
			"commerceNotificationTemplateId",
			(BiConsumer<CommerceNotificationQueueEntry, Long>)
				CommerceNotificationQueueEntry::
					setCommerceNotificationTemplateId);
		attributeGetterFunctions.put(
			"from", CommerceNotificationQueueEntry::getFrom);
		attributeSetterBiConsumers.put(
			"from",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setFrom);
		attributeGetterFunctions.put(
			"fromName", CommerceNotificationQueueEntry::getFromName);
		attributeSetterBiConsumers.put(
			"fromName",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setFromName);
		attributeGetterFunctions.put(
			"to", CommerceNotificationQueueEntry::getTo);
		attributeSetterBiConsumers.put(
			"to",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setTo);
		attributeGetterFunctions.put(
			"toName", CommerceNotificationQueueEntry::getToName);
		attributeSetterBiConsumers.put(
			"toName",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setToName);
		attributeGetterFunctions.put(
			"cc", CommerceNotificationQueueEntry::getCc);
		attributeSetterBiConsumers.put(
			"cc",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setCc);
		attributeGetterFunctions.put(
			"bcc", CommerceNotificationQueueEntry::getBcc);
		attributeSetterBiConsumers.put(
			"bcc",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setBcc);
		attributeGetterFunctions.put(
			"subject", CommerceNotificationQueueEntry::getSubject);
		attributeSetterBiConsumers.put(
			"subject",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setSubject);
		attributeGetterFunctions.put(
			"body", CommerceNotificationQueueEntry::getBody);
		attributeSetterBiConsumers.put(
			"body",
			(BiConsumer<CommerceNotificationQueueEntry, String>)
				CommerceNotificationQueueEntry::setBody);
		attributeGetterFunctions.put(
			"priority", CommerceNotificationQueueEntry::getPriority);
		attributeSetterBiConsumers.put(
			"priority",
			(BiConsumer<CommerceNotificationQueueEntry, Double>)
				CommerceNotificationQueueEntry::setPriority);
		attributeGetterFunctions.put(
			"sent", CommerceNotificationQueueEntry::getSent);
		attributeSetterBiConsumers.put(
			"sent",
			(BiConsumer<CommerceNotificationQueueEntry, Boolean>)
				CommerceNotificationQueueEntry::setSent);
		attributeGetterFunctions.put(
			"sentDate", CommerceNotificationQueueEntry::getSentDate);
		attributeSetterBiConsumers.put(
			"sentDate",
			(BiConsumer<CommerceNotificationQueueEntry, Date>)
				CommerceNotificationQueueEntry::setSentDate);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getCommerceNotificationQueueEntryId() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setCommerceNotificationQueueEntryId(
		long commerceNotificationQueueEntryId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceNotificationQueueEntryId = commerceNotificationQueueEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classNameId = classNameId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassNameId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("classNameId"));
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_classPK = classPK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalClassPK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("classPK"));
	}

	@JSON
	@Override
	public long getCommerceNotificationTemplateId() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setCommerceNotificationTemplateId(
		long commerceNotificationTemplateId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_commerceNotificationTemplateId = commerceNotificationTemplateId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCommerceNotificationTemplateId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue(
				"commerceNotificationTemplateId"));
	}

	@JSON
	@Override
	public String getFrom() {
		if (_from == null) {
			return "";
		}
		else {
			return _from;
		}
	}

	@Override
	public void setFrom(String from) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_from = from;
	}

	@JSON
	@Override
	public String getFromName() {
		if (_fromName == null) {
			return "";
		}
		else {
			return _fromName;
		}
	}

	@Override
	public void setFromName(String fromName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fromName = fromName;
	}

	@JSON
	@Override
	public String getTo() {
		if (_to == null) {
			return "";
		}
		else {
			return _to;
		}
	}

	@Override
	public void setTo(String to) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_to = to;
	}

	@JSON
	@Override
	public String getToName() {
		if (_toName == null) {
			return "";
		}
		else {
			return _toName;
		}
	}

	@Override
	public void setToName(String toName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_toName = toName;
	}

	@JSON
	@Override
	public String getCc() {
		if (_cc == null) {
			return "";
		}
		else {
			return _cc;
		}
	}

	@Override
	public void setCc(String cc) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_cc = cc;
	}

	@JSON
	@Override
	public String getBcc() {
		if (_bcc == null) {
			return "";
		}
		else {
			return _bcc;
		}
	}

	@Override
	public void setBcc(String bcc) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_bcc = bcc;
	}

	@JSON
	@Override
	public String getSubject() {
		if (_subject == null) {
			return "";
		}
		else {
			return _subject;
		}
	}

	@Override
	public void setSubject(String subject) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subject = subject;
	}

	@JSON
	@Override
	public String getBody() {
		if (_body == null) {
			return "";
		}
		else {
			return _body;
		}
	}

	@Override
	public void setBody(String body) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_body = body;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_priority = priority;
	}

	@JSON
	@Override
	public boolean getSent() {
		return _sent;
	}

	@JSON
	@Override
	public boolean isSent() {
		return _sent;
	}

	@Override
	public void setSent(boolean sent) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sent = sent;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalSent() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("sent"));
	}

	@JSON
	@Override
	public Date getSentDate() {
		return _sentDate;
	}

	@Override
	public void setSentDate(Date sentDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_sentDate = sentDate;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public Date getOriginalSentDate() {
		return getColumnOriginalValue("sentDate");
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceNotificationQueueEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceNotificationQueueEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceNotificationQueueEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceNotificationQueueEntryImpl commerceNotificationQueueEntryImpl =
			new CommerceNotificationQueueEntryImpl();

		commerceNotificationQueueEntryImpl.setCommerceNotificationQueueEntryId(
			getCommerceNotificationQueueEntryId());
		commerceNotificationQueueEntryImpl.setGroupId(getGroupId());
		commerceNotificationQueueEntryImpl.setCompanyId(getCompanyId());
		commerceNotificationQueueEntryImpl.setUserId(getUserId());
		commerceNotificationQueueEntryImpl.setUserName(getUserName());
		commerceNotificationQueueEntryImpl.setCreateDate(getCreateDate());
		commerceNotificationQueueEntryImpl.setModifiedDate(getModifiedDate());
		commerceNotificationQueueEntryImpl.setClassNameId(getClassNameId());
		commerceNotificationQueueEntryImpl.setClassPK(getClassPK());
		commerceNotificationQueueEntryImpl.setCommerceNotificationTemplateId(
			getCommerceNotificationTemplateId());
		commerceNotificationQueueEntryImpl.setFrom(getFrom());
		commerceNotificationQueueEntryImpl.setFromName(getFromName());
		commerceNotificationQueueEntryImpl.setTo(getTo());
		commerceNotificationQueueEntryImpl.setToName(getToName());
		commerceNotificationQueueEntryImpl.setCc(getCc());
		commerceNotificationQueueEntryImpl.setBcc(getBcc());
		commerceNotificationQueueEntryImpl.setSubject(getSubject());
		commerceNotificationQueueEntryImpl.setBody(getBody());
		commerceNotificationQueueEntryImpl.setPriority(getPriority());
		commerceNotificationQueueEntryImpl.setSent(isSent());
		commerceNotificationQueueEntryImpl.setSentDate(getSentDate());

		commerceNotificationQueueEntryImpl.resetOriginalValues();

		return commerceNotificationQueueEntryImpl;
	}

	@Override
	public int compareTo(
		CommerceNotificationQueueEntry commerceNotificationQueueEntry) {

		int value = 0;

		if (getPriority() < commerceNotificationQueueEntry.getPriority()) {
			value = -1;
		}
		else if (getPriority() > commerceNotificationQueueEntry.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceNotificationQueueEntry)) {
			return false;
		}

		CommerceNotificationQueueEntry commerceNotificationQueueEntry =
			(CommerceNotificationQueueEntry)object;

		long primaryKey = commerceNotificationQueueEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceNotificationQueueEntry> toCacheModel() {
		CommerceNotificationQueueEntryCacheModel
			commerceNotificationQueueEntryCacheModel =
				new CommerceNotificationQueueEntryCacheModel();

		commerceNotificationQueueEntryCacheModel.
			commerceNotificationQueueEntryId =
				getCommerceNotificationQueueEntryId();

		commerceNotificationQueueEntryCacheModel.groupId = getGroupId();

		commerceNotificationQueueEntryCacheModel.companyId = getCompanyId();

		commerceNotificationQueueEntryCacheModel.userId = getUserId();

		commerceNotificationQueueEntryCacheModel.userName = getUserName();

		String userName = commerceNotificationQueueEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceNotificationQueueEntryCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.createDate =
				Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceNotificationQueueEntryCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commerceNotificationQueueEntryCacheModel.classNameId = getClassNameId();

		commerceNotificationQueueEntryCacheModel.classPK = getClassPK();

		commerceNotificationQueueEntryCacheModel.
			commerceNotificationTemplateId =
				getCommerceNotificationTemplateId();

		commerceNotificationQueueEntryCacheModel.from = getFrom();

		String from = commerceNotificationQueueEntryCacheModel.from;

		if ((from != null) && (from.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.from = null;
		}

		commerceNotificationQueueEntryCacheModel.fromName = getFromName();

		String fromName = commerceNotificationQueueEntryCacheModel.fromName;

		if ((fromName != null) && (fromName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.fromName = null;
		}

		commerceNotificationQueueEntryCacheModel.to = getTo();

		String to = commerceNotificationQueueEntryCacheModel.to;

		if ((to != null) && (to.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.to = null;
		}

		commerceNotificationQueueEntryCacheModel.toName = getToName();

		String toName = commerceNotificationQueueEntryCacheModel.toName;

		if ((toName != null) && (toName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.toName = null;
		}

		commerceNotificationQueueEntryCacheModel.cc = getCc();

		String cc = commerceNotificationQueueEntryCacheModel.cc;

		if ((cc != null) && (cc.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.cc = null;
		}

		commerceNotificationQueueEntryCacheModel.bcc = getBcc();

		String bcc = commerceNotificationQueueEntryCacheModel.bcc;

		if ((bcc != null) && (bcc.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.bcc = null;
		}

		commerceNotificationQueueEntryCacheModel.subject = getSubject();

		String subject = commerceNotificationQueueEntryCacheModel.subject;

		if ((subject != null) && (subject.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.subject = null;
		}

		commerceNotificationQueueEntryCacheModel.body = getBody();

		String body = commerceNotificationQueueEntryCacheModel.body;

		if ((body != null) && (body.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.body = null;
		}

		commerceNotificationQueueEntryCacheModel.priority = getPriority();

		commerceNotificationQueueEntryCacheModel.sent = isSent();

		Date sentDate = getSentDate();

		if (sentDate != null) {
			commerceNotificationQueueEntryCacheModel.sentDate =
				sentDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.sentDate = Long.MIN_VALUE;
		}

		return commerceNotificationQueueEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceNotificationQueueEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceNotificationQueueEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationQueueEntry, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceNotificationQueueEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceNotificationQueueEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceNotificationQueueEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationQueueEntry, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceNotificationQueueEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceNotificationQueueEntry>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						CommerceNotificationQueueEntry.class,
						ModelWrapper.class);

	}

	private long _commerceNotificationQueueEntryId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _classPK;
	private long _commerceNotificationTemplateId;
	private String _from;
	private String _fromName;
	private String _to;
	private String _toName;
	private String _cc;
	private String _bcc;
	private String _subject;
	private String _body;
	private double _priority;
	private boolean _sent;
	private Date _sentDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<CommerceNotificationQueueEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((CommerceNotificationQueueEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put(
			"CNotificationQueueEntryId", _commerceNotificationQueueEntryId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("classNameId", _classNameId);
		_columnOriginalValues.put("classPK", _classPK);
		_columnOriginalValues.put(
			"commerceNotificationTemplateId", _commerceNotificationTemplateId);
		_columnOriginalValues.put("from_", _from);
		_columnOriginalValues.put("fromName", _fromName);
		_columnOriginalValues.put("to_", _to);
		_columnOriginalValues.put("toName", _toName);
		_columnOriginalValues.put("cc", _cc);
		_columnOriginalValues.put("bcc", _bcc);
		_columnOriginalValues.put("subject", _subject);
		_columnOriginalValues.put("body", _body);
		_columnOriginalValues.put("priority", _priority);
		_columnOriginalValues.put("sent", _sent);
		_columnOriginalValues.put("sentDate", _sentDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put(
			"CNotificationQueueEntryId", "commerceNotificationQueueEntryId");
		attributeNames.put("from_", "from");
		attributeNames.put("to_", "to");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("CNotificationQueueEntryId", 1L);

		columnBitmasks.put("groupId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("classNameId", 128L);

		columnBitmasks.put("classPK", 256L);

		columnBitmasks.put("commerceNotificationTemplateId", 512L);

		columnBitmasks.put("from_", 1024L);

		columnBitmasks.put("fromName", 2048L);

		columnBitmasks.put("to_", 4096L);

		columnBitmasks.put("toName", 8192L);

		columnBitmasks.put("cc", 16384L);

		columnBitmasks.put("bcc", 32768L);

		columnBitmasks.put("subject", 65536L);

		columnBitmasks.put("body", 131072L);

		columnBitmasks.put("priority", 262144L);

		columnBitmasks.put("sent", 524288L);

		columnBitmasks.put("sentDate", 1048576L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private CommerceNotificationQueueEntry _escapedModel;

}