/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.notification.internal.upgrade.v2_2_1;

import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * @author Marco Leo
 */
public class CommerceNotificationTemplateGroupIdUpgradeProcess
	extends UpgradeProcess {

	public CommerceNotificationTemplateGroupIdUpgradeProcess(
		ClassNameLocalService classNameLocalService,
		GroupLocalService groupLocalService) {

		_classNameLocalService = classNameLocalService;
		_groupLocalService = groupLocalService;
	}

	@Override
	protected void doUpgrade() throws Exception {
		try (Statement s = connection.createStatement();

			ResultSet rs = s.executeQuery(
				"select commerceNotificationTemplateId, groupId from " +
					"CommerceNotificationTemplate")) {

			PreparedStatement ps = null;

			while (rs.next()) {
				long groupId = rs.getLong("groupId");

				long channelGroupId = _getCommerceChannelGroupIdBySiteGroupId(
					groupId);

				if (channelGroupId == 0) {
					continue;
				}

				long commerceNotificationTemplateId = rs.getLong(
					"commerceNotificationTemplateId");

				ps = connection.prepareStatement(
					"update CommerceNotificationTemplate set groupId = ? " +
						"where commerceNotificationTemplateId = ?");

				ps.setLong(1, channelGroupId);
				ps.setLong(2, commerceNotificationTemplateId);

				ps.executeUpdate();
			}
		}
	}

	private long _getCommerceChannelGroupIdBySiteGroupId(long groupId)
		throws SQLException {

		long companyId = 0;
		long commerceChannelId = 0;

		String sql =
			"select * from CommerceChannel where siteGroupId = " + groupId;

		try (Statement s = connection.createStatement()) {
			s.setMaxRows(1);

			try (ResultSet rs = s.executeQuery(sql)) {
				if (rs.next()) {
					companyId = rs.getLong("companyId");
					commerceChannelId = rs.getLong("commerceChannelId");
				}
			}
		}

		long classNameId = _classNameLocalService.getClassNameId(
			CommerceChannel.class.getName());

		Group group = _groupLocalService.fetchGroup(
			companyId, classNameId, commerceChannelId);

		if (group != null) {
			return group.getGroupId();
		}

		return 0;
	}

	private final ClassNameLocalService _classNameLocalService;
	private final GroupLocalService _groupLocalService;

}