/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.commerce.notification.internal.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Alessio Antonio Rendina
 */
@ExtendedObjectClassDefinition(category = "orders")
@Meta.OCD(
	id = "com.liferay.commerce.notification.internal.configuration.CommerceNotificationQueueEntryConfiguration",
	localization = "content/Language",
	name = "commerce-notification-queue-entry-configuration-name"
)
public interface CommerceNotificationQueueEntryConfiguration {

	@Meta.AD(
		deflt = "15", name = "notification-queue-entry-check-interval",
		required = false
	)
	public int checkInterval();

	@Meta.AD(
		deflt = "43200", name = "notification-queue-entry-delete-interval",
		required = false
	)
	public int deleteInterval();

}