/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.notification.model.impl;

import com.liferay.commerce.notification.model.CommerceNotificationQueueEntry;
import com.liferay.commerce.notification.model.CommerceNotificationQueueEntryModel;
import com.liferay.commerce.notification.model.CommerceNotificationQueueEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceNotificationQueueEntry service. Represents a row in the &quot;CommerceNotificationQueueEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceNotificationQueueEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceNotificationQueueEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceNotificationQueueEntryImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceNotificationQueueEntryModelImpl
	extends BaseModelImpl<CommerceNotificationQueueEntry>
	implements CommerceNotificationQueueEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce notification queue entry model instance should use the <code>CommerceNotificationQueueEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceNotificationQueueEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"CNotificationQueueEntryId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"classNameId", Types.BIGINT},
		{"classPK", Types.BIGINT},
		{"commerceNotificationTemplateId", Types.BIGINT},
		{"from_", Types.VARCHAR}, {"fromName", Types.VARCHAR},
		{"to_", Types.VARCHAR}, {"toName", Types.VARCHAR},
		{"cc", Types.VARCHAR}, {"bcc", Types.VARCHAR},
		{"subject", Types.VARCHAR}, {"body", Types.CLOB},
		{"priority", Types.DOUBLE}, {"sent", Types.BOOLEAN},
		{"sentDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("CNotificationQueueEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("classNameId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("classPK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceNotificationTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("from_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fromName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("to_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("toName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("cc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("bcc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("body", Types.CLOB);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("sent", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("sentDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceNotificationQueueEntry (CNotificationQueueEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,commerceNotificationTemplateId LONG,from_ VARCHAR(75) null,fromName VARCHAR(75) null,to_ VARCHAR(75) null,toName VARCHAR(75) null,cc VARCHAR(255) null,bcc VARCHAR(255) null,subject VARCHAR(255) null,body TEXT null,priority DOUBLE,sent BOOLEAN,sentDate DATE null)";

	public static final String TABLE_SQL_DROP =
		"drop table CommerceNotificationQueueEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceNotificationQueueEntry.priority DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceNotificationQueueEntry.priority DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"),
		true);

	public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;

	public static final long CLASSPK_COLUMN_BITMASK = 2L;

	public static final long COMMERCENOTIFICATIONTEMPLATEID_COLUMN_BITMASK = 4L;

	public static final long GROUPID_COLUMN_BITMASK = 8L;

	public static final long SENT_COLUMN_BITMASK = 16L;

	public static final long SENTDATE_COLUMN_BITMASK = 32L;

	public static final long PRIORITY_COLUMN_BITMASK = 64L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceNotificationQueueEntry toModel(
		CommerceNotificationQueueEntrySoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommerceNotificationQueueEntry model =
			new CommerceNotificationQueueEntryImpl();

		model.setCommerceNotificationQueueEntryId(
			soapModel.getCommerceNotificationQueueEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setClassNameId(soapModel.getClassNameId());
		model.setClassPK(soapModel.getClassPK());
		model.setCommerceNotificationTemplateId(
			soapModel.getCommerceNotificationTemplateId());
		model.setFrom(soapModel.getFrom());
		model.setFromName(soapModel.getFromName());
		model.setTo(soapModel.getTo());
		model.setToName(soapModel.getToName());
		model.setCc(soapModel.getCc());
		model.setBcc(soapModel.getBcc());
		model.setSubject(soapModel.getSubject());
		model.setBody(soapModel.getBody());
		model.setPriority(soapModel.getPriority());
		model.setSent(soapModel.isSent());
		model.setSentDate(soapModel.getSentDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceNotificationQueueEntry> toModels(
		CommerceNotificationQueueEntrySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceNotificationQueueEntry> models =
			new ArrayList<CommerceNotificationQueueEntry>(soapModels.length);

		for (CommerceNotificationQueueEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"));

	public CommerceNotificationQueueEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceNotificationQueueEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceNotificationQueueEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceNotificationQueueEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceNotificationQueueEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceNotificationQueueEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationQueueEntry, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceNotificationQueueEntry)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceNotificationQueueEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceNotificationQueueEntry, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceNotificationQueueEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceNotificationQueueEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceNotificationQueueEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceNotificationQueueEntry>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceNotificationQueueEntry.class.getClassLoader(),
			CommerceNotificationQueueEntry.class, ModelWrapper.class);

		try {
			Constructor<CommerceNotificationQueueEntry> constructor =
				(Constructor<CommerceNotificationQueueEntry>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map
		<String, Function<CommerceNotificationQueueEntry, Object>>
			_attributeGetterFunctions;

	static {
		Map<String, Function<CommerceNotificationQueueEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String,
					 Function<CommerceNotificationQueueEntry, Object>>();

		attributeGetterFunctions.put(
			"commerceNotificationQueueEntryId",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.
						getCommerceNotificationQueueEntryId();
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getGroupId();
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getCompanyId();
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getUserId();
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getUserName();
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getCreateDate();
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getModifiedDate();
				}

			});
		attributeGetterFunctions.put(
			"classNameId",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getClassNameId();
				}

			});
		attributeGetterFunctions.put(
			"classPK",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getClassPK();
				}

			});
		attributeGetterFunctions.put(
			"commerceNotificationTemplateId",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.
						getCommerceNotificationTemplateId();
				}

			});
		attributeGetterFunctions.put(
			"from",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getFrom();
				}

			});
		attributeGetterFunctions.put(
			"fromName",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getFromName();
				}

			});
		attributeGetterFunctions.put(
			"to",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getTo();
				}

			});
		attributeGetterFunctions.put(
			"toName",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getToName();
				}

			});
		attributeGetterFunctions.put(
			"cc",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getCc();
				}

			});
		attributeGetterFunctions.put(
			"bcc",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getBcc();
				}

			});
		attributeGetterFunctions.put(
			"subject",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getSubject();
				}

			});
		attributeGetterFunctions.put(
			"body",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getBody();
				}

			});
		attributeGetterFunctions.put(
			"priority",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getPriority();
				}

			});
		attributeGetterFunctions.put(
			"sent",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getSent();
				}

			});
		attributeGetterFunctions.put(
			"sentDate",
			new Function<CommerceNotificationQueueEntry, Object>() {

				@Override
				public Object apply(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry) {

					return commerceNotificationQueueEntry.getSentDate();
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map
		<String, BiConsumer<CommerceNotificationQueueEntry, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<CommerceNotificationQueueEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceNotificationQueueEntry, ?>>();

		attributeSetterBiConsumers.put(
			"commerceNotificationQueueEntryId",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object commerceNotificationQueueEntryIdObject) {

					commerceNotificationQueueEntry.
						setCommerceNotificationQueueEntryId(
							(Long)commerceNotificationQueueEntryIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object groupIdObject) {

					commerceNotificationQueueEntry.setGroupId(
						(Long)groupIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object companyIdObject) {

					commerceNotificationQueueEntry.setCompanyId(
						(Long)companyIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object userIdObject) {

					commerceNotificationQueueEntry.setUserId(
						(Long)userIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object userNameObject) {

					commerceNotificationQueueEntry.setUserName(
						(String)userNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object createDateObject) {

					commerceNotificationQueueEntry.setCreateDate(
						(Date)createDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object modifiedDateObject) {

					commerceNotificationQueueEntry.setModifiedDate(
						(Date)modifiedDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"classNameId",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object classNameIdObject) {

					commerceNotificationQueueEntry.setClassNameId(
						(Long)classNameIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"classPK",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object classPKObject) {

					commerceNotificationQueueEntry.setClassPK(
						(Long)classPKObject);
				}

			});
		attributeSetterBiConsumers.put(
			"commerceNotificationTemplateId",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object commerceNotificationTemplateIdObject) {

					commerceNotificationQueueEntry.
						setCommerceNotificationTemplateId(
							(Long)commerceNotificationTemplateIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"from",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object fromObject) {

					commerceNotificationQueueEntry.setFrom((String)fromObject);
				}

			});
		attributeSetterBiConsumers.put(
			"fromName",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object fromNameObject) {

					commerceNotificationQueueEntry.setFromName(
						(String)fromNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"to",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object toObject) {

					commerceNotificationQueueEntry.setTo((String)toObject);
				}

			});
		attributeSetterBiConsumers.put(
			"toName",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object toNameObject) {

					commerceNotificationQueueEntry.setToName(
						(String)toNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"cc",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object ccObject) {

					commerceNotificationQueueEntry.setCc((String)ccObject);
				}

			});
		attributeSetterBiConsumers.put(
			"bcc",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object bccObject) {

					commerceNotificationQueueEntry.setBcc((String)bccObject);
				}

			});
		attributeSetterBiConsumers.put(
			"subject",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object subjectObject) {

					commerceNotificationQueueEntry.setSubject(
						(String)subjectObject);
				}

			});
		attributeSetterBiConsumers.put(
			"body",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object bodyObject) {

					commerceNotificationQueueEntry.setBody((String)bodyObject);
				}

			});
		attributeSetterBiConsumers.put(
			"priority",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object priorityObject) {

					commerceNotificationQueueEntry.setPriority(
						(Double)priorityObject);
				}

			});
		attributeSetterBiConsumers.put(
			"sent",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object sentObject) {

					commerceNotificationQueueEntry.setSent((Boolean)sentObject);
				}

			});
		attributeSetterBiConsumers.put(
			"sentDate",
			new BiConsumer<CommerceNotificationQueueEntry, Object>() {

				@Override
				public void accept(
					CommerceNotificationQueueEntry
						commerceNotificationQueueEntry,
					Object sentDateObject) {

					commerceNotificationQueueEntry.setSentDate(
						(Date)sentDateObject);
				}

			});

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getCommerceNotificationQueueEntryId() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setCommerceNotificationQueueEntryId(
		long commerceNotificationQueueEntryId) {

		_commerceNotificationQueueEntryId = commerceNotificationQueueEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getClassName() {
		if (getClassNameId() <= 0) {
			return "";
		}

		return PortalUtil.getClassName(getClassNameId());
	}

	@Override
	public void setClassName(String className) {
		long classNameId = 0;

		if (Validator.isNotNull(className)) {
			classNameId = PortalUtil.getClassNameId(className);
		}

		setClassNameId(classNameId);
	}

	@JSON
	@Override
	public long getClassNameId() {
		return _classNameId;
	}

	@Override
	public void setClassNameId(long classNameId) {
		_columnBitmask |= CLASSNAMEID_COLUMN_BITMASK;

		if (!_setOriginalClassNameId) {
			_setOriginalClassNameId = true;

			_originalClassNameId = _classNameId;
		}

		_classNameId = classNameId;
	}

	public long getOriginalClassNameId() {
		return _originalClassNameId;
	}

	@JSON
	@Override
	public long getClassPK() {
		return _classPK;
	}

	@Override
	public void setClassPK(long classPK) {
		_columnBitmask |= CLASSPK_COLUMN_BITMASK;

		if (!_setOriginalClassPK) {
			_setOriginalClassPK = true;

			_originalClassPK = _classPK;
		}

		_classPK = classPK;
	}

	public long getOriginalClassPK() {
		return _originalClassPK;
	}

	@JSON
	@Override
	public long getCommerceNotificationTemplateId() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setCommerceNotificationTemplateId(
		long commerceNotificationTemplateId) {

		_columnBitmask |= COMMERCENOTIFICATIONTEMPLATEID_COLUMN_BITMASK;

		if (!_setOriginalCommerceNotificationTemplateId) {
			_setOriginalCommerceNotificationTemplateId = true;

			_originalCommerceNotificationTemplateId =
				_commerceNotificationTemplateId;
		}

		_commerceNotificationTemplateId = commerceNotificationTemplateId;
	}

	public long getOriginalCommerceNotificationTemplateId() {
		return _originalCommerceNotificationTemplateId;
	}

	@JSON
	@Override
	public String getFrom() {
		if (_from == null) {
			return "";
		}
		else {
			return _from;
		}
	}

	@Override
	public void setFrom(String from) {
		_from = from;
	}

	@JSON
	@Override
	public String getFromName() {
		if (_fromName == null) {
			return "";
		}
		else {
			return _fromName;
		}
	}

	@Override
	public void setFromName(String fromName) {
		_fromName = fromName;
	}

	@JSON
	@Override
	public String getTo() {
		if (_to == null) {
			return "";
		}
		else {
			return _to;
		}
	}

	@Override
	public void setTo(String to) {
		_to = to;
	}

	@JSON
	@Override
	public String getToName() {
		if (_toName == null) {
			return "";
		}
		else {
			return _toName;
		}
	}

	@Override
	public void setToName(String toName) {
		_toName = toName;
	}

	@JSON
	@Override
	public String getCc() {
		if (_cc == null) {
			return "";
		}
		else {
			return _cc;
		}
	}

	@Override
	public void setCc(String cc) {
		_cc = cc;
	}

	@JSON
	@Override
	public String getBcc() {
		if (_bcc == null) {
			return "";
		}
		else {
			return _bcc;
		}
	}

	@Override
	public void setBcc(String bcc) {
		_bcc = bcc;
	}

	@JSON
	@Override
	public String getSubject() {
		if (_subject == null) {
			return "";
		}
		else {
			return _subject;
		}
	}

	@Override
	public void setSubject(String subject) {
		_subject = subject;
	}

	@JSON
	@Override
	public String getBody() {
		if (_body == null) {
			return "";
		}
		else {
			return _body;
		}
	}

	@Override
	public void setBody(String body) {
		_body = body;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		_columnBitmask = -1L;

		_priority = priority;
	}

	@JSON
	@Override
	public boolean getSent() {
		return _sent;
	}

	@JSON
	@Override
	public boolean isSent() {
		return _sent;
	}

	@Override
	public void setSent(boolean sent) {
		_columnBitmask |= SENT_COLUMN_BITMASK;

		if (!_setOriginalSent) {
			_setOriginalSent = true;

			_originalSent = _sent;
		}

		_sent = sent;
	}

	public boolean getOriginalSent() {
		return _originalSent;
	}

	@JSON
	@Override
	public Date getSentDate() {
		return _sentDate;
	}

	@Override
	public void setSentDate(Date sentDate) {
		_columnBitmask |= SENTDATE_COLUMN_BITMASK;

		if (_originalSentDate == null) {
			_originalSentDate = _sentDate;
		}

		_sentDate = sentDate;
	}

	public Date getOriginalSentDate() {
		return _originalSentDate;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceNotificationQueueEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceNotificationQueueEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceNotificationQueueEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceNotificationQueueEntryImpl commerceNotificationQueueEntryImpl =
			new CommerceNotificationQueueEntryImpl();

		commerceNotificationQueueEntryImpl.setCommerceNotificationQueueEntryId(
			getCommerceNotificationQueueEntryId());
		commerceNotificationQueueEntryImpl.setGroupId(getGroupId());
		commerceNotificationQueueEntryImpl.setCompanyId(getCompanyId());
		commerceNotificationQueueEntryImpl.setUserId(getUserId());
		commerceNotificationQueueEntryImpl.setUserName(getUserName());
		commerceNotificationQueueEntryImpl.setCreateDate(getCreateDate());
		commerceNotificationQueueEntryImpl.setModifiedDate(getModifiedDate());
		commerceNotificationQueueEntryImpl.setClassNameId(getClassNameId());
		commerceNotificationQueueEntryImpl.setClassPK(getClassPK());
		commerceNotificationQueueEntryImpl.setCommerceNotificationTemplateId(
			getCommerceNotificationTemplateId());
		commerceNotificationQueueEntryImpl.setFrom(getFrom());
		commerceNotificationQueueEntryImpl.setFromName(getFromName());
		commerceNotificationQueueEntryImpl.setTo(getTo());
		commerceNotificationQueueEntryImpl.setToName(getToName());
		commerceNotificationQueueEntryImpl.setCc(getCc());
		commerceNotificationQueueEntryImpl.setBcc(getBcc());
		commerceNotificationQueueEntryImpl.setSubject(getSubject());
		commerceNotificationQueueEntryImpl.setBody(getBody());
		commerceNotificationQueueEntryImpl.setPriority(getPriority());
		commerceNotificationQueueEntryImpl.setSent(isSent());
		commerceNotificationQueueEntryImpl.setSentDate(getSentDate());

		commerceNotificationQueueEntryImpl.resetOriginalValues();

		return commerceNotificationQueueEntryImpl;
	}

	@Override
	public int compareTo(
		CommerceNotificationQueueEntry commerceNotificationQueueEntry) {

		int value = 0;

		if (getPriority() < commerceNotificationQueueEntry.getPriority()) {
			value = -1;
		}
		else if (getPriority() > commerceNotificationQueueEntry.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceNotificationQueueEntry)) {
			return false;
		}

		CommerceNotificationQueueEntry commerceNotificationQueueEntry =
			(CommerceNotificationQueueEntry)object;

		long primaryKey = commerceNotificationQueueEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_setModifiedDate = false;
		_originalClassNameId = _classNameId;

		_setOriginalClassNameId = false;

		_originalClassPK = _classPK;

		_setOriginalClassPK = false;

		_originalCommerceNotificationTemplateId =
			_commerceNotificationTemplateId;

		_setOriginalCommerceNotificationTemplateId = false;

		_originalSent = _sent;

		_setOriginalSent = false;

		_originalSentDate = _sentDate;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceNotificationQueueEntry> toCacheModel() {
		CommerceNotificationQueueEntryCacheModel
			commerceNotificationQueueEntryCacheModel =
				new CommerceNotificationQueueEntryCacheModel();

		commerceNotificationQueueEntryCacheModel.
			commerceNotificationQueueEntryId =
				getCommerceNotificationQueueEntryId();

		commerceNotificationQueueEntryCacheModel.groupId = getGroupId();

		commerceNotificationQueueEntryCacheModel.companyId = getCompanyId();

		commerceNotificationQueueEntryCacheModel.userId = getUserId();

		commerceNotificationQueueEntryCacheModel.userName = getUserName();

		String userName = commerceNotificationQueueEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceNotificationQueueEntryCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.createDate =
				Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceNotificationQueueEntryCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commerceNotificationQueueEntryCacheModel.classNameId = getClassNameId();

		commerceNotificationQueueEntryCacheModel.classPK = getClassPK();

		commerceNotificationQueueEntryCacheModel.
			commerceNotificationTemplateId =
				getCommerceNotificationTemplateId();

		commerceNotificationQueueEntryCacheModel.from = getFrom();

		String from = commerceNotificationQueueEntryCacheModel.from;

		if ((from != null) && (from.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.from = null;
		}

		commerceNotificationQueueEntryCacheModel.fromName = getFromName();

		String fromName = commerceNotificationQueueEntryCacheModel.fromName;

		if ((fromName != null) && (fromName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.fromName = null;
		}

		commerceNotificationQueueEntryCacheModel.to = getTo();

		String to = commerceNotificationQueueEntryCacheModel.to;

		if ((to != null) && (to.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.to = null;
		}

		commerceNotificationQueueEntryCacheModel.toName = getToName();

		String toName = commerceNotificationQueueEntryCacheModel.toName;

		if ((toName != null) && (toName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.toName = null;
		}

		commerceNotificationQueueEntryCacheModel.cc = getCc();

		String cc = commerceNotificationQueueEntryCacheModel.cc;

		if ((cc != null) && (cc.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.cc = null;
		}

		commerceNotificationQueueEntryCacheModel.bcc = getBcc();

		String bcc = commerceNotificationQueueEntryCacheModel.bcc;

		if ((bcc != null) && (bcc.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.bcc = null;
		}

		commerceNotificationQueueEntryCacheModel.subject = getSubject();

		String subject = commerceNotificationQueueEntryCacheModel.subject;

		if ((subject != null) && (subject.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.subject = null;
		}

		commerceNotificationQueueEntryCacheModel.body = getBody();

		String body = commerceNotificationQueueEntryCacheModel.body;

		if ((body != null) && (body.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.body = null;
		}

		commerceNotificationQueueEntryCacheModel.priority = getPriority();

		commerceNotificationQueueEntryCacheModel.sent = isSent();

		Date sentDate = getSentDate();

		if (sentDate != null) {
			commerceNotificationQueueEntryCacheModel.sentDate =
				sentDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.sentDate = Long.MIN_VALUE;
		}

		return commerceNotificationQueueEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceNotificationQueueEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceNotificationQueueEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationQueueEntry, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceNotificationQueueEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceNotificationQueueEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceNotificationQueueEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationQueueEntry, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceNotificationQueueEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceNotificationQueueEntry>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private long _commerceNotificationQueueEntryId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _classNameId;
	private long _originalClassNameId;
	private boolean _setOriginalClassNameId;
	private long _classPK;
	private long _originalClassPK;
	private boolean _setOriginalClassPK;
	private long _commerceNotificationTemplateId;
	private long _originalCommerceNotificationTemplateId;
	private boolean _setOriginalCommerceNotificationTemplateId;
	private String _from;
	private String _fromName;
	private String _to;
	private String _toName;
	private String _cc;
	private String _bcc;
	private String _subject;
	private String _body;
	private double _priority;
	private boolean _sent;
	private boolean _originalSent;
	private boolean _setOriginalSent;
	private Date _sentDate;
	private Date _originalSentDate;
	private long _columnBitmask;
	private CommerceNotificationQueueEntry _escapedModel;

}