/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.notification.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.notification.model.CommerceNotificationQueueEntry;
import com.liferay.commerce.notification.model.CommerceNotificationQueueEntryModel;
import com.liferay.commerce.notification.model.CommerceNotificationQueueEntrySoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceNotificationQueueEntry service. Represents a row in the &quot;CommerceNotificationQueueEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceNotificationQueueEntryModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceNotificationQueueEntryImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceNotificationQueueEntryImpl
 * @see CommerceNotificationQueueEntry
 * @see CommerceNotificationQueueEntryModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceNotificationQueueEntryModelImpl extends BaseModelImpl<CommerceNotificationQueueEntry>
	implements CommerceNotificationQueueEntryModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce notification queue entry model instance should use the {@link CommerceNotificationQueueEntry} interface instead.
	 */
	public static final String TABLE_NAME = "CommerceNotificationQueueEntry";
	public static final Object[][] TABLE_COLUMNS = {
			{ "CNotificationQueueEntryId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "commerceNotificationTemplateId", Types.BIGINT },
			{ "from_", Types.VARCHAR },
			{ "fromName", Types.VARCHAR },
			{ "to_", Types.VARCHAR },
			{ "toName", Types.VARCHAR },
			{ "cc", Types.VARCHAR },
			{ "bcc", Types.VARCHAR },
			{ "subject", Types.VARCHAR },
			{ "body", Types.CLOB },
			{ "priority", Types.DOUBLE },
			{ "sent", Types.BOOLEAN },
			{ "sentDate", Types.TIMESTAMP }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("CNotificationQueueEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceNotificationTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("from_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fromName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("to_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("toName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("cc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("bcc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("body", Types.CLOB);
		TABLE_COLUMNS_MAP.put("priority", Types.DOUBLE);
		TABLE_COLUMNS_MAP.put("sent", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("sentDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE = "create table CommerceNotificationQueueEntry (CNotificationQueueEntryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceNotificationTemplateId LONG,from_ VARCHAR(75) null,fromName VARCHAR(75) null,to_ VARCHAR(75) null,toName VARCHAR(75) null,cc VARCHAR(255) null,bcc VARCHAR(255) null,subject VARCHAR(255) null,body TEXT null,priority DOUBLE,sent BOOLEAN,sentDate DATE null)";
	public static final String TABLE_SQL_DROP = "drop table CommerceNotificationQueueEntry";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceNotificationQueueEntry.priority DESC";
	public static final String ORDER_BY_SQL = " ORDER BY CommerceNotificationQueueEntry.priority DESC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"),
			true);
	public static final long COMMERCENOTIFICATIONTEMPLATEID_COLUMN_BITMASK = 1L;
	public static final long GROUPID_COLUMN_BITMASK = 2L;
	public static final long SENT_COLUMN_BITMASK = 4L;
	public static final long SENTDATE_COLUMN_BITMASK = 8L;
	public static final long PRIORITY_COLUMN_BITMASK = 16L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceNotificationQueueEntry toModel(
		CommerceNotificationQueueEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceNotificationQueueEntry model = new CommerceNotificationQueueEntryImpl();

		model.setCommerceNotificationQueueEntryId(soapModel.getCommerceNotificationQueueEntryId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceNotificationTemplateId(soapModel.getCommerceNotificationTemplateId());
		model.setFrom(soapModel.getFrom());
		model.setFromName(soapModel.getFromName());
		model.setTo(soapModel.getTo());
		model.setToName(soapModel.getToName());
		model.setCc(soapModel.getCc());
		model.setBcc(soapModel.getBcc());
		model.setSubject(soapModel.getSubject());
		model.setBody(soapModel.getBody());
		model.setPriority(soapModel.getPriority());
		model.setSent(soapModel.isSent());
		model.setSentDate(soapModel.getSentDate());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceNotificationQueueEntry> toModels(
		CommerceNotificationQueueEntrySoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceNotificationQueueEntry> models = new ArrayList<CommerceNotificationQueueEntry>(soapModels.length);

		for (CommerceNotificationQueueEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.notification.model.CommerceNotificationQueueEntry"));

	public CommerceNotificationQueueEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceNotificationQueueEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceNotificationQueueEntry.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceNotificationQueueEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceNotificationQueueEntryId",
			getCommerceNotificationQueueEntryId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("commerceNotificationTemplateId",
			getCommerceNotificationTemplateId());
		attributes.put("from", getFrom());
		attributes.put("fromName", getFromName());
		attributes.put("to", getTo());
		attributes.put("toName", getToName());
		attributes.put("cc", getCc());
		attributes.put("bcc", getBcc());
		attributes.put("subject", getSubject());
		attributes.put("body", getBody());
		attributes.put("priority", getPriority());
		attributes.put("sent", isSent());
		attributes.put("sentDate", getSentDate());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceNotificationQueueEntryId = (Long)attributes.get(
				"commerceNotificationQueueEntryId");

		if (commerceNotificationQueueEntryId != null) {
			setCommerceNotificationQueueEntryId(commerceNotificationQueueEntryId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long commerceNotificationTemplateId = (Long)attributes.get(
				"commerceNotificationTemplateId");

		if (commerceNotificationTemplateId != null) {
			setCommerceNotificationTemplateId(commerceNotificationTemplateId);
		}

		String from = (String)attributes.get("from");

		if (from != null) {
			setFrom(from);
		}

		String fromName = (String)attributes.get("fromName");

		if (fromName != null) {
			setFromName(fromName);
		}

		String to = (String)attributes.get("to");

		if (to != null) {
			setTo(to);
		}

		String toName = (String)attributes.get("toName");

		if (toName != null) {
			setToName(toName);
		}

		String cc = (String)attributes.get("cc");

		if (cc != null) {
			setCc(cc);
		}

		String bcc = (String)attributes.get("bcc");

		if (bcc != null) {
			setBcc(bcc);
		}

		String subject = (String)attributes.get("subject");

		if (subject != null) {
			setSubject(subject);
		}

		String body = (String)attributes.get("body");

		if (body != null) {
			setBody(body);
		}

		Double priority = (Double)attributes.get("priority");

		if (priority != null) {
			setPriority(priority);
		}

		Boolean sent = (Boolean)attributes.get("sent");

		if (sent != null) {
			setSent(sent);
		}

		Date sentDate = (Date)attributes.get("sentDate");

		if (sentDate != null) {
			setSentDate(sentDate);
		}
	}

	@JSON
	@Override
	public long getCommerceNotificationQueueEntryId() {
		return _commerceNotificationQueueEntryId;
	}

	@Override
	public void setCommerceNotificationQueueEntryId(
		long commerceNotificationQueueEntryId) {
		_commerceNotificationQueueEntryId = commerceNotificationQueueEntryId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceNotificationTemplateId() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setCommerceNotificationTemplateId(
		long commerceNotificationTemplateId) {
		_columnBitmask |= COMMERCENOTIFICATIONTEMPLATEID_COLUMN_BITMASK;

		if (!_setOriginalCommerceNotificationTemplateId) {
			_setOriginalCommerceNotificationTemplateId = true;

			_originalCommerceNotificationTemplateId = _commerceNotificationTemplateId;
		}

		_commerceNotificationTemplateId = commerceNotificationTemplateId;
	}

	public long getOriginalCommerceNotificationTemplateId() {
		return _originalCommerceNotificationTemplateId;
	}

	@JSON
	@Override
	public String getFrom() {
		if (_from == null) {
			return "";
		}
		else {
			return _from;
		}
	}

	@Override
	public void setFrom(String from) {
		_from = from;
	}

	@JSON
	@Override
	public String getFromName() {
		if (_fromName == null) {
			return "";
		}
		else {
			return _fromName;
		}
	}

	@Override
	public void setFromName(String fromName) {
		_fromName = fromName;
	}

	@JSON
	@Override
	public String getTo() {
		if (_to == null) {
			return "";
		}
		else {
			return _to;
		}
	}

	@Override
	public void setTo(String to) {
		_to = to;
	}

	@JSON
	@Override
	public String getToName() {
		if (_toName == null) {
			return "";
		}
		else {
			return _toName;
		}
	}

	@Override
	public void setToName(String toName) {
		_toName = toName;
	}

	@JSON
	@Override
	public String getCc() {
		if (_cc == null) {
			return "";
		}
		else {
			return _cc;
		}
	}

	@Override
	public void setCc(String cc) {
		_cc = cc;
	}

	@JSON
	@Override
	public String getBcc() {
		if (_bcc == null) {
			return "";
		}
		else {
			return _bcc;
		}
	}

	@Override
	public void setBcc(String bcc) {
		_bcc = bcc;
	}

	@JSON
	@Override
	public String getSubject() {
		if (_subject == null) {
			return "";
		}
		else {
			return _subject;
		}
	}

	@Override
	public void setSubject(String subject) {
		_subject = subject;
	}

	@JSON
	@Override
	public String getBody() {
		if (_body == null) {
			return "";
		}
		else {
			return _body;
		}
	}

	@Override
	public void setBody(String body) {
		_body = body;
	}

	@JSON
	@Override
	public double getPriority() {
		return _priority;
	}

	@Override
	public void setPriority(double priority) {
		_columnBitmask = -1L;

		_priority = priority;
	}

	@JSON
	@Override
	public boolean getSent() {
		return _sent;
	}

	@JSON
	@Override
	public boolean isSent() {
		return _sent;
	}

	@Override
	public void setSent(boolean sent) {
		_columnBitmask |= SENT_COLUMN_BITMASK;

		if (!_setOriginalSent) {
			_setOriginalSent = true;

			_originalSent = _sent;
		}

		_sent = sent;
	}

	public boolean getOriginalSent() {
		return _originalSent;
	}

	@JSON
	@Override
	public Date getSentDate() {
		return _sentDate;
	}

	@Override
	public void setSentDate(Date sentDate) {
		_columnBitmask |= SENTDATE_COLUMN_BITMASK;

		if (_originalSentDate == null) {
			_originalSentDate = _sentDate;
		}

		_sentDate = sentDate;
	}

	public Date getOriginalSentDate() {
		return _originalSentDate;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceNotificationQueueEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceNotificationQueueEntry toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceNotificationQueueEntry)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceNotificationQueueEntryImpl commerceNotificationQueueEntryImpl = new CommerceNotificationQueueEntryImpl();

		commerceNotificationQueueEntryImpl.setCommerceNotificationQueueEntryId(getCommerceNotificationQueueEntryId());
		commerceNotificationQueueEntryImpl.setGroupId(getGroupId());
		commerceNotificationQueueEntryImpl.setCompanyId(getCompanyId());
		commerceNotificationQueueEntryImpl.setUserId(getUserId());
		commerceNotificationQueueEntryImpl.setUserName(getUserName());
		commerceNotificationQueueEntryImpl.setCreateDate(getCreateDate());
		commerceNotificationQueueEntryImpl.setModifiedDate(getModifiedDate());
		commerceNotificationQueueEntryImpl.setCommerceNotificationTemplateId(getCommerceNotificationTemplateId());
		commerceNotificationQueueEntryImpl.setFrom(getFrom());
		commerceNotificationQueueEntryImpl.setFromName(getFromName());
		commerceNotificationQueueEntryImpl.setTo(getTo());
		commerceNotificationQueueEntryImpl.setToName(getToName());
		commerceNotificationQueueEntryImpl.setCc(getCc());
		commerceNotificationQueueEntryImpl.setBcc(getBcc());
		commerceNotificationQueueEntryImpl.setSubject(getSubject());
		commerceNotificationQueueEntryImpl.setBody(getBody());
		commerceNotificationQueueEntryImpl.setPriority(getPriority());
		commerceNotificationQueueEntryImpl.setSent(isSent());
		commerceNotificationQueueEntryImpl.setSentDate(getSentDate());

		commerceNotificationQueueEntryImpl.resetOriginalValues();

		return commerceNotificationQueueEntryImpl;
	}

	@Override
	public int compareTo(
		CommerceNotificationQueueEntry commerceNotificationQueueEntry) {
		int value = 0;

		if (getPriority() < commerceNotificationQueueEntry.getPriority()) {
			value = -1;
		}
		else if (getPriority() > commerceNotificationQueueEntry.getPriority()) {
			value = 1;
		}
		else {
			value = 0;
		}

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceNotificationQueueEntry)) {
			return false;
		}

		CommerceNotificationQueueEntry commerceNotificationQueueEntry = (CommerceNotificationQueueEntry)obj;

		long primaryKey = commerceNotificationQueueEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceNotificationQueueEntryModelImpl commerceNotificationQueueEntryModelImpl =
			this;

		commerceNotificationQueueEntryModelImpl._originalGroupId = commerceNotificationQueueEntryModelImpl._groupId;

		commerceNotificationQueueEntryModelImpl._setOriginalGroupId = false;

		commerceNotificationQueueEntryModelImpl._setModifiedDate = false;

		commerceNotificationQueueEntryModelImpl._originalCommerceNotificationTemplateId = commerceNotificationQueueEntryModelImpl._commerceNotificationTemplateId;

		commerceNotificationQueueEntryModelImpl._setOriginalCommerceNotificationTemplateId = false;

		commerceNotificationQueueEntryModelImpl._originalSent = commerceNotificationQueueEntryModelImpl._sent;

		commerceNotificationQueueEntryModelImpl._setOriginalSent = false;

		commerceNotificationQueueEntryModelImpl._originalSentDate = commerceNotificationQueueEntryModelImpl._sentDate;

		commerceNotificationQueueEntryModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceNotificationQueueEntry> toCacheModel() {
		CommerceNotificationQueueEntryCacheModel commerceNotificationQueueEntryCacheModel =
			new CommerceNotificationQueueEntryCacheModel();

		commerceNotificationQueueEntryCacheModel.commerceNotificationQueueEntryId = getCommerceNotificationQueueEntryId();

		commerceNotificationQueueEntryCacheModel.groupId = getGroupId();

		commerceNotificationQueueEntryCacheModel.companyId = getCompanyId();

		commerceNotificationQueueEntryCacheModel.userId = getUserId();

		commerceNotificationQueueEntryCacheModel.userName = getUserName();

		String userName = commerceNotificationQueueEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceNotificationQueueEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceNotificationQueueEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceNotificationQueueEntryCacheModel.commerceNotificationTemplateId = getCommerceNotificationTemplateId();

		commerceNotificationQueueEntryCacheModel.from = getFrom();

		String from = commerceNotificationQueueEntryCacheModel.from;

		if ((from != null) && (from.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.from = null;
		}

		commerceNotificationQueueEntryCacheModel.fromName = getFromName();

		String fromName = commerceNotificationQueueEntryCacheModel.fromName;

		if ((fromName != null) && (fromName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.fromName = null;
		}

		commerceNotificationQueueEntryCacheModel.to = getTo();

		String to = commerceNotificationQueueEntryCacheModel.to;

		if ((to != null) && (to.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.to = null;
		}

		commerceNotificationQueueEntryCacheModel.toName = getToName();

		String toName = commerceNotificationQueueEntryCacheModel.toName;

		if ((toName != null) && (toName.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.toName = null;
		}

		commerceNotificationQueueEntryCacheModel.cc = getCc();

		String cc = commerceNotificationQueueEntryCacheModel.cc;

		if ((cc != null) && (cc.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.cc = null;
		}

		commerceNotificationQueueEntryCacheModel.bcc = getBcc();

		String bcc = commerceNotificationQueueEntryCacheModel.bcc;

		if ((bcc != null) && (bcc.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.bcc = null;
		}

		commerceNotificationQueueEntryCacheModel.subject = getSubject();

		String subject = commerceNotificationQueueEntryCacheModel.subject;

		if ((subject != null) && (subject.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.subject = null;
		}

		commerceNotificationQueueEntryCacheModel.body = getBody();

		String body = commerceNotificationQueueEntryCacheModel.body;

		if ((body != null) && (body.length() == 0)) {
			commerceNotificationQueueEntryCacheModel.body = null;
		}

		commerceNotificationQueueEntryCacheModel.priority = getPriority();

		commerceNotificationQueueEntryCacheModel.sent = isSent();

		Date sentDate = getSentDate();

		if (sentDate != null) {
			commerceNotificationQueueEntryCacheModel.sentDate = sentDate.getTime();
		}
		else {
			commerceNotificationQueueEntryCacheModel.sentDate = Long.MIN_VALUE;
		}

		return commerceNotificationQueueEntryCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(39);

		sb.append("{commerceNotificationQueueEntryId=");
		sb.append(getCommerceNotificationQueueEntryId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", commerceNotificationTemplateId=");
		sb.append(getCommerceNotificationTemplateId());
		sb.append(", from=");
		sb.append(getFrom());
		sb.append(", fromName=");
		sb.append(getFromName());
		sb.append(", to=");
		sb.append(getTo());
		sb.append(", toName=");
		sb.append(getToName());
		sb.append(", cc=");
		sb.append(getCc());
		sb.append(", bcc=");
		sb.append(getBcc());
		sb.append(", subject=");
		sb.append(getSubject());
		sb.append(", body=");
		sb.append(getBody());
		sb.append(", priority=");
		sb.append(getPriority());
		sb.append(", sent=");
		sb.append(isSent());
		sb.append(", sentDate=");
		sb.append(getSentDate());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(61);

		sb.append("<model><model-name>");
		sb.append(
			"com.liferay.commerce.notification.model.CommerceNotificationQueueEntry");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceNotificationQueueEntryId</column-name><column-value><![CDATA[");
		sb.append(getCommerceNotificationQueueEntryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceNotificationTemplateId</column-name><column-value><![CDATA[");
		sb.append(getCommerceNotificationTemplateId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>from</column-name><column-value><![CDATA[");
		sb.append(getFrom());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>fromName</column-name><column-value><![CDATA[");
		sb.append(getFromName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>to</column-name><column-value><![CDATA[");
		sb.append(getTo());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>toName</column-name><column-value><![CDATA[");
		sb.append(getToName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>cc</column-name><column-value><![CDATA[");
		sb.append(getCc());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>bcc</column-name><column-value><![CDATA[");
		sb.append(getBcc());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subject</column-name><column-value><![CDATA[");
		sb.append(getSubject());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>body</column-name><column-value><![CDATA[");
		sb.append(getBody());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>priority</column-name><column-value><![CDATA[");
		sb.append(getPriority());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>sent</column-name><column-value><![CDATA[");
		sb.append(isSent());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>sentDate</column-name><column-value><![CDATA[");
		sb.append(getSentDate());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceNotificationQueueEntry.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceNotificationQueueEntry.class, ModelWrapper.class
		};
	private long _commerceNotificationQueueEntryId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceNotificationTemplateId;
	private long _originalCommerceNotificationTemplateId;
	private boolean _setOriginalCommerceNotificationTemplateId;
	private String _from;
	private String _fromName;
	private String _to;
	private String _toName;
	private String _cc;
	private String _bcc;
	private String _subject;
	private String _body;
	private double _priority;
	private boolean _sent;
	private boolean _originalSent;
	private boolean _setOriginalSent;
	private Date _sentDate;
	private Date _originalSentDate;
	private long _columnBitmask;
	private CommerceNotificationQueueEntry _escapedModel;
}