/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.notification.model.impl;

import com.liferay.commerce.notification.model.CommerceNotificationTemplate;
import com.liferay.commerce.notification.model.CommerceNotificationTemplateModel;
import com.liferay.commerce.notification.model.CommerceNotificationTemplateSoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the CommerceNotificationTemplate service. Represents a row in the &quot;CommerceNotificationTemplate&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>CommerceNotificationTemplateModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceNotificationTemplateImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceNotificationTemplateImpl
 * @generated
 */
@JSON(strict = true)
public class CommerceNotificationTemplateModelImpl
	extends BaseModelImpl<CommerceNotificationTemplate>
	implements CommerceNotificationTemplateModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce notification template model instance should use the <code>CommerceNotificationTemplate</code> interface instead.
	 */
	public static final String TABLE_NAME = "CommerceNotificationTemplate";

	public static final Object[][] TABLE_COLUMNS = {
		{"uuid_", Types.VARCHAR},
		{"commerceNotificationTemplateId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"name", Types.VARCHAR}, {"description", Types.VARCHAR},
		{"from_", Types.VARCHAR}, {"fromName", Types.VARCHAR},
		{"to_", Types.VARCHAR}, {"cc", Types.VARCHAR}, {"bcc", Types.VARCHAR},
		{"type_", Types.VARCHAR}, {"enabled", Types.BOOLEAN},
		{"subject", Types.VARCHAR}, {"body", Types.CLOB}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceNotificationTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("from_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fromName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("to_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("cc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("bcc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("enabled", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("subject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("body", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE =
		"create table CommerceNotificationTemplate (uuid_ VARCHAR(75) null,commerceNotificationTemplateId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,name VARCHAR(75) null,description STRING null,from_ VARCHAR(75) null,fromName STRING null,to_ VARCHAR(75) null,cc VARCHAR(255) null,bcc VARCHAR(255) null,type_ VARCHAR(75) null,enabled BOOLEAN,subject STRING null,body TEXT null)";

	public static final String TABLE_SQL_DROP =
		"drop table CommerceNotificationTemplate";

	public static final String ORDER_BY_JPQL =
		" ORDER BY commerceNotificationTemplate.modifiedDate DESC, commerceNotificationTemplate.name DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY CommerceNotificationTemplate.modifiedDate DESC, CommerceNotificationTemplate.name DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"value.object.entity.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplate"),
		true);

	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"value.object.finder.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplate"),
		true);

	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"value.object.column.bitmask.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplate"),
		true);

	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	public static final long ENABLED_COLUMN_BITMASK = 2L;

	public static final long GROUPID_COLUMN_BITMASK = 4L;

	public static final long TYPE_COLUMN_BITMASK = 8L;

	public static final long UUID_COLUMN_BITMASK = 16L;

	public static final long MODIFIEDDATE_COLUMN_BITMASK = 32L;

	public static final long NAME_COLUMN_BITMASK = 64L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceNotificationTemplate toModel(
		CommerceNotificationTemplateSoap soapModel) {

		if (soapModel == null) {
			return null;
		}

		CommerceNotificationTemplate model =
			new CommerceNotificationTemplateImpl();

		model.setUuid(soapModel.getUuid());
		model.setCommerceNotificationTemplateId(
			soapModel.getCommerceNotificationTemplateId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setName(soapModel.getName());
		model.setDescription(soapModel.getDescription());
		model.setFrom(soapModel.getFrom());
		model.setFromName(soapModel.getFromName());
		model.setTo(soapModel.getTo());
		model.setCc(soapModel.getCc());
		model.setBcc(soapModel.getBcc());
		model.setType(soapModel.getType());
		model.setEnabled(soapModel.isEnabled());
		model.setSubject(soapModel.getSubject());
		model.setBody(soapModel.getBody());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceNotificationTemplate> toModels(
		CommerceNotificationTemplateSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<CommerceNotificationTemplate> models =
			new ArrayList<CommerceNotificationTemplate>(soapModels.length);

		for (CommerceNotificationTemplateSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(
		com.liferay.commerce.notification.service.util.ServiceProps.get(
			"lock.expiration.time.com.liferay.commerce.notification.model.CommerceNotificationTemplate"));

	public CommerceNotificationTemplateModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceNotificationTemplateId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceNotificationTemplate.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceNotificationTemplate.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<CommerceNotificationTemplate, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<CommerceNotificationTemplate, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationTemplate, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(CommerceNotificationTemplate)this));
		}

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<CommerceNotificationTemplate, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<CommerceNotificationTemplate, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(CommerceNotificationTemplate)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<CommerceNotificationTemplate, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<CommerceNotificationTemplate, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, CommerceNotificationTemplate>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			CommerceNotificationTemplate.class.getClassLoader(),
			CommerceNotificationTemplate.class, ModelWrapper.class);

		try {
			Constructor<CommerceNotificationTemplate> constructor =
				(Constructor<CommerceNotificationTemplate>)
					proxyClass.getConstructor(InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map
		<String, Function<CommerceNotificationTemplate, Object>>
			_attributeGetterFunctions;

	static {
		Map<String, Function<CommerceNotificationTemplate, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<CommerceNotificationTemplate, Object>>();

		attributeGetterFunctions.put(
			"uuid",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getUuid();
				}

			});
		attributeGetterFunctions.put(
			"commerceNotificationTemplateId",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.
						getCommerceNotificationTemplateId();
				}

			});
		attributeGetterFunctions.put(
			"groupId",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getGroupId();
				}

			});
		attributeGetterFunctions.put(
			"companyId",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getCompanyId();
				}

			});
		attributeGetterFunctions.put(
			"userId",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getUserId();
				}

			});
		attributeGetterFunctions.put(
			"userName",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getUserName();
				}

			});
		attributeGetterFunctions.put(
			"createDate",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getCreateDate();
				}

			});
		attributeGetterFunctions.put(
			"modifiedDate",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getModifiedDate();
				}

			});
		attributeGetterFunctions.put(
			"name",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getName();
				}

			});
		attributeGetterFunctions.put(
			"description",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getDescription();
				}

			});
		attributeGetterFunctions.put(
			"from",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getFrom();
				}

			});
		attributeGetterFunctions.put(
			"fromName",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getFromName();
				}

			});
		attributeGetterFunctions.put(
			"to",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getTo();
				}

			});
		attributeGetterFunctions.put(
			"cc",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getCc();
				}

			});
		attributeGetterFunctions.put(
			"bcc",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getBcc();
				}

			});
		attributeGetterFunctions.put(
			"type",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getType();
				}

			});
		attributeGetterFunctions.put(
			"enabled",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getEnabled();
				}

			});
		attributeGetterFunctions.put(
			"subject",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getSubject();
				}

			});
		attributeGetterFunctions.put(
			"body",
			new Function<CommerceNotificationTemplate, Object>() {

				@Override
				public Object apply(
					CommerceNotificationTemplate commerceNotificationTemplate) {

					return commerceNotificationTemplate.getBody();
				}

			});

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map
		<String, BiConsumer<CommerceNotificationTemplate, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<CommerceNotificationTemplate, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<CommerceNotificationTemplate, ?>>();

		attributeSetterBiConsumers.put(
			"uuid",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object uuidObject) {

					commerceNotificationTemplate.setUuid((String)uuidObject);
				}

			});
		attributeSetterBiConsumers.put(
			"commerceNotificationTemplateId",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object commerceNotificationTemplateIdObject) {

					commerceNotificationTemplate.
						setCommerceNotificationTemplateId(
							(Long)commerceNotificationTemplateIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"groupId",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object groupIdObject) {

					commerceNotificationTemplate.setGroupId(
						(Long)groupIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"companyId",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object companyIdObject) {

					commerceNotificationTemplate.setCompanyId(
						(Long)companyIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userId",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object userIdObject) {

					commerceNotificationTemplate.setUserId((Long)userIdObject);
				}

			});
		attributeSetterBiConsumers.put(
			"userName",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object userNameObject) {

					commerceNotificationTemplate.setUserName(
						(String)userNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"createDate",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object createDateObject) {

					commerceNotificationTemplate.setCreateDate(
						(Date)createDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"modifiedDate",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object modifiedDateObject) {

					commerceNotificationTemplate.setModifiedDate(
						(Date)modifiedDateObject);
				}

			});
		attributeSetterBiConsumers.put(
			"name",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object nameObject) {

					commerceNotificationTemplate.setName((String)nameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"description",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object descriptionObject) {

					commerceNotificationTemplate.setDescription(
						(String)descriptionObject);
				}

			});
		attributeSetterBiConsumers.put(
			"from",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object fromObject) {

					commerceNotificationTemplate.setFrom((String)fromObject);
				}

			});
		attributeSetterBiConsumers.put(
			"fromName",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object fromNameObject) {

					commerceNotificationTemplate.setFromName(
						(String)fromNameObject);
				}

			});
		attributeSetterBiConsumers.put(
			"to",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object toObject) {

					commerceNotificationTemplate.setTo((String)toObject);
				}

			});
		attributeSetterBiConsumers.put(
			"cc",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object ccObject) {

					commerceNotificationTemplate.setCc((String)ccObject);
				}

			});
		attributeSetterBiConsumers.put(
			"bcc",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object bccObject) {

					commerceNotificationTemplate.setBcc((String)bccObject);
				}

			});
		attributeSetterBiConsumers.put(
			"type",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object typeObject) {

					commerceNotificationTemplate.setType((String)typeObject);
				}

			});
		attributeSetterBiConsumers.put(
			"enabled",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object enabledObject) {

					commerceNotificationTemplate.setEnabled(
						(Boolean)enabledObject);
				}

			});
		attributeSetterBiConsumers.put(
			"subject",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object subjectObject) {

					commerceNotificationTemplate.setSubject(
						(String)subjectObject);
				}

			});
		attributeSetterBiConsumers.put(
			"body",
			new BiConsumer<CommerceNotificationTemplate, Object>() {

				@Override
				public void accept(
					CommerceNotificationTemplate commerceNotificationTemplate,
					Object bodyObject) {

					commerceNotificationTemplate.setBody((String)bodyObject);
				}

			});

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		_columnBitmask |= UUID_COLUMN_BITMASK;

		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getCommerceNotificationTemplateId() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setCommerceNotificationTemplateId(
		long commerceNotificationTemplateId) {

		_commerceNotificationTemplateId = commerceNotificationTemplateId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_columnBitmask = -1L;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_columnBitmask = -1L;

		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@JSON
	@Override
	public String getFrom() {
		if (_from == null) {
			return "";
		}
		else {
			return _from;
		}
	}

	@Override
	public void setFrom(String from) {
		_from = from;
	}

	@JSON
	@Override
	public String getFromName() {
		if (_fromName == null) {
			return "";
		}
		else {
			return _fromName;
		}
	}

	@Override
	public String getFromName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getFromName(languageId);
	}

	@Override
	public String getFromName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getFromName(languageId, useDefault);
	}

	@Override
	public String getFromName(String languageId) {
		return LocalizationUtil.getLocalization(getFromName(), languageId);
	}

	@Override
	public String getFromName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getFromName(), languageId, useDefault);
	}

	@Override
	public String getFromNameCurrentLanguageId() {
		return _fromNameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getFromNameCurrentValue() {
		Locale locale = getLocale(_fromNameCurrentLanguageId);

		return getFromName(locale);
	}

	@Override
	public Map<Locale, String> getFromNameMap() {
		return LocalizationUtil.getLocalizationMap(getFromName());
	}

	@Override
	public void setFromName(String fromName) {
		_fromName = fromName;
	}

	@Override
	public void setFromName(String fromName, Locale locale) {
		setFromName(fromName, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setFromName(
		String fromName, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(fromName)) {
			setFromName(
				LocalizationUtil.updateLocalization(
					getFromName(), "FromName", fromName, languageId,
					defaultLanguageId));
		}
		else {
			setFromName(
				LocalizationUtil.removeLocalization(
					getFromName(), "FromName", languageId));
		}
	}

	@Override
	public void setFromNameCurrentLanguageId(String languageId) {
		_fromNameCurrentLanguageId = languageId;
	}

	@Override
	public void setFromNameMap(Map<Locale, String> fromNameMap) {
		setFromNameMap(fromNameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setFromNameMap(
		Map<Locale, String> fromNameMap, Locale defaultLocale) {

		if (fromNameMap == null) {
			return;
		}

		setFromName(
			LocalizationUtil.updateLocalization(
				fromNameMap, getFromName(), "FromName",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getTo() {
		if (_to == null) {
			return "";
		}
		else {
			return _to;
		}
	}

	@Override
	public void setTo(String to) {
		_to = to;
	}

	@JSON
	@Override
	public String getCc() {
		if (_cc == null) {
			return "";
		}
		else {
			return _cc;
		}
	}

	@Override
	public void setCc(String cc) {
		_cc = cc;
	}

	@JSON
	@Override
	public String getBcc() {
		if (_bcc == null) {
			return "";
		}
		else {
			return _bcc;
		}
	}

	@Override
	public void setBcc(String bcc) {
		_bcc = bcc;
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		_columnBitmask |= TYPE_COLUMN_BITMASK;

		if (_originalType == null) {
			_originalType = _type;
		}

		_type = type;
	}

	public String getOriginalType() {
		return GetterUtil.getString(_originalType);
	}

	@JSON
	@Override
	public boolean getEnabled() {
		return _enabled;
	}

	@JSON
	@Override
	public boolean isEnabled() {
		return _enabled;
	}

	@Override
	public void setEnabled(boolean enabled) {
		_columnBitmask |= ENABLED_COLUMN_BITMASK;

		if (!_setOriginalEnabled) {
			_setOriginalEnabled = true;

			_originalEnabled = _enabled;
		}

		_enabled = enabled;
	}

	public boolean getOriginalEnabled() {
		return _originalEnabled;
	}

	@JSON
	@Override
	public String getSubject() {
		if (_subject == null) {
			return "";
		}
		else {
			return _subject;
		}
	}

	@Override
	public String getSubject(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSubject(languageId);
	}

	@Override
	public String getSubject(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSubject(languageId, useDefault);
	}

	@Override
	public String getSubject(String languageId) {
		return LocalizationUtil.getLocalization(getSubject(), languageId);
	}

	@Override
	public String getSubject(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getSubject(), languageId, useDefault);
	}

	@Override
	public String getSubjectCurrentLanguageId() {
		return _subjectCurrentLanguageId;
	}

	@JSON
	@Override
	public String getSubjectCurrentValue() {
		Locale locale = getLocale(_subjectCurrentLanguageId);

		return getSubject(locale);
	}

	@Override
	public Map<Locale, String> getSubjectMap() {
		return LocalizationUtil.getLocalizationMap(getSubject());
	}

	@Override
	public void setSubject(String subject) {
		_subject = subject;
	}

	@Override
	public void setSubject(String subject, Locale locale) {
		setSubject(subject, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setSubject(
		String subject, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(subject)) {
			setSubject(
				LocalizationUtil.updateLocalization(
					getSubject(), "Subject", subject, languageId,
					defaultLanguageId));
		}
		else {
			setSubject(
				LocalizationUtil.removeLocalization(
					getSubject(), "Subject", languageId));
		}
	}

	@Override
	public void setSubjectCurrentLanguageId(String languageId) {
		_subjectCurrentLanguageId = languageId;
	}

	@Override
	public void setSubjectMap(Map<Locale, String> subjectMap) {
		setSubjectMap(subjectMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setSubjectMap(
		Map<Locale, String> subjectMap, Locale defaultLocale) {

		if (subjectMap == null) {
			return;
		}

		setSubject(
			LocalizationUtil.updateLocalization(
				subjectMap, getSubject(), "Subject",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getBody() {
		if (_body == null) {
			return "";
		}
		else {
			return _body;
		}
	}

	@Override
	public String getBody(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getBody(languageId);
	}

	@Override
	public String getBody(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getBody(languageId, useDefault);
	}

	@Override
	public String getBody(String languageId) {
		return LocalizationUtil.getLocalization(getBody(), languageId);
	}

	@Override
	public String getBody(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getBody(), languageId, useDefault);
	}

	@Override
	public String getBodyCurrentLanguageId() {
		return _bodyCurrentLanguageId;
	}

	@JSON
	@Override
	public String getBodyCurrentValue() {
		Locale locale = getLocale(_bodyCurrentLanguageId);

		return getBody(locale);
	}

	@Override
	public Map<Locale, String> getBodyMap() {
		return LocalizationUtil.getLocalizationMap(getBody());
	}

	@Override
	public void setBody(String body) {
		_body = body;
	}

	@Override
	public void setBody(String body, Locale locale) {
		setBody(body, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setBody(String body, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(body)) {
			setBody(
				LocalizationUtil.updateLocalization(
					getBody(), "Body", body, languageId, defaultLanguageId));
		}
		else {
			setBody(
				LocalizationUtil.removeLocalization(
					getBody(), "Body", languageId));
		}
	}

	@Override
	public void setBodyCurrentLanguageId(String languageId) {
		_bodyCurrentLanguageId = languageId;
	}

	@Override
	public void setBodyMap(Map<Locale, String> bodyMap) {
		setBodyMap(bodyMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setBodyMap(Map<Locale, String> bodyMap, Locale defaultLocale) {
		if (bodyMap == null) {
			return;
		}

		setBody(
			LocalizationUtil.updateLocalization(
				bodyMap, getBody(), "Body",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				CommerceNotificationTemplate.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), CommerceNotificationTemplate.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> fromNameMap = getFromNameMap();

		for (Map.Entry<Locale, String> entry : fromNameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> subjectMap = getSubjectMap();

		for (Map.Entry<Locale, String> entry : subjectMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> bodyMap = getBodyMap();

		for (Map.Entry<Locale, String> entry : bodyMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getFromName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			CommerceNotificationTemplate.class.getName(), getPrimaryKey(),
			defaultLocale, availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String fromName = getFromName(defaultLocale);

		if (Validator.isNull(fromName)) {
			setFromName(getFromName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setFromName(
				getFromName(defaultLocale), defaultLocale, defaultLocale);
		}

		String subject = getSubject(defaultLocale);

		if (Validator.isNull(subject)) {
			setSubject(getSubject(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setSubject(getSubject(defaultLocale), defaultLocale, defaultLocale);
		}

		String body = getBody(defaultLocale);

		if (Validator.isNull(body)) {
			setBody(getBody(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setBody(getBody(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public CommerceNotificationTemplate toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, CommerceNotificationTemplate>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceNotificationTemplateImpl commerceNotificationTemplateImpl =
			new CommerceNotificationTemplateImpl();

		commerceNotificationTemplateImpl.setUuid(getUuid());
		commerceNotificationTemplateImpl.setCommerceNotificationTemplateId(
			getCommerceNotificationTemplateId());
		commerceNotificationTemplateImpl.setGroupId(getGroupId());
		commerceNotificationTemplateImpl.setCompanyId(getCompanyId());
		commerceNotificationTemplateImpl.setUserId(getUserId());
		commerceNotificationTemplateImpl.setUserName(getUserName());
		commerceNotificationTemplateImpl.setCreateDate(getCreateDate());
		commerceNotificationTemplateImpl.setModifiedDate(getModifiedDate());
		commerceNotificationTemplateImpl.setName(getName());
		commerceNotificationTemplateImpl.setDescription(getDescription());
		commerceNotificationTemplateImpl.setFrom(getFrom());
		commerceNotificationTemplateImpl.setFromName(getFromName());
		commerceNotificationTemplateImpl.setTo(getTo());
		commerceNotificationTemplateImpl.setCc(getCc());
		commerceNotificationTemplateImpl.setBcc(getBcc());
		commerceNotificationTemplateImpl.setType(getType());
		commerceNotificationTemplateImpl.setEnabled(isEnabled());
		commerceNotificationTemplateImpl.setSubject(getSubject());
		commerceNotificationTemplateImpl.setBody(getBody());

		commerceNotificationTemplateImpl.resetOriginalValues();

		return commerceNotificationTemplateImpl;
	}

	@Override
	public int compareTo(
		CommerceNotificationTemplate commerceNotificationTemplate) {

		int value = 0;

		value = DateUtil.compareTo(
			getModifiedDate(), commerceNotificationTemplate.getModifiedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		value = getName().compareTo(commerceNotificationTemplate.getName());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof CommerceNotificationTemplate)) {
			return false;
		}

		CommerceNotificationTemplate commerceNotificationTemplate =
			(CommerceNotificationTemplate)object;

		long primaryKey = commerceNotificationTemplate.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		_originalUuid = _uuid;

		_originalGroupId = _groupId;

		_setOriginalGroupId = false;

		_originalCompanyId = _companyId;

		_setOriginalCompanyId = false;

		_setModifiedDate = false;

		_originalType = _type;

		_originalEnabled = _enabled;

		_setOriginalEnabled = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceNotificationTemplate> toCacheModel() {
		CommerceNotificationTemplateCacheModel
			commerceNotificationTemplateCacheModel =
				new CommerceNotificationTemplateCacheModel();

		commerceNotificationTemplateCacheModel.uuid = getUuid();

		String uuid = commerceNotificationTemplateCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceNotificationTemplateCacheModel.uuid = null;
		}

		commerceNotificationTemplateCacheModel.commerceNotificationTemplateId =
			getCommerceNotificationTemplateId();

		commerceNotificationTemplateCacheModel.groupId = getGroupId();

		commerceNotificationTemplateCacheModel.companyId = getCompanyId();

		commerceNotificationTemplateCacheModel.userId = getUserId();

		commerceNotificationTemplateCacheModel.userName = getUserName();

		String userName = commerceNotificationTemplateCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceNotificationTemplateCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceNotificationTemplateCacheModel.createDate =
				createDate.getTime();
		}
		else {
			commerceNotificationTemplateCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceNotificationTemplateCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			commerceNotificationTemplateCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		commerceNotificationTemplateCacheModel.name = getName();

		String name = commerceNotificationTemplateCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceNotificationTemplateCacheModel.name = null;
		}

		commerceNotificationTemplateCacheModel.description = getDescription();

		String description = commerceNotificationTemplateCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			commerceNotificationTemplateCacheModel.description = null;
		}

		commerceNotificationTemplateCacheModel.from = getFrom();

		String from = commerceNotificationTemplateCacheModel.from;

		if ((from != null) && (from.length() == 0)) {
			commerceNotificationTemplateCacheModel.from = null;
		}

		commerceNotificationTemplateCacheModel.fromName = getFromName();

		String fromName = commerceNotificationTemplateCacheModel.fromName;

		if ((fromName != null) && (fromName.length() == 0)) {
			commerceNotificationTemplateCacheModel.fromName = null;
		}

		commerceNotificationTemplateCacheModel.to = getTo();

		String to = commerceNotificationTemplateCacheModel.to;

		if ((to != null) && (to.length() == 0)) {
			commerceNotificationTemplateCacheModel.to = null;
		}

		commerceNotificationTemplateCacheModel.cc = getCc();

		String cc = commerceNotificationTemplateCacheModel.cc;

		if ((cc != null) && (cc.length() == 0)) {
			commerceNotificationTemplateCacheModel.cc = null;
		}

		commerceNotificationTemplateCacheModel.bcc = getBcc();

		String bcc = commerceNotificationTemplateCacheModel.bcc;

		if ((bcc != null) && (bcc.length() == 0)) {
			commerceNotificationTemplateCacheModel.bcc = null;
		}

		commerceNotificationTemplateCacheModel.type = getType();

		String type = commerceNotificationTemplateCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			commerceNotificationTemplateCacheModel.type = null;
		}

		commerceNotificationTemplateCacheModel.enabled = isEnabled();

		commerceNotificationTemplateCacheModel.subject = getSubject();

		String subject = commerceNotificationTemplateCacheModel.subject;

		if ((subject != null) && (subject.length() == 0)) {
			commerceNotificationTemplateCacheModel.subject = null;
		}

		commerceNotificationTemplateCacheModel.body = getBody();

		String body = commerceNotificationTemplateCacheModel.body;

		if ((body != null) && (body.length() == 0)) {
			commerceNotificationTemplateCacheModel.body = null;
		}

		return commerceNotificationTemplateCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<CommerceNotificationTemplate, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<CommerceNotificationTemplate, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationTemplate, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(CommerceNotificationTemplate)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<CommerceNotificationTemplate, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<CommerceNotificationTemplate, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<CommerceNotificationTemplate, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply(
					(CommerceNotificationTemplate)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, CommerceNotificationTemplate>
				_escapedModelProxyProviderFunction =
					_getProxyProviderFunction();

	}

	private String _uuid;
	private String _originalUuid;
	private long _commerceNotificationTemplateId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _name;
	private String _description;
	private String _from;
	private String _fromName;
	private String _fromNameCurrentLanguageId;
	private String _to;
	private String _cc;
	private String _bcc;
	private String _type;
	private String _originalType;
	private boolean _enabled;
	private boolean _originalEnabled;
	private boolean _setOriginalEnabled;
	private String _subject;
	private String _subjectCurrentLanguageId;
	private String _body;
	private String _bodyCurrentLanguageId;
	private long _columnBitmask;
	private CommerceNotificationTemplate _escapedModel;

}