/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.notification.internal.util;

import com.liferay.commerce.account.service.CommerceAccountGroupLocalService;
import com.liferay.commerce.notification.model.CommerceNotificationTemplate;
import com.liferay.commerce.notification.model.CommerceNotificationTemplateCommerceAccountGroupRel;
import com.liferay.commerce.notification.service.CommerceNotificationQueueEntryLocalService;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateCommerceAccountGroupRelLocalService;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateLocalService;
import com.liferay.commerce.notification.type.CommerceNotificationType;
import com.liferay.commerce.notification.type.CommerceNotificationTypeRegistry;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommerceNotificationHelper.class})
public class CommerceNotificationHelperImpl
implements CommerceNotificationHelper {
    private static final Pattern _placeholderPattern = Pattern.compile("\\[%[^\\[%]+%\\]", 2);
    @Reference
    private CommerceAccountGroupLocalService _commerceAccountGroupLocalService;
    @Reference
    private CommerceNotificationQueueEntryLocalService _commerceNotificationQueueEntryLocalService;
    @Reference
    private CommerceNotificationTemplateCommerceAccountGroupRelLocalService _commerceNotificationTemplateCommerceAccountGroupRelLocalService;
    @Reference
    private CommerceNotificationTemplateLocalService _commerceNotificationTemplateLocalService;
    @Reference
    private CommerceNotificationTypeRegistry _commerceNotificationTypeRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void sendNotifications(long groupId, String key, Object object) throws PortalException {
        this.sendNotifications(groupId, key, object, null);
    }

    public void sendNotifications(long groupId, String key, Object object, long[] userIds) throws PortalException {
        CommerceNotificationType commerceNotificationType = this._commerceNotificationTypeRegistry.getCommerceNotificationType(key);
        List commerceNotificationTemplates = this._commerceNotificationTemplateLocalService.getCommerceNotificationTemplates(groupId, commerceNotificationType.getKey(), true);
        for (CommerceNotificationTemplate commerceNotificationTemplate : commerceNotificationTemplates) {
            List commerceNotificationTemplateCommerceAccountGroupRels = this._commerceNotificationTemplateCommerceAccountGroupRelLocalService.getCommerceNotificationTemplateCommerceAccountGroupRels(commerceNotificationTemplate.getCommerceNotificationTemplateId(), -1, -1, null);
            long[] commerceAccountGroupIds = ListUtil.toLongArray((List)commerceNotificationTemplateCommerceAccountGroupRels, (Accessor)CommerceNotificationTemplateCommerceAccountGroupRel.COMMERCE_ACCOUNT_GROUP_ID_ACCESSOR);
            if (ArrayUtil.isEmpty((long[])userIds)) {
                this.sendNotificationsToAccountGroupUsers(commerceAccountGroupIds, commerceNotificationTemplate, commerceNotificationType, object);
                continue;
            }
            this.sendNotificationsToUserIds(userIds, commerceAccountGroupIds, commerceNotificationTemplate, commerceNotificationType, object);
        }
    }

    protected String formatString(CommerceNotificationType commerceNotificationType, String content, Object object, Locale locale) throws PortalException {
        if (Validator.isNull((String)content)) {
            return "";
        }
        HashSet<String> placeholders = new HashSet<String>();
        Matcher matcher = _placeholderPattern.matcher(content);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        for (String placeholder : placeholders) {
            content = content.replace(placeholder, commerceNotificationType.getFilledTerm(placeholder, object, locale));
        }
        return content;
    }

    protected void sendNotification(CommerceNotificationTemplate commerceNotificationTemplate, CommerceNotificationType commerceNotificationType, Object object, long userId) throws PortalException {
        long groupId = commerceNotificationTemplate.getGroupId();
        User user = this._userLocalService.getUser(userId);
        Locale siteDefaultLocale = this._portal.getSiteDefaultLocale(groupId);
        Locale userLocale = user.getLocale();
        String fromName = commerceNotificationTemplate.getFromName(user.getLanguageId());
        String subject = this.formatString(commerceNotificationType, commerceNotificationTemplate.getSubject(userLocale), object, userLocale);
        String body = this.formatString(commerceNotificationType, commerceNotificationTemplate.getBody(userLocale), object, userLocale);
        if (Validator.isNull((String)fromName)) {
            fromName = commerceNotificationTemplate.getFromName(this._portal.getSiteDefaultLocale(groupId));
        }
        if (Validator.isNull((String)subject)) {
            subject = this.formatString(commerceNotificationType, commerceNotificationTemplate.getSubject(siteDefaultLocale), object, siteDefaultLocale);
        }
        if (Validator.isNull((String)body)) {
            this.formatString(commerceNotificationType, commerceNotificationTemplate.getBody(siteDefaultLocale), object, siteDefaultLocale);
        }
        this._commerceNotificationQueueEntryLocalService.addCommerceNotificationQueueEntry(user.getUserId(), groupId, commerceNotificationTemplate.getCommerceNotificationTemplateId(), commerceNotificationTemplate.getFrom(), fromName, user.getEmailAddress(), user.getFullName(), commerceNotificationTemplate.getCc(), commerceNotificationTemplate.getBcc(), subject, body, 0.0);
    }

    protected void sendNotificationsToAccountGroupUsers(long[] commerceAccountGroupIds, CommerceNotificationTemplate commerceNotificationTemplate, CommerceNotificationType commerceNotificationType, Object object) throws PortalException {
    }

    protected void sendNotificationsToUserIds(long[] userIds, long[] commerceAccountGroupIds, CommerceNotificationTemplate commerceNotificationTemplate, CommerceNotificationType commerceNotificationType, Object object) throws PortalException {
    }
}

