/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.notification.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRel;
import com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRelModel;
import com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRelSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the CommerceNotificationTemplateUserSegmentRel service. Represents a row in the &quot;CNTemplateUserSegmentRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceNotificationTemplateUserSegmentRelModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceNotificationTemplateUserSegmentRelImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceNotificationTemplateUserSegmentRelImpl
 * @see CommerceNotificationTemplateUserSegmentRel
 * @see CommerceNotificationTemplateUserSegmentRelModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceNotificationTemplateUserSegmentRelModelImpl
	extends BaseModelImpl<CommerceNotificationTemplateUserSegmentRel>
	implements CommerceNotificationTemplateUserSegmentRelModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce notification template user segment rel model instance should use the {@link CommerceNotificationTemplateUserSegmentRel} interface instead.
	 */
	public static final String TABLE_NAME = "CNTemplateUserSegmentRel";
	public static final Object[][] TABLE_COLUMNS = {
			{ "CNTemplateUserSegmentRelId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "commerceNotificationTemplateId", Types.BIGINT },
			{ "commerceUserSegmentEntryId", Types.BIGINT }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("CNTemplateUserSegmentRelId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("commerceNotificationTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("commerceUserSegmentEntryId", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE = "create table CNTemplateUserSegmentRel (CNTemplateUserSegmentRelId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,commerceNotificationTemplateId LONG,commerceUserSegmentEntryId LONG)";
	public static final String TABLE_SQL_DROP = "drop table CNTemplateUserSegmentRel";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceNotificationTemplateUserSegmentRel.createDate DESC";
	public static final String ORDER_BY_SQL = " ORDER BY CNTemplateUserSegmentRel.createDate DESC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRel"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRel"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRel"),
			true);
	public static final long COMMERCENOTIFICATIONTEMPLATEID_COLUMN_BITMASK = 1L;
	public static final long COMMERCEUSERSEGMENTENTRYID_COLUMN_BITMASK = 2L;
	public static final long CREATEDATE_COLUMN_BITMASK = 4L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceNotificationTemplateUserSegmentRel toModel(
		CommerceNotificationTemplateUserSegmentRelSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceNotificationTemplateUserSegmentRel model = new CommerceNotificationTemplateUserSegmentRelImpl();

		model.setCommerceNotificationTemplateUserSegmentRelId(soapModel.getCommerceNotificationTemplateUserSegmentRelId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCommerceNotificationTemplateId(soapModel.getCommerceNotificationTemplateId());
		model.setCommerceUserSegmentEntryId(soapModel.getCommerceUserSegmentEntryId());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceNotificationTemplateUserSegmentRel> toModels(
		CommerceNotificationTemplateUserSegmentRelSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceNotificationTemplateUserSegmentRel> models = new ArrayList<CommerceNotificationTemplateUserSegmentRel>(soapModels.length);

		for (CommerceNotificationTemplateUserSegmentRelSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRel"));

	public CommerceNotificationTemplateUserSegmentRelModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceNotificationTemplateUserSegmentRelId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceNotificationTemplateUserSegmentRelId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceNotificationTemplateUserSegmentRelId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceNotificationTemplateUserSegmentRel.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceNotificationTemplateUserSegmentRel.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("commerceNotificationTemplateUserSegmentRelId",
			getCommerceNotificationTemplateUserSegmentRelId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("commerceNotificationTemplateId",
			getCommerceNotificationTemplateId());
		attributes.put("commerceUserSegmentEntryId",
			getCommerceUserSegmentEntryId());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long commerceNotificationTemplateUserSegmentRelId = (Long)attributes.get(
				"commerceNotificationTemplateUserSegmentRelId");

		if (commerceNotificationTemplateUserSegmentRelId != null) {
			setCommerceNotificationTemplateUserSegmentRelId(commerceNotificationTemplateUserSegmentRelId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long commerceNotificationTemplateId = (Long)attributes.get(
				"commerceNotificationTemplateId");

		if (commerceNotificationTemplateId != null) {
			setCommerceNotificationTemplateId(commerceNotificationTemplateId);
		}

		Long commerceUserSegmentEntryId = (Long)attributes.get(
				"commerceUserSegmentEntryId");

		if (commerceUserSegmentEntryId != null) {
			setCommerceUserSegmentEntryId(commerceUserSegmentEntryId);
		}
	}

	@JSON
	@Override
	public long getCommerceNotificationTemplateUserSegmentRelId() {
		return _commerceNotificationTemplateUserSegmentRelId;
	}

	@Override
	public void setCommerceNotificationTemplateUserSegmentRelId(
		long commerceNotificationTemplateUserSegmentRelId) {
		_commerceNotificationTemplateUserSegmentRelId = commerceNotificationTemplateUserSegmentRelId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_groupId = groupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCommerceNotificationTemplateId() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setCommerceNotificationTemplateId(
		long commerceNotificationTemplateId) {
		_columnBitmask |= COMMERCENOTIFICATIONTEMPLATEID_COLUMN_BITMASK;

		if (!_setOriginalCommerceNotificationTemplateId) {
			_setOriginalCommerceNotificationTemplateId = true;

			_originalCommerceNotificationTemplateId = _commerceNotificationTemplateId;
		}

		_commerceNotificationTemplateId = commerceNotificationTemplateId;
	}

	public long getOriginalCommerceNotificationTemplateId() {
		return _originalCommerceNotificationTemplateId;
	}

	@JSON
	@Override
	public long getCommerceUserSegmentEntryId() {
		return _commerceUserSegmentEntryId;
	}

	@Override
	public void setCommerceUserSegmentEntryId(long commerceUserSegmentEntryId) {
		_columnBitmask |= COMMERCEUSERSEGMENTENTRYID_COLUMN_BITMASK;

		if (!_setOriginalCommerceUserSegmentEntryId) {
			_setOriginalCommerceUserSegmentEntryId = true;

			_originalCommerceUserSegmentEntryId = _commerceUserSegmentEntryId;
		}

		_commerceUserSegmentEntryId = commerceUserSegmentEntryId;
	}

	public long getOriginalCommerceUserSegmentEntryId() {
		return _originalCommerceUserSegmentEntryId;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceNotificationTemplateUserSegmentRel.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public CommerceNotificationTemplateUserSegmentRel toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceNotificationTemplateUserSegmentRel)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceNotificationTemplateUserSegmentRelImpl commerceNotificationTemplateUserSegmentRelImpl =
			new CommerceNotificationTemplateUserSegmentRelImpl();

		commerceNotificationTemplateUserSegmentRelImpl.setCommerceNotificationTemplateUserSegmentRelId(getCommerceNotificationTemplateUserSegmentRelId());
		commerceNotificationTemplateUserSegmentRelImpl.setGroupId(getGroupId());
		commerceNotificationTemplateUserSegmentRelImpl.setCompanyId(getCompanyId());
		commerceNotificationTemplateUserSegmentRelImpl.setUserId(getUserId());
		commerceNotificationTemplateUserSegmentRelImpl.setUserName(getUserName());
		commerceNotificationTemplateUserSegmentRelImpl.setCreateDate(getCreateDate());
		commerceNotificationTemplateUserSegmentRelImpl.setModifiedDate(getModifiedDate());
		commerceNotificationTemplateUserSegmentRelImpl.setCommerceNotificationTemplateId(getCommerceNotificationTemplateId());
		commerceNotificationTemplateUserSegmentRelImpl.setCommerceUserSegmentEntryId(getCommerceUserSegmentEntryId());

		commerceNotificationTemplateUserSegmentRelImpl.resetOriginalValues();

		return commerceNotificationTemplateUserSegmentRelImpl;
	}

	@Override
	public int compareTo(
		CommerceNotificationTemplateUserSegmentRel commerceNotificationTemplateUserSegmentRel) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(),
				commerceNotificationTemplateUserSegmentRel.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceNotificationTemplateUserSegmentRel)) {
			return false;
		}

		CommerceNotificationTemplateUserSegmentRel commerceNotificationTemplateUserSegmentRel =
			(CommerceNotificationTemplateUserSegmentRel)obj;

		long primaryKey = commerceNotificationTemplateUserSegmentRel.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceNotificationTemplateUserSegmentRelModelImpl commerceNotificationTemplateUserSegmentRelModelImpl =
			this;

		commerceNotificationTemplateUserSegmentRelModelImpl._setModifiedDate = false;

		commerceNotificationTemplateUserSegmentRelModelImpl._originalCommerceNotificationTemplateId = commerceNotificationTemplateUserSegmentRelModelImpl._commerceNotificationTemplateId;

		commerceNotificationTemplateUserSegmentRelModelImpl._setOriginalCommerceNotificationTemplateId = false;

		commerceNotificationTemplateUserSegmentRelModelImpl._originalCommerceUserSegmentEntryId = commerceNotificationTemplateUserSegmentRelModelImpl._commerceUserSegmentEntryId;

		commerceNotificationTemplateUserSegmentRelModelImpl._setOriginalCommerceUserSegmentEntryId = false;

		commerceNotificationTemplateUserSegmentRelModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceNotificationTemplateUserSegmentRel> toCacheModel() {
		CommerceNotificationTemplateUserSegmentRelCacheModel commerceNotificationTemplateUserSegmentRelCacheModel =
			new CommerceNotificationTemplateUserSegmentRelCacheModel();

		commerceNotificationTemplateUserSegmentRelCacheModel.commerceNotificationTemplateUserSegmentRelId = getCommerceNotificationTemplateUserSegmentRelId();

		commerceNotificationTemplateUserSegmentRelCacheModel.groupId = getGroupId();

		commerceNotificationTemplateUserSegmentRelCacheModel.companyId = getCompanyId();

		commerceNotificationTemplateUserSegmentRelCacheModel.userId = getUserId();

		commerceNotificationTemplateUserSegmentRelCacheModel.userName = getUserName();

		String userName = commerceNotificationTemplateUserSegmentRelCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceNotificationTemplateUserSegmentRelCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceNotificationTemplateUserSegmentRelCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceNotificationTemplateUserSegmentRelCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceNotificationTemplateUserSegmentRelCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceNotificationTemplateUserSegmentRelCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceNotificationTemplateUserSegmentRelCacheModel.commerceNotificationTemplateId = getCommerceNotificationTemplateId();

		commerceNotificationTemplateUserSegmentRelCacheModel.commerceUserSegmentEntryId = getCommerceUserSegmentEntryId();

		return commerceNotificationTemplateUserSegmentRelCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(19);

		sb.append("{commerceNotificationTemplateUserSegmentRelId=");
		sb.append(getCommerceNotificationTemplateUserSegmentRelId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", commerceNotificationTemplateId=");
		sb.append(getCommerceNotificationTemplateId());
		sb.append(", commerceUserSegmentEntryId=");
		sb.append(getCommerceUserSegmentEntryId());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(31);

		sb.append("<model><model-name>");
		sb.append(
			"com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRel");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>commerceNotificationTemplateUserSegmentRelId</column-name><column-value><![CDATA[");
		sb.append(getCommerceNotificationTemplateUserSegmentRelId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceNotificationTemplateId</column-name><column-value><![CDATA[");
		sb.append(getCommerceNotificationTemplateId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceUserSegmentEntryId</column-name><column-value><![CDATA[");
		sb.append(getCommerceUserSegmentEntryId());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceNotificationTemplateUserSegmentRel.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceNotificationTemplateUserSegmentRel.class, ModelWrapper.class
		};
	private long _commerceNotificationTemplateUserSegmentRelId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _commerceNotificationTemplateId;
	private long _originalCommerceNotificationTemplateId;
	private boolean _setOriginalCommerceNotificationTemplateId;
	private long _commerceUserSegmentEntryId;
	private long _originalCommerceUserSegmentEntryId;
	private boolean _setOriginalCommerceUserSegmentEntryId;
	private long _columnBitmask;
	private CommerceNotificationTemplateUserSegmentRel _escapedModel;
}