/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.notification.service.impl;

import com.liferay.commerce.notification.model.CommerceNotificationAttachment;
import com.liferay.commerce.notification.model.CommerceNotificationQueueEntry;
import com.liferay.commerce.notification.service.base.CommerceNotificationQueueEntryLocalServiceBaseImpl;
import com.liferay.commerce.notification.util.comparator.CommerceNotificationAttachmentCreateDateComparator;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.internet.InternetAddress;

public class CommerceNotificationQueueEntryLocalServiceImpl
extends CommerceNotificationQueueEntryLocalServiceBaseImpl {
    @ServiceReference(type=MailService.class)
    private MailService _mailService;

    @Indexable(type=IndexableType.REINDEX)
    public CommerceNotificationQueueEntry addCommerceNotificationQueueEntry(long userId, long groupId, long commerceNotificationTemplateId, String from, String fromName, String to, String toName, String cc, String bcc, String subject, String body, double priority) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long commerceNotificationQueueEntryId = this.counterLocalService.increment();
        CommerceNotificationQueueEntry commerceNotificationQueueEntry = this.commerceNotificationQueueEntryPersistence.create(commerceNotificationQueueEntryId);
        commerceNotificationQueueEntry.setGroupId(groupId);
        commerceNotificationQueueEntry.setCompanyId(user.getCompanyId());
        commerceNotificationQueueEntry.setUserId(user.getUserId());
        commerceNotificationQueueEntry.setUserName(user.getFullName());
        commerceNotificationQueueEntry.setCommerceNotificationTemplateId(commerceNotificationTemplateId);
        commerceNotificationQueueEntry.setFrom(from);
        commerceNotificationQueueEntry.setFromName(fromName);
        commerceNotificationQueueEntry.setTo(to);
        commerceNotificationQueueEntry.setToName(toName);
        commerceNotificationQueueEntry.setCc(cc);
        commerceNotificationQueueEntry.setBcc(bcc);
        commerceNotificationQueueEntry.setSubject(subject);
        commerceNotificationQueueEntry.setBody(body);
        commerceNotificationQueueEntry.setPriority(priority);
        this.commerceNotificationQueueEntryPersistence.update((BaseModel)commerceNotificationQueueEntry);
        return commerceNotificationQueueEntry;
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceNotificationQueueEntry deleteCommerceNotificationQueue(CommerceNotificationQueueEntry commerceNotificationQueueEntry) throws PortalException {
        this.commerceNotificationAttachmentLocalService.deleteCommerceNotificationAttachments(commerceNotificationQueueEntry.getCommerceNotificationQueueEntryId());
        this.commerceNotificationQueueEntryPersistence.remove((BaseModel)commerceNotificationQueueEntry);
        return commerceNotificationQueueEntry;
    }

    public void deleteCommerceNotificationQueueEntries(Date sentDate) {
        this.commerceNotificationQueueEntryPersistence.removeByLtS(sentDate);
    }

    public void deleteCommerceNotificationQueueEntries(long groupId) throws PortalException {
        List commerceNotificationQueueEntries = this.commerceNotificationQueueEntryPersistence.findByGroupId(groupId);
        for (CommerceNotificationQueueEntry commerceNotificationQueueEntry : commerceNotificationQueueEntries) {
            this.commerceNotificationQueueEntryLocalService.deleteCommerceNotificationQueue(commerceNotificationQueueEntry);
        }
    }

    @Override
    public CommerceNotificationQueueEntry deleteCommerceNotificationQueueEntry(long commerceNotificationQueueEntryId) throws PortalException {
        CommerceNotificationQueueEntry commerceNotificationQueueEntry = this.commerceNotificationQueueEntryPersistence.findByPrimaryKey(commerceNotificationQueueEntryId);
        return this.commerceNotificationQueueEntryLocalService.deleteCommerceNotificationQueue(commerceNotificationQueueEntry);
    }

    public List<CommerceNotificationQueueEntry> getCommerceNotificationQueueEntries(boolean sent) {
        return this.commerceNotificationQueueEntryPersistence.findBySent(sent);
    }

    public List<CommerceNotificationQueueEntry> getCommerceNotificationQueueEntries(long groupId, int start, int end, OrderByComparator<CommerceNotificationQueueEntry> orderByComparator) {
        return this.commerceNotificationQueueEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public int getCommerceNotificationQueueEntriesCount(long groupId) {
        return this.commerceNotificationQueueEntryPersistence.countByGroupId(groupId);
    }

    public CommerceNotificationQueueEntry resendCommerceNotificationQueueEntry(long commerceNotificationQueueEntryId) throws PortalException {
        return this.commerceNotificationQueueEntryLocalService.updateSent(commerceNotificationQueueEntryId, false);
    }

    public void sendCommerceNotificationQueueEntries() throws Exception {
        List commerceNotificationQueueEntries = this.commerceNotificationQueueEntryPersistence.findBySent(false);
        for (CommerceNotificationQueueEntry commerceNotificationQueueEntry : commerceNotificationQueueEntries) {
            InternetAddress from = new InternetAddress(commerceNotificationQueueEntry.getFrom(), commerceNotificationQueueEntry.getFromName());
            InternetAddress to = new InternetAddress(commerceNotificationQueueEntry.getTo(), commerceNotificationQueueEntry.getToName());
            MailMessage mailMessage = new MailMessage(from, to, commerceNotificationQueueEntry.getSubject(), commerceNotificationQueueEntry.getBody(), true);
            List commerceNotificationAttachments = this.commerceNotificationAttachmentLocalService.getCommerceNotificationAttachments(commerceNotificationQueueEntry.getCommerceNotificationQueueEntryId(), -1, -1, (OrderByComparator)new CommerceNotificationAttachmentCreateDateComparator());
            for (CommerceNotificationAttachment commerceNotificationAttachment : commerceNotificationAttachments) {
                FileEntry fileEntry = commerceNotificationAttachment.getFileEntry();
                mailMessage.addFileAttachment(FileUtil.createTempFile((InputStream)fileEntry.getContentStream()), fileEntry.getFileName());
            }
            ArrayList<InternetAddress> bccInternetAddresses = new ArrayList<InternetAddress>();
            ArrayList<InternetAddress> ccInternetAddresses = new ArrayList<InternetAddress>();
            String[] bccAddresses = StringUtil.split((String)commerceNotificationQueueEntry.getBcc());
            String[] ccAddresses = StringUtil.split((String)commerceNotificationQueueEntry.getCc());
            for (String bccAddress : bccAddresses) {
                bccInternetAddresses.add(new InternetAddress(bccAddress));
            }
            for (String ccAddress : ccAddresses) {
                ccInternetAddresses.add(new InternetAddress(ccAddress));
            }
            mailMessage.setBCC(bccInternetAddresses.toArray(new InternetAddress[bccInternetAddresses.size()]));
            mailMessage.setCC(ccInternetAddresses.toArray(new InternetAddress[ccInternetAddresses.size()]));
            try {
                this._mailService.sendEmail(mailMessage);
                this.commerceNotificationQueueEntryLocalService.updateSent(commerceNotificationQueueEntry.getCommerceNotificationQueueEntryId(), true);
            }
            catch (Exception e) {}
        }
    }

    public void updateCommerceNotificationQueueEntriesTemplateIds(long commerceNotificationTemplateId) {
        List commerceNotificationQueueEntries = this.commerceNotificationQueueEntryPersistence.findByCommerceNotificationTemplateId(commerceNotificationTemplateId);
        for (CommerceNotificationQueueEntry commerceNotificationQueueEntry : commerceNotificationQueueEntries) {
            this.updateCommerceNotificationQueueEntry(commerceNotificationQueueEntry, 0L);
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceNotificationQueueEntry updateSent(long commerceNotificationQueueEntryId, boolean sent) throws PortalException {
        CommerceNotificationQueueEntry commerceNotificationQueueEntry = this.commerceNotificationQueueEntryPersistence.findByPrimaryKey(commerceNotificationQueueEntryId);
        commerceNotificationQueueEntry.setSent(sent);
        if (sent) {
            commerceNotificationQueueEntry.setSentDate(new Date());
        } else {
            commerceNotificationQueueEntry.setSentDate(null);
        }
        this.commerceNotificationQueueEntryPersistence.update((BaseModel)commerceNotificationQueueEntry);
        return commerceNotificationQueueEntry;
    }

    @Indexable(type=IndexableType.REINDEX)
    protected CommerceNotificationQueueEntry updateCommerceNotificationQueueEntry(CommerceNotificationQueueEntry commerceNotificationQueueEntry, long commerceNotificationTemplateId) {
        commerceNotificationQueueEntry.setCommerceNotificationTemplateId(commerceNotificationTemplateId);
        this.commerceNotificationQueueEntryPersistence.update((BaseModel)commerceNotificationQueueEntry);
        return commerceNotificationQueueEntry;
    }
}

