/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.commerce.notification.model.impl;

import aQute.bnd.annotation.ProviderType;

import com.liferay.commerce.notification.model.CommerceNotificationTemplate;
import com.liferay.commerce.notification.model.CommerceNotificationTemplateModel;
import com.liferay.commerce.notification.model.CommerceNotificationTemplateSoap;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;

import com.liferay.exportimport.kernel.lar.StagedModelType;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/**
 * The base model implementation for the CommerceNotificationTemplate service. Represents a row in the &quot;CommerceNotificationTemplate&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link CommerceNotificationTemplateModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceNotificationTemplateImpl}.
 * </p>
 *
 * @author Alessio Antonio Rendina
 * @see CommerceNotificationTemplateImpl
 * @see CommerceNotificationTemplate
 * @see CommerceNotificationTemplateModel
 * @generated
 */
@JSON(strict = true)
@ProviderType
public class CommerceNotificationTemplateModelImpl extends BaseModelImpl<CommerceNotificationTemplate>
	implements CommerceNotificationTemplateModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce notification template model instance should use the {@link CommerceNotificationTemplate} interface instead.
	 */
	public static final String TABLE_NAME = "CommerceNotificationTemplate";
	public static final Object[][] TABLE_COLUMNS = {
			{ "uuid_", Types.VARCHAR },
			{ "commerceNotificationTemplateId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "name", Types.VARCHAR },
			{ "description", Types.VARCHAR },
			{ "from_", Types.VARCHAR },
			{ "fromName", Types.VARCHAR },
			{ "cc", Types.VARCHAR },
			{ "bcc", Types.VARCHAR },
			{ "type_", Types.VARCHAR },
			{ "enabled", Types.BOOLEAN },
			{ "subject", Types.VARCHAR },
			{ "body", Types.CLOB }
		};
	public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("commerceNotificationTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("from_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fromName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("cc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("bcc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("enabled", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("subject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("body", Types.CLOB);
	}

	public static final String TABLE_SQL_CREATE = "create table CommerceNotificationTemplate (uuid_ VARCHAR(75) null,commerceNotificationTemplateId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,name VARCHAR(75) null,description STRING null,from_ VARCHAR(75) null,fromName STRING null,cc VARCHAR(255) null,bcc VARCHAR(255) null,type_ VARCHAR(75) null,enabled BOOLEAN,subject STRING null,body TEXT null)";
	public static final String TABLE_SQL_DROP = "drop table CommerceNotificationTemplate";
	public static final String ORDER_BY_JPQL = " ORDER BY commerceNotificationTemplate.modifiedDate DESC, commerceNotificationTemplate.name DESC";
	public static final String ORDER_BY_SQL = " ORDER BY CommerceNotificationTemplate.modifiedDate DESC, CommerceNotificationTemplate.name DESC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.entity.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplate"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.finder.cache.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplate"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"value.object.column.bitmask.enabled.com.liferay.commerce.notification.model.CommerceNotificationTemplate"),
			true);
	public static final long COMPANYID_COLUMN_BITMASK = 1L;
	public static final long ENABLED_COLUMN_BITMASK = 2L;
	public static final long GROUPID_COLUMN_BITMASK = 4L;
	public static final long TYPE_COLUMN_BITMASK = 8L;
	public static final long UUID_COLUMN_BITMASK = 16L;
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 32L;
	public static final long NAME_COLUMN_BITMASK = 64L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static CommerceNotificationTemplate toModel(
		CommerceNotificationTemplateSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		CommerceNotificationTemplate model = new CommerceNotificationTemplateImpl();

		model.setUuid(soapModel.getUuid());
		model.setCommerceNotificationTemplateId(soapModel.getCommerceNotificationTemplateId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setName(soapModel.getName());
		model.setDescription(soapModel.getDescription());
		model.setFrom(soapModel.getFrom());
		model.setFromName(soapModel.getFromName());
		model.setCc(soapModel.getCc());
		model.setBcc(soapModel.getBcc());
		model.setType(soapModel.getType());
		model.setEnabled(soapModel.isEnabled());
		model.setSubject(soapModel.getSubject());
		model.setBody(soapModel.getBody());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<CommerceNotificationTemplate> toModels(
		CommerceNotificationTemplateSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<CommerceNotificationTemplate> models = new ArrayList<CommerceNotificationTemplate>(soapModels.length);

		for (CommerceNotificationTemplateSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.commerce.notification.service.util.ServiceProps.get(
				"lock.expiration.time.com.liferay.commerce.notification.model.CommerceNotificationTemplate"));

	public CommerceNotificationTemplateModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setCommerceNotificationTemplateId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return CommerceNotificationTemplate.class;
	}

	@Override
	public String getModelClassName() {
		return CommerceNotificationTemplate.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("uuid", getUuid());
		attributes.put("commerceNotificationTemplateId",
			getCommerceNotificationTemplateId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("name", getName());
		attributes.put("description", getDescription());
		attributes.put("from", getFrom());
		attributes.put("fromName", getFromName());
		attributes.put("cc", getCc());
		attributes.put("bcc", getBcc());
		attributes.put("type", getType());
		attributes.put("enabled", isEnabled());
		attributes.put("subject", getSubject());
		attributes.put("body", getBody());

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		String uuid = (String)attributes.get("uuid");

		if (uuid != null) {
			setUuid(uuid);
		}

		Long commerceNotificationTemplateId = (Long)attributes.get(
				"commerceNotificationTemplateId");

		if (commerceNotificationTemplateId != null) {
			setCommerceNotificationTemplateId(commerceNotificationTemplateId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String name = (String)attributes.get("name");

		if (name != null) {
			setName(name);
		}

		String description = (String)attributes.get("description");

		if (description != null) {
			setDescription(description);
		}

		String from = (String)attributes.get("from");

		if (from != null) {
			setFrom(from);
		}

		String fromName = (String)attributes.get("fromName");

		if (fromName != null) {
			setFromName(fromName);
		}

		String cc = (String)attributes.get("cc");

		if (cc != null) {
			setCc(cc);
		}

		String bcc = (String)attributes.get("bcc");

		if (bcc != null) {
			setBcc(bcc);
		}

		String type = (String)attributes.get("type");

		if (type != null) {
			setType(type);
		}

		Boolean enabled = (Boolean)attributes.get("enabled");

		if (enabled != null) {
			setEnabled(enabled);
		}

		String subject = (String)attributes.get("subject");

		if (subject != null) {
			setSubject(subject);
		}

		String body = (String)attributes.get("body");

		if (body != null) {
			setBody(body);
		}
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_originalUuid == null) {
			_originalUuid = _uuid;
		}

		_uuid = uuid;
	}

	public String getOriginalUuid() {
		return GetterUtil.getString(_originalUuid);
	}

	@JSON
	@Override
	public long getCommerceNotificationTemplateId() {
		return _commerceNotificationTemplateId;
	}

	@Override
	public void setCommerceNotificationTemplateId(
		long commerceNotificationTemplateId) {
		_commerceNotificationTemplateId = commerceNotificationTemplateId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException pe) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		_columnBitmask = -1L;

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_columnBitmask = -1L;

		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@JSON
	@Override
	public String getFrom() {
		if (_from == null) {
			return "";
		}
		else {
			return _from;
		}
	}

	@Override
	public void setFrom(String from) {
		_from = from;
	}

	@JSON
	@Override
	public String getFromName() {
		if (_fromName == null) {
			return "";
		}
		else {
			return _fromName;
		}
	}

	@Override
	public String getFromName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getFromName(languageId);
	}

	@Override
	public String getFromName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getFromName(languageId, useDefault);
	}

	@Override
	public String getFromName(String languageId) {
		return LocalizationUtil.getLocalization(getFromName(), languageId);
	}

	@Override
	public String getFromName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(getFromName(), languageId,
			useDefault);
	}

	@Override
	public String getFromNameCurrentLanguageId() {
		return _fromNameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getFromNameCurrentValue() {
		Locale locale = getLocale(_fromNameCurrentLanguageId);

		return getFromName(locale);
	}

	@Override
	public Map<Locale, String> getFromNameMap() {
		return LocalizationUtil.getLocalizationMap(getFromName());
	}

	@Override
	public void setFromName(String fromName) {
		_fromName = fromName;
	}

	@Override
	public void setFromName(String fromName, Locale locale) {
		setFromName(fromName, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setFromName(String fromName, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(fromName)) {
			setFromName(LocalizationUtil.updateLocalization(getFromName(),
					"FromName", fromName, languageId, defaultLanguageId));
		}
		else {
			setFromName(LocalizationUtil.removeLocalization(getFromName(),
					"FromName", languageId));
		}
	}

	@Override
	public void setFromNameCurrentLanguageId(String languageId) {
		_fromNameCurrentLanguageId = languageId;
	}

	@Override
	public void setFromNameMap(Map<Locale, String> fromNameMap) {
		setFromNameMap(fromNameMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setFromNameMap(Map<Locale, String> fromNameMap,
		Locale defaultLocale) {
		if (fromNameMap == null) {
			return;
		}

		setFromName(LocalizationUtil.updateLocalization(fromNameMap,
				getFromName(), "FromName",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getCc() {
		if (_cc == null) {
			return "";
		}
		else {
			return _cc;
		}
	}

	@Override
	public void setCc(String cc) {
		_cc = cc;
	}

	@JSON
	@Override
	public String getBcc() {
		if (_bcc == null) {
			return "";
		}
		else {
			return _bcc;
		}
	}

	@Override
	public void setBcc(String bcc) {
		_bcc = bcc;
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		_columnBitmask |= TYPE_COLUMN_BITMASK;

		if (_originalType == null) {
			_originalType = _type;
		}

		_type = type;
	}

	public String getOriginalType() {
		return GetterUtil.getString(_originalType);
	}

	@JSON
	@Override
	public boolean getEnabled() {
		return _enabled;
	}

	@JSON
	@Override
	public boolean isEnabled() {
		return _enabled;
	}

	@Override
	public void setEnabled(boolean enabled) {
		_columnBitmask |= ENABLED_COLUMN_BITMASK;

		if (!_setOriginalEnabled) {
			_setOriginalEnabled = true;

			_originalEnabled = _enabled;
		}

		_enabled = enabled;
	}

	public boolean getOriginalEnabled() {
		return _originalEnabled;
	}

	@JSON
	@Override
	public String getSubject() {
		if (_subject == null) {
			return "";
		}
		else {
			return _subject;
		}
	}

	@Override
	public String getSubject(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSubject(languageId);
	}

	@Override
	public String getSubject(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSubject(languageId, useDefault);
	}

	@Override
	public String getSubject(String languageId) {
		return LocalizationUtil.getLocalization(getSubject(), languageId);
	}

	@Override
	public String getSubject(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(getSubject(), languageId,
			useDefault);
	}

	@Override
	public String getSubjectCurrentLanguageId() {
		return _subjectCurrentLanguageId;
	}

	@JSON
	@Override
	public String getSubjectCurrentValue() {
		Locale locale = getLocale(_subjectCurrentLanguageId);

		return getSubject(locale);
	}

	@Override
	public Map<Locale, String> getSubjectMap() {
		return LocalizationUtil.getLocalizationMap(getSubject());
	}

	@Override
	public void setSubject(String subject) {
		_subject = subject;
	}

	@Override
	public void setSubject(String subject, Locale locale) {
		setSubject(subject, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setSubject(String subject, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(subject)) {
			setSubject(LocalizationUtil.updateLocalization(getSubject(),
					"Subject", subject, languageId, defaultLanguageId));
		}
		else {
			setSubject(LocalizationUtil.removeLocalization(getSubject(),
					"Subject", languageId));
		}
	}

	@Override
	public void setSubjectCurrentLanguageId(String languageId) {
		_subjectCurrentLanguageId = languageId;
	}

	@Override
	public void setSubjectMap(Map<Locale, String> subjectMap) {
		setSubjectMap(subjectMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setSubjectMap(Map<Locale, String> subjectMap,
		Locale defaultLocale) {
		if (subjectMap == null) {
			return;
		}

		setSubject(LocalizationUtil.updateLocalization(subjectMap,
				getSubject(), "Subject", LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getBody() {
		if (_body == null) {
			return "";
		}
		else {
			return _body;
		}
	}

	@Override
	public String getBody(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getBody(languageId);
	}

	@Override
	public String getBody(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getBody(languageId, useDefault);
	}

	@Override
	public String getBody(String languageId) {
		return LocalizationUtil.getLocalization(getBody(), languageId);
	}

	@Override
	public String getBody(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(getBody(), languageId,
			useDefault);
	}

	@Override
	public String getBodyCurrentLanguageId() {
		return _bodyCurrentLanguageId;
	}

	@JSON
	@Override
	public String getBodyCurrentValue() {
		Locale locale = getLocale(_bodyCurrentLanguageId);

		return getBody(locale);
	}

	@Override
	public Map<Locale, String> getBodyMap() {
		return LocalizationUtil.getLocalizationMap(getBody());
	}

	@Override
	public void setBody(String body) {
		_body = body;
	}

	@Override
	public void setBody(String body, Locale locale) {
		setBody(body, locale, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setBody(String body, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(body)) {
			setBody(LocalizationUtil.updateLocalization(getBody(), "Body",
					body, languageId, defaultLanguageId));
		}
		else {
			setBody(LocalizationUtil.removeLocalization(getBody(), "Body",
					languageId));
		}
	}

	@Override
	public void setBodyCurrentLanguageId(String languageId) {
		_bodyCurrentLanguageId = languageId;
	}

	@Override
	public void setBodyMap(Map<Locale, String> bodyMap) {
		setBodyMap(bodyMap, LocaleUtil.getSiteDefault());
	}

	@Override
	public void setBodyMap(Map<Locale, String> bodyMap, Locale defaultLocale) {
		if (bodyMap == null) {
			return;
		}

		setBody(LocalizationUtil.updateLocalization(bodyMap, getBody(), "Body",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(PortalUtil.getClassNameId(
				CommerceNotificationTemplate.class.getName()));
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			CommerceNotificationTemplate.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> fromNameMap = getFromNameMap();

		for (Map.Entry<Locale, String> entry : fromNameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> subjectMap = getSubjectMap();

		for (Map.Entry<Locale, String> entry : subjectMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> bodyMap = getBodyMap();

		for (Map.Entry<Locale, String> entry : bodyMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getFromName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getSiteDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(CommerceNotificationTemplate.class.getName(),
				getPrimaryKey(), defaultLocale, availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {
		Locale defaultLocale = LocaleUtil.getSiteDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String fromName = getFromName(defaultLocale);

		if (Validator.isNull(fromName)) {
			setFromName(getFromName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setFromName(getFromName(defaultLocale), defaultLocale, defaultLocale);
		}

		String subject = getSubject(defaultLocale);

		if (Validator.isNull(subject)) {
			setSubject(getSubject(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setSubject(getSubject(defaultLocale), defaultLocale, defaultLocale);
		}

		String body = getBody(defaultLocale);

		if (Validator.isNull(body)) {
			setBody(getBody(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setBody(getBody(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public CommerceNotificationTemplate toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (CommerceNotificationTemplate)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		CommerceNotificationTemplateImpl commerceNotificationTemplateImpl = new CommerceNotificationTemplateImpl();

		commerceNotificationTemplateImpl.setUuid(getUuid());
		commerceNotificationTemplateImpl.setCommerceNotificationTemplateId(getCommerceNotificationTemplateId());
		commerceNotificationTemplateImpl.setGroupId(getGroupId());
		commerceNotificationTemplateImpl.setCompanyId(getCompanyId());
		commerceNotificationTemplateImpl.setUserId(getUserId());
		commerceNotificationTemplateImpl.setUserName(getUserName());
		commerceNotificationTemplateImpl.setCreateDate(getCreateDate());
		commerceNotificationTemplateImpl.setModifiedDate(getModifiedDate());
		commerceNotificationTemplateImpl.setName(getName());
		commerceNotificationTemplateImpl.setDescription(getDescription());
		commerceNotificationTemplateImpl.setFrom(getFrom());
		commerceNotificationTemplateImpl.setFromName(getFromName());
		commerceNotificationTemplateImpl.setCc(getCc());
		commerceNotificationTemplateImpl.setBcc(getBcc());
		commerceNotificationTemplateImpl.setType(getType());
		commerceNotificationTemplateImpl.setEnabled(isEnabled());
		commerceNotificationTemplateImpl.setSubject(getSubject());
		commerceNotificationTemplateImpl.setBody(getBody());

		commerceNotificationTemplateImpl.resetOriginalValues();

		return commerceNotificationTemplateImpl;
	}

	@Override
	public int compareTo(
		CommerceNotificationTemplate commerceNotificationTemplate) {
		int value = 0;

		value = DateUtil.compareTo(getModifiedDate(),
				commerceNotificationTemplate.getModifiedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		value = getName().compareTo(commerceNotificationTemplate.getName());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof CommerceNotificationTemplate)) {
			return false;
		}

		CommerceNotificationTemplate commerceNotificationTemplate = (CommerceNotificationTemplate)obj;

		long primaryKey = commerceNotificationTemplate.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		CommerceNotificationTemplateModelImpl commerceNotificationTemplateModelImpl =
			this;

		commerceNotificationTemplateModelImpl._originalUuid = commerceNotificationTemplateModelImpl._uuid;

		commerceNotificationTemplateModelImpl._originalGroupId = commerceNotificationTemplateModelImpl._groupId;

		commerceNotificationTemplateModelImpl._setOriginalGroupId = false;

		commerceNotificationTemplateModelImpl._originalCompanyId = commerceNotificationTemplateModelImpl._companyId;

		commerceNotificationTemplateModelImpl._setOriginalCompanyId = false;

		commerceNotificationTemplateModelImpl._setModifiedDate = false;

		commerceNotificationTemplateModelImpl._originalType = commerceNotificationTemplateModelImpl._type;

		commerceNotificationTemplateModelImpl._originalEnabled = commerceNotificationTemplateModelImpl._enabled;

		commerceNotificationTemplateModelImpl._setOriginalEnabled = false;

		commerceNotificationTemplateModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<CommerceNotificationTemplate> toCacheModel() {
		CommerceNotificationTemplateCacheModel commerceNotificationTemplateCacheModel =
			new CommerceNotificationTemplateCacheModel();

		commerceNotificationTemplateCacheModel.uuid = getUuid();

		String uuid = commerceNotificationTemplateCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			commerceNotificationTemplateCacheModel.uuid = null;
		}

		commerceNotificationTemplateCacheModel.commerceNotificationTemplateId = getCommerceNotificationTemplateId();

		commerceNotificationTemplateCacheModel.groupId = getGroupId();

		commerceNotificationTemplateCacheModel.companyId = getCompanyId();

		commerceNotificationTemplateCacheModel.userId = getUserId();

		commerceNotificationTemplateCacheModel.userName = getUserName();

		String userName = commerceNotificationTemplateCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			commerceNotificationTemplateCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			commerceNotificationTemplateCacheModel.createDate = createDate.getTime();
		}
		else {
			commerceNotificationTemplateCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			commerceNotificationTemplateCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			commerceNotificationTemplateCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		commerceNotificationTemplateCacheModel.name = getName();

		String name = commerceNotificationTemplateCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			commerceNotificationTemplateCacheModel.name = null;
		}

		commerceNotificationTemplateCacheModel.description = getDescription();

		String description = commerceNotificationTemplateCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			commerceNotificationTemplateCacheModel.description = null;
		}

		commerceNotificationTemplateCacheModel.from = getFrom();

		String from = commerceNotificationTemplateCacheModel.from;

		if ((from != null) && (from.length() == 0)) {
			commerceNotificationTemplateCacheModel.from = null;
		}

		commerceNotificationTemplateCacheModel.fromName = getFromName();

		String fromName = commerceNotificationTemplateCacheModel.fromName;

		if ((fromName != null) && (fromName.length() == 0)) {
			commerceNotificationTemplateCacheModel.fromName = null;
		}

		commerceNotificationTemplateCacheModel.cc = getCc();

		String cc = commerceNotificationTemplateCacheModel.cc;

		if ((cc != null) && (cc.length() == 0)) {
			commerceNotificationTemplateCacheModel.cc = null;
		}

		commerceNotificationTemplateCacheModel.bcc = getBcc();

		String bcc = commerceNotificationTemplateCacheModel.bcc;

		if ((bcc != null) && (bcc.length() == 0)) {
			commerceNotificationTemplateCacheModel.bcc = null;
		}

		commerceNotificationTemplateCacheModel.type = getType();

		String type = commerceNotificationTemplateCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			commerceNotificationTemplateCacheModel.type = null;
		}

		commerceNotificationTemplateCacheModel.enabled = isEnabled();

		commerceNotificationTemplateCacheModel.subject = getSubject();

		String subject = commerceNotificationTemplateCacheModel.subject;

		if ((subject != null) && (subject.length() == 0)) {
			commerceNotificationTemplateCacheModel.subject = null;
		}

		commerceNotificationTemplateCacheModel.body = getBody();

		String body = commerceNotificationTemplateCacheModel.body;

		if ((body != null) && (body.length() == 0)) {
			commerceNotificationTemplateCacheModel.body = null;
		}

		return commerceNotificationTemplateCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(37);

		sb.append("{uuid=");
		sb.append(getUuid());
		sb.append(", commerceNotificationTemplateId=");
		sb.append(getCommerceNotificationTemplateId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", name=");
		sb.append(getName());
		sb.append(", description=");
		sb.append(getDescription());
		sb.append(", from=");
		sb.append(getFrom());
		sb.append(", fromName=");
		sb.append(getFromName());
		sb.append(", cc=");
		sb.append(getCc());
		sb.append(", bcc=");
		sb.append(getBcc());
		sb.append(", type=");
		sb.append(getType());
		sb.append(", enabled=");
		sb.append(isEnabled());
		sb.append(", subject=");
		sb.append(getSubject());
		sb.append(", body=");
		sb.append(getBody());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(58);

		sb.append("<model><model-name>");
		sb.append(
			"com.liferay.commerce.notification.model.CommerceNotificationTemplate");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>uuid</column-name><column-value><![CDATA[");
		sb.append(getUuid());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>commerceNotificationTemplateId</column-name><column-value><![CDATA[");
		sb.append(getCommerceNotificationTemplateId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>name</column-name><column-value><![CDATA[");
		sb.append(getName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>description</column-name><column-value><![CDATA[");
		sb.append(getDescription());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>from</column-name><column-value><![CDATA[");
		sb.append(getFrom());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>fromName</column-name><column-value><![CDATA[");
		sb.append(getFromName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>cc</column-name><column-value><![CDATA[");
		sb.append(getCc());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>bcc</column-name><column-value><![CDATA[");
		sb.append(getBcc());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>type</column-name><column-value><![CDATA[");
		sb.append(getType());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>enabled</column-name><column-value><![CDATA[");
		sb.append(isEnabled());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>subject</column-name><column-value><![CDATA[");
		sb.append(getSubject());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>body</column-name><column-value><![CDATA[");
		sb.append(getBody());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = CommerceNotificationTemplate.class.getClassLoader();
	private static final Class<?>[] _escapedModelInterfaces = new Class[] {
			CommerceNotificationTemplate.class, ModelWrapper.class
		};
	private String _uuid;
	private String _originalUuid;
	private long _commerceNotificationTemplateId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _name;
	private String _description;
	private String _from;
	private String _fromName;
	private String _fromNameCurrentLanguageId;
	private String _cc;
	private String _bcc;
	private String _type;
	private String _originalType;
	private boolean _enabled;
	private boolean _originalEnabled;
	private boolean _setOriginalEnabled;
	private String _subject;
	private String _subjectCurrentLanguageId;
	private String _body;
	private String _bodyCurrentLanguageId;
	private long _columnBitmask;
	private CommerceNotificationTemplate _escapedModel;
}