/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.notification.internal.util;

import com.liferay.commerce.notification.model.CommerceNotificationTemplate;
import com.liferay.commerce.notification.model.CommerceNotificationTemplateUserSegmentRel;
import com.liferay.commerce.notification.service.CommerceNotificationQueueEntryLocalService;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateLocalService;
import com.liferay.commerce.notification.service.CommerceNotificationTemplateUserSegmentRelLocalService;
import com.liferay.commerce.notification.type.CommerceNotificationType;
import com.liferay.commerce.notification.type.CommerceNotificationTypeRegistry;
import com.liferay.commerce.notification.util.CommerceNotificationHelper;
import com.liferay.commerce.user.segment.service.CommerceUserSegmentEntryLocalService;
import com.liferay.commerce.user.segment.util.CommerceUserSegmentHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class CommerceNotificationHelperImpl
implements CommerceNotificationHelper {
    private static final Pattern _placeholderPattern = Pattern.compile("\\[%[^\\[%]+%\\]", 2);
    @Reference
    private CommerceNotificationQueueEntryLocalService _commerceNotificationQueueEntryLocalService;
    @Reference
    private CommerceNotificationTemplateLocalService _commerceNotificationTemplateLocalService;
    @Reference
    private CommerceNotificationTemplateUserSegmentRelLocalService _commerceNotificationTemplateUserSegmentRelLocalService;
    @Reference
    private CommerceNotificationTypeRegistry _commerceNotificationTypeRegistry;
    @Reference
    private CommerceUserSegmentEntryLocalService _commerceUserSegmentEntryLocalService;
    @Reference
    private CommerceUserSegmentHelper _commerceUserSegmentHelper;
    @Reference
    private Portal _portal;
    @Reference
    private UserLocalService _userLocalService;

    public void sendNotifications(long groupId, String key, Object object) throws PortalException {
        this.sendNotifications(groupId, key, object, null);
    }

    public void sendNotifications(long groupId, String key, Object object, long[] userIds) throws PortalException {
        CommerceNotificationType commerceNotificationType = this._commerceNotificationTypeRegistry.getCommerceNotificationType(key);
        List commerceNotificationTemplates = this._commerceNotificationTemplateLocalService.getCommerceNotificationTemplates(groupId, commerceNotificationType.getKey(), true);
        for (CommerceNotificationTemplate commerceNotificationTemplate : commerceNotificationTemplates) {
            List commerceNotificationTemplateUserSegmentRels = this._commerceNotificationTemplateUserSegmentRelLocalService.getCommerceNotificationTemplateUserSegmentRels(commerceNotificationTemplate.getCommerceNotificationTemplateId(), -1, -1, null);
            long[] commerceUserSegmentEntryIds = ListUtil.toLongArray((List)commerceNotificationTemplateUserSegmentRels, (Accessor)CommerceNotificationTemplateUserSegmentRel.COMMERCE_USER_SEGMENT_ENTRY_ID_ACCESSOR);
            if (ArrayUtil.isEmpty((long[])userIds)) {
                this.sendNotificationsToUserSegmentUsers(commerceUserSegmentEntryIds, commerceNotificationTemplate, commerceNotificationType, object);
                continue;
            }
            this.sendNotificationsToUserIds(userIds, commerceUserSegmentEntryIds, commerceNotificationTemplate, commerceNotificationType, object);
        }
    }

    protected String formatString(CommerceNotificationType commerceNotificationType, String content, Object object, Locale locale) throws PortalException {
        if (Validator.isNull((String)content)) {
            return "";
        }
        HashSet<String> placeholders = new HashSet<String>();
        Matcher matcher = _placeholderPattern.matcher(content);
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        for (String placeholder : placeholders) {
            content = content.replace(placeholder, commerceNotificationType.getFilledTerm(placeholder, object, locale));
        }
        return content;
    }

    protected void sendNotification(CommerceNotificationTemplate commerceNotificationTemplate, CommerceNotificationType commerceNotificationType, Object object, long userId) throws PortalException {
        long groupId = commerceNotificationTemplate.getGroupId();
        User user = this._userLocalService.getUser(userId);
        Locale siteDefaultLocale = this._portal.getSiteDefaultLocale(groupId);
        Locale userLocale = user.getLocale();
        String fromName = commerceNotificationTemplate.getFromName(user.getLanguageId());
        String subject = this.formatString(commerceNotificationType, commerceNotificationTemplate.getSubject(userLocale), object, userLocale);
        String body = this.formatString(commerceNotificationType, commerceNotificationTemplate.getBody(userLocale), object, userLocale);
        if (Validator.isNull((String)fromName)) {
            fromName = commerceNotificationTemplate.getFromName(this._portal.getSiteDefaultLocale(groupId));
        }
        if (Validator.isNull((String)subject)) {
            subject = this.formatString(commerceNotificationType, commerceNotificationTemplate.getSubject(siteDefaultLocale), object, siteDefaultLocale);
        }
        if (Validator.isNull((String)body)) {
            this.formatString(commerceNotificationType, commerceNotificationTemplate.getBody(siteDefaultLocale), object, siteDefaultLocale);
        }
        this._commerceNotificationQueueEntryLocalService.addCommerceNotificationQueueEntry(user.getUserId(), groupId, commerceNotificationTemplate.getCommerceNotificationTemplateId(), commerceNotificationTemplate.getFrom(), fromName, user.getEmailAddress(), user.getFullName(), commerceNotificationTemplate.getCc(), commerceNotificationTemplate.getBcc(), subject, body, 0.0);
    }

    protected void sendNotificationsToUserIds(long[] userIds, long[] commerceUserSegmentEntryIds, CommerceNotificationTemplate commerceNotificationTemplate, CommerceNotificationType commerceNotificationType, Object object) throws PortalException {
        for (long userId : userIds) {
            long[] userCommerceUserSegmentEntryIds = this._commerceUserSegmentEntryLocalService.getCommerceUserSegmentEntryIds(commerceNotificationTemplate.getGroupId(), 0L, userId);
            if (!ArrayUtil.containsAll((long[])userCommerceUserSegmentEntryIds, (long[])commerceUserSegmentEntryIds)) continue;
            this.sendNotification(commerceNotificationTemplate, commerceNotificationType, object, userId);
        }
    }

    protected void sendNotificationsToUserSegmentUsers(long[] commerceUserSegmentEntryIds, CommerceNotificationTemplate commerceNotificationTemplate, CommerceNotificationType commerceNotificationType, Object object) throws PortalException {
        long[] userIds;
        for (long userId : userIds = this._commerceUserSegmentHelper.getUserIds(commerceNotificationTemplate.getGroupId(), 0L, commerceUserSegmentEntryIds, -1, -1)) {
            this.sendNotification(commerceNotificationTemplate, commerceNotificationType, object, userId);
        }
    }
}

