/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.forecast.alert.service.impl;

import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.commerce.account.util.CommerceAccountHelper;
import com.liferay.commerce.machine.learning.forecast.alert.model.CommerceMLForecastAlertEntry;
import com.liferay.commerce.machine.learning.forecast.alert.service.base.CommerceMLForecastAlertEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceMLForecastAlertEntry"}, service={AopService.class})
public class CommerceMLForecastAlertEntryServiceImpl
extends CommerceMLForecastAlertEntryServiceBaseImpl {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private CommerceAccountHelper _commerceAccountHelper;
    @Reference(target="(resource.name=com.liferay.commerce.machine.learning.forecast.alert)")
    private PortletResourcePermission _portletResourcePermission;

    public List<CommerceMLForecastAlertEntry> getAboveThresholdCommerceMLForecastAlertEntries(long companyId, long userId, int status, double relativeChange, int start, int end) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] accountEntryIds = this._getUserAccountEntryIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getAboveThresholdCommerceMLForecastAlertEntries(companyId, accountEntryIds, relativeChange, status, start, end);
    }

    public int getAboveThresholdCommerceMLForecastAlertEntriesCount(long companyId, long userId, int status, double relativeChange) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] accountEntryIds = this._getUserAccountEntryIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getAboveThresholdCommerceMLForecastAlertEntriesCount(companyId, accountEntryIds, relativeChange, status);
    }

    public List<CommerceMLForecastAlertEntry> getBelowThresholdCommerceMLForecastAlertEntries(long companyId, long userId, int status, double relativeChange, int start, int end) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] accountEntryIds = this._getUserAccountEntryIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getBelowThresholdCommerceMLForecastAlertEntries(companyId, accountEntryIds, relativeChange, status, start, end);
    }

    public int getBelowThresholdCommerceMLForecastAlertEntriesCount(long companyId, long userId, int status, double relativeChange) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] accountEntryIds = this._getUserAccountEntryIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getBelowThresholdCommerceMLForecastAlertEntriesCount(companyId, accountEntryIds, relativeChange, status);
    }

    public List<CommerceMLForecastAlertEntry> getCommerceMLForecastAlertEntries(long companyId, long userId, int status, int start, int end) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] accountEntryIds = this._getUserAccountEntryIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getCommerceMLForecastAlertEntries(companyId, accountEntryIds, status, start, end);
    }

    public int getCommerceMLForecastAlertEntriesCount(long companyId, long userId, int status) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] accountEntryIds = this._getUserAccountEntryIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getCommerceMLForecastAlertEntriesCount(companyId, accountEntryIds, status);
    }

    public CommerceMLForecastAlertEntry updateStatus(long commerceMLForecastAlertEntryId, int status) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "MANAGE_ALERT_STATUS");
        return this.commerceMLForecastAlertEntryLocalService.updateStatus(this.getUserId(), commerceMLForecastAlertEntryId, status);
    }

    private long[] _getUserAccountEntryIds(long userId) throws PortalException {
        List accountEntries = this._accountEntryLocalService.getUserAccountEntries(userId, null, null, this._commerceAccountHelper.toAccountEntryTypes(2), -1, -1);
        return ListUtil.toLongArray((List)accountEntries, AccountEntryModel::getAccountEntryId);
    }
}

