/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.forecast.alert.internal.dispatch.executor;

import com.liferay.commerce.account.model.CommerceAccountModel;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.machine.learning.forecast.CommerceAccountCommerceMLForecast;
import com.liferay.commerce.machine.learning.forecast.CommerceAccountCommerceMLForecastManager;
import com.liferay.commerce.machine.learning.forecast.alert.service.CommerceMLForecastAlertEntryLocalService;
import com.liferay.dispatch.executor.BaseDispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorOutput;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dispatch.task.executor.name=commerce-ml-forecast-alert-entry", "dispatch.task.executor.type=commerce-ml-forecast-alert-entry"}, service={DispatchTaskExecutor.class})
public class CommerceMLForecastAlertEntryDispatchTaskExecutor
extends BaseDispatchTaskExecutor {
    public static final String KEY = "commerce-ml-forecast-alert-entry";
    private static final String _DATE_FORMAT = "yyyyMMdd";
    private static final float _DEFAULT_COMMERCE_ML_FORECAST_ALERT_ENTRY_THRESHOLD = 20.0f;
    private static final Log _log = LogFactoryUtil.getLog(CommerceMLForecastAlertEntryDispatchTaskExecutor.class);
    @Reference
    private CommerceAccountCommerceMLForecastManager _commerceAccountCommerceMLForecastManager;
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference
    private CommerceMLForecastAlertEntryLocalService _commerceMLForecastAlertEntryLocalService;

    public void doExecute(DispatchTrigger dispatchTrigger, DispatchTaskExecutorOutput dispatchTaskExecutorOutput) throws IOException, PortalException {
        UnicodeProperties unicodeProperties = dispatchTrigger.getDispatchTaskSettingsUnicodeProperties();
        Date commerceMLForecastAlertEntryCheckDate = GetterUtil.getDate((String)unicodeProperties.getProperty("commerce.ml.forecast.alert.entry.check.date"), (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)_DATE_FORMAT));
        if (commerceMLForecastAlertEntryCheckDate != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Using manually set Forecast Alert Check Date");
            }
        } else {
            commerceMLForecastAlertEntryCheckDate = new Date();
        }
        float commerceMLForecastAlertEntryThreshold = GetterUtil.getFloat((String)((String)unicodeProperties.get((Object)"commerce.ml.forecast.alert.entry.threshold")), (float)20.0f);
        long[] commerceAccountIds = ListUtil.toLongArray((List)this._commerceAccountLocalService.getCommerceAccounts(-1, -1), CommerceAccountModel::getCommerceAccountId);
        List commerceAccountCommerceMLForecasts = this._commerceAccountCommerceMLForecastManager.getMonthlyRevenueCommerceAccountCommerceMLForecasts(dispatchTrigger.getCompanyId(), commerceAccountIds, commerceMLForecastAlertEntryCheckDate, 1, 0);
        for (CommerceAccountCommerceMLForecast commerceAccountCommerceMLForecast : commerceAccountCommerceMLForecasts) {
            float actual = commerceAccountCommerceMLForecast.getActual();
            float forecast = commerceAccountCommerceMLForecast.getForecast();
            if (actual == Float.MIN_VALUE || forecast == Float.MIN_VALUE) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)String.format("Missing actual or forecast value for %s, skipping", commerceAccountCommerceMLForecast.getForecastId()));
                continue;
            }
            float delta = actual - forecast;
            float percentChange = delta / forecast * 100.0f;
            if (!(percentChange > commerceMLForecastAlertEntryThreshold) && !(percentChange < -commerceMLForecastAlertEntryThreshold)) continue;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("Actual value exceed threshold %s: change percent: %s", Float.valueOf(commerceMLForecastAlertEntryThreshold), Float.valueOf(percentChange)));
            }
            this._commerceMLForecastAlertEntryLocalService.addOrUpdateCommerceMLForecastAlertEntry(dispatchTrigger.getCompanyId(), dispatchTrigger.getUserId(), commerceAccountCommerceMLForecast.getCommerceAccountId(), commerceAccountCommerceMLForecast.getTimestamp(), actual, forecast, percentChange);
        }
    }

    public String getName() {
        return KEY;
    }
}

