/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.machine.learning.forecast.alert.service.impl;

import com.liferay.commerce.account.model.CommerceAccountModel;
import com.liferay.commerce.account.service.CommerceAccountLocalService;
import com.liferay.commerce.machine.learning.forecast.alert.model.CommerceMLForecastAlertEntry;
import com.liferay.commerce.machine.learning.forecast.alert.service.base.CommerceMLForecastAlertEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceMLForecastAlertEntry"}, service={AopService.class})
public class CommerceMLForecastAlertEntryServiceImpl
extends CommerceMLForecastAlertEntryServiceBaseImpl {
    @Reference
    private CommerceAccountLocalService _commerceAccountLocalService;
    @Reference(target="(resource.name=com.liferay.commerce.machine.learning.forecast.alert)")
    private PortletResourcePermission _portletResourcePermission;

    public List<CommerceMLForecastAlertEntry> getAboveThresholdCommerceMLForecastAlertEntries(long companyId, long userId, int status, double relativeChange, int start, int end) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] commerceAccountIds = this._getUserCommerceAccountIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getAboveThresholdCommerceMLForecastAlertEntries(companyId, commerceAccountIds, relativeChange, status, start, end);
    }

    public int getAboveThresholdCommerceMLForecastAlertEntriesCount(long companyId, long userId, int status, double relativeChange) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] commerceAccountIds = this._getUserCommerceAccountIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getAboveThresholdCommerceMLForecastAlertEntriesCount(companyId, commerceAccountIds, relativeChange, status);
    }

    public List<CommerceMLForecastAlertEntry> getBelowThresholdCommerceMLForecastAlertEntries(long companyId, long userId, int status, double relativeChange, int start, int end) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] commerceAccountIds = this._getUserCommerceAccountIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getBelowThresholdCommerceMLForecastAlertEntries(companyId, commerceAccountIds, relativeChange, status, start, end);
    }

    public int getBelowThresholdCommerceMLForecastAlertEntriesCount(long companyId, long userId, int status, double relativeChange) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] commerceAccountIds = this._getUserCommerceAccountIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getBelowThresholdCommerceMLForecastAlertEntriesCount(companyId, commerceAccountIds, relativeChange, status);
    }

    public List<CommerceMLForecastAlertEntry> getCommerceMLForecastAlertEntries(long companyId, long userId, int status, int start, int end) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] commerceAccountIds = this._getUserCommerceAccountIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getCommerceMLForecastAlertEntries(companyId, commerceAccountIds, status, start, end);
    }

    public int getCommerceMLForecastAlertEntriesCount(long companyId, long userId, int status) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "VIEW_ALERTS");
        long[] commerceAccountIds = this._getUserCommerceAccountIds(userId);
        return this.commerceMLForecastAlertEntryLocalService.getCommerceMLForecastAlertEntriesCount(companyId, commerceAccountIds, status);
    }

    public CommerceMLForecastAlertEntry updateStatus(long commerceMLForecastAlertEntryId, int status) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "MANAGE_ALERT_STATUS");
        return this.commerceMLForecastAlertEntryLocalService.updateStatus(this.getUserId(), commerceMLForecastAlertEntryId, status);
    }

    private long[] _getUserCommerceAccountIds(long userId) throws PortalException {
        List commerceAccounts = this._commerceAccountLocalService.getUserCommerceAccounts(userId, null, 2, null, -1, -1);
        return ListUtil.toLongArray((List)commerceAccounts, CommerceAccountModel::getCommerceAccountId);
    }
}

