/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.commerce.machine.learning.forecast.alert.model.impl;

import com.liferay.commerce.machine.learning.forecast.alert.model.CommerceMLForecastAlertEntry;
import com.liferay.commerce.machine.learning.forecast.alert.service.CommerceMLForecastAlertEntryLocalServiceUtil;

/**
 * The extended model base implementation for the CommerceMLForecastAlertEntry service. Represents a row in the &quot;CommerceMLForecastAlertEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CommerceMLForecastAlertEntryImpl}.
 * </p>
 *
 * @author Riccardo Ferrari
 * @see CommerceMLForecastAlertEntryImpl
 * @see CommerceMLForecastAlertEntry
 * @generated
 */
public abstract class CommerceMLForecastAlertEntryBaseImpl
	extends CommerceMLForecastAlertEntryModelImpl
	implements CommerceMLForecastAlertEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a commerce ml forecast alert entry model instance should use the <code>CommerceMLForecastAlertEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CommerceMLForecastAlertEntryLocalServiceUtil.
				addCommerceMLForecastAlertEntry(this);
		}
		else {
			CommerceMLForecastAlertEntryLocalServiceUtil.
				updateCommerceMLForecastAlertEntry(this);
		}
	}

}