/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=commerce", "json.web.service.context.path=CommerceInventoryWarehouse"}, service={AopService.class})
public class CommerceInventoryWarehouseServiceImpl
extends CommerceInventoryWarehouseServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.commerce.inventory.model.CommerceInventoryWarehouse)")
    private ModelResourcePermission<CommerceInventoryWarehouse> _commerceInventoryWarehouseModelResourcePermission;

    public CommerceInventoryWarehouse addCommerceInventoryWarehouse(String externalReferenceCode, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String street1, String street2, String street3, String city, String zip, String commerceRegionCode, String commerceCountryCode, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_WAREHOUSE");
        return this.commerceInventoryWarehouseLocalService.addCommerceInventoryWarehouse(externalReferenceCode, nameMap, descriptionMap, active, street1, street2, street3, city, zip, commerceRegionCode, commerceCountryCode, latitude, longitude, serviceContext);
    }

    public CommerceInventoryWarehouse deleteCommerceInventoryWarehouse(long commerceInventoryWarehouseId) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "DELETE");
        return this.commerceInventoryWarehouseLocalService.deleteCommerceInventoryWarehouse(commerceInventoryWarehouseId);
    }

    public CommerceInventoryWarehouse fetchByCommerceInventoryWarehouse(long commerceInventoryWarehouseId) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehouseLocalService.fetchCommerceInventoryWarehouse(commerceInventoryWarehouseId);
        if (commerceInventoryWarehouse != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceInventoryWarehouse, "VIEW");
        }
        return commerceInventoryWarehouse;
    }

    public CommerceInventoryWarehouse fetchByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehouseLocalService.fetchCommerceInventoryWarehouseByReferenceCode(externalReferenceCode, companyId);
        if (commerceInventoryWarehouse != null) {
            this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)commerceInventoryWarehouse, "VIEW");
        }
        return commerceInventoryWarehouse;
    }

    public CommerceInventoryWarehouse geolocateCommerceInventoryWarehouse(long commerceInventoryWarehouseId, double latitude, double longitude) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseLocalService.geolocateCommerceInventoryWarehouse(commerceInventoryWarehouseId, latitude, longitude);
    }

    public CommerceInventoryWarehouse getCommerceInventoryWarehouse(long commerceInventoryWarehouseId) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "VIEW");
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouse(commerceInventoryWarehouseId);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, boolean active, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) throws PrincipalException {
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouses(companyId, active, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, boolean active, String commerceCountryCode, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouses(companyId, active, commerceCountryCode, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouses(companyId, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, long groupId, boolean active) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehouses(companyId, groupId, active);
    }

    public int getCommerceInventoryWarehousesCount(long companyId) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehousesCount(companyId);
    }

    public int getCommerceInventoryWarehousesCount(long companyId, boolean active, String commerceCountryCode) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehousesCount(companyId, active, commerceCountryCode);
    }

    public List<CommerceInventoryWarehouse> search(long companyId, Boolean active, String commerceCountryCode, String keywords, int start, int end, Sort sort) throws PortalException {
        return this.commerceInventoryWarehouseLocalService.search(companyId, active, commerceCountryCode, keywords, start, end, sort);
    }

    public int searchCommerceInventoryWarehousesCount(long companyId, Boolean active, String commerceCountryCode, String keywords) throws PortalException {
        PortletResourcePermission portletResourcePermission = this._commerceInventoryWarehouseModelResourcePermission.getPortletResourcePermission();
        portletResourcePermission.check(this.getPermissionChecker(), null, "MANAGE_INVENTORY");
        return this.commerceInventoryWarehouseLocalService.searchCommerceInventoryWarehousesCount(companyId, active, commerceCountryCode, keywords);
    }

    public CommerceInventoryWarehouse setActive(long commerceInventoryWarehouseId, boolean active) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseLocalService.setActive(commerceInventoryWarehouseId, active);
    }

    public CommerceInventoryWarehouse updateCommerceInventoryWarehouse(long commerceInventoryWarehouseId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, boolean active, String street1, String street2, String street3, String city, String zip, String commerceRegionCode, String commerceCountryCode, double latitude, double longitude, long mvccVersion, ServiceContext serviceContext) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseLocalService.updateCommerceInventoryWarehouse(commerceInventoryWarehouseId, nameMap, descriptionMap, active, street1, street2, street3, city, zip, commerceRegionCode, commerceCountryCode, latitude, longitude, mvccVersion, serviceContext);
    }

    public CommerceInventoryWarehouse updateCommerceInventoryWarehouseExternalReferenceCode(String externalReferenceCode, long commerceInventoryWarehouseId) throws PortalException {
        this._commerceInventoryWarehouseModelResourcePermission.check(this.getPermissionChecker(), commerceInventoryWarehouseId, "UPDATE");
        return this.commerceInventoryWarehouseLocalService.updateCommerceInventoryWarehouseExternalReferenceCode(externalReferenceCode, commerceInventoryWarehouseId);
    }
}

