/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.upgrade.v2_6_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class CommercePermissionUpgradeProcess
extends UpgradeProcess {
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public CommercePermissionUpgradeProcess(ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select resourcePermissionId, companyId, roleId from ", "ResourcePermission where name = 'com.liferay.commerce.", "inventory.model.CommerceInventoryWarehouse' and scope = 4"}));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long roleId = resultSet.getLong("roleId");
                Role role = this._roleLocalService.fetchRole(resultSet.getLong("companyId"), "Guest");
                if (role != null && roleId == role.getRoleId()) {
                    this._resourcePermissionLocalService.deleteResourcePermission(resultSet.getLong("resourcePermissionId"));
                }
                if ((role = this._roleLocalService.fetchRole(resultSet.getLong("companyId"), "Site Member")) != null && roleId == role.getRoleId()) {
                    this._resourcePermissionLocalService.deleteResourcePermission(resultSet.getLong("resourcePermissionId"));
                }
                if ((role = this._roleLocalService.fetchRole(resultSet.getLong("companyId"), "User")) == null || roleId != role.getRoleId()) continue;
                this._resourcePermissionLocalService.deleteResourcePermission(resultSet.getLong("resourcePermissionId"));
            }
        }
    }
}

