/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.method;

import com.liferay.commerce.inventory.engine.contributor.CommerceInventoryEngineContributor;
import com.liferay.commerce.inventory.engine.contributor.CommerceInventoryEngineContributorRegistry;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.method.CommerceInventoryMethod;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.service.CommerceInventoryAuditLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryBookedQuantityLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemLocalService;
import com.liferay.commerce.inventory.service.CommerceInventoryWarehouseItemService;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditType;
import com.liferay.commerce.inventory.type.CommerceInventoryAuditTypeRegistry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.BigDecimalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"commerce.inventory.method.key=default", "commerce.inventory.method.order:Integer=100"}, service={CommerceInventoryMethod.class})
public class DefaultCommerceInventoryMethodImpl
implements CommerceInventoryMethod {
    private static final Log _log = LogFactoryUtil.getLog(DefaultCommerceInventoryMethodImpl.class);
    @Reference
    private CommerceInventoryAuditLocalService _commerceInventoryAuditLocalService;
    @Reference
    private CommerceInventoryAuditTypeRegistry _commerceInventoryAuditTypeRegistry;
    @Reference
    private CommerceInventoryBookedQuantityLocalService _commerceInventoryBookedQuantityLocalService;
    @Reference
    private CommerceInventoryEngineContributorRegistry _commerceInventoryEngineContributorRegistry;
    @Reference
    private CommerceInventoryWarehouseItemLocalService _commerceInventoryWarehouseItemLocalService;
    @Reference
    private CommerceInventoryWarehouseItemService _commerceInventoryWarehouseItemService;
    @Reference
    private Language _language;

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void consumeQuantity(long userId, long commerceInventoryBookedQuantityId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey, Map<String, String> context) throws PortalException {
        if (commerceInventoryBookedQuantityId > 0L) {
            this._commerceInventoryBookedQuantityLocalService.consumeCommerceInventoryBookedQuantity(commerceInventoryBookedQuantityId, quantity);
        }
        this.decreaseStockQuantity(userId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("consume-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(context), quantity, sku, unitOfMeasureKey);
        for (CommerceInventoryEngineContributor commerceInventoryEngineContributor : this._commerceInventoryEngineContributorRegistry.getCommerceInventoryEngineContributors()) {
            commerceInventoryEngineContributor.consumeQuantityContribute(userId, commerceInventoryBookedQuantityId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey, context);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void decreaseStockQuantity(long userId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
        BigDecimal commerceInventoryWarehouseItemQuantity = commerceInventoryWarehouseItem.getQuantity();
        this._commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), commerceInventoryWarehouseItem.getMvccVersion(), commerceInventoryWarehouseItemQuantity.subtract(quantity), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        for (CommerceInventoryEngineContributor commerceInventoryEngineContributor : this._commerceInventoryEngineContributorRegistry.getCommerceInventoryEngineContributors()) {
            commerceInventoryEngineContributor.decreaseStockQuantityContribute(userId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
        }
    }

    public String getAvailabilityStatus(long companyId, long commerceChannelGroupId, BigDecimal minStockQuantity, String sku, String unitOfMeasureKey) {
        return this._getAvailabilityStatus(minStockQuantity, this.getStockQuantity(companyId, commerceChannelGroupId, sku, unitOfMeasureKey));
    }

    public String getKey() {
        return "default";
    }

    public String getLabel(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass());
        return this._language.get(resourceBundle, this.getKey());
    }

    public BigDecimal getStockQuantity(long companyId, long commerceChannelGroupId, String sku, String unitOfMeasureKey) {
        BigDecimal stockQuantity = this._commerceInventoryWarehouseItemService.getStockQuantity(companyId, commerceChannelGroupId, sku, unitOfMeasureKey);
        return stockQuantity.subtract(this._commerceInventoryBookedQuantityLocalService.getCommerceInventoryBookedQuantity(companyId, commerceChannelGroupId, sku, unitOfMeasureKey));
    }

    public BigDecimal getStockQuantity(long companyId, String sku, String unitOfMeasureKey) {
        BigDecimal stockQuantity = this._commerceInventoryWarehouseItemService.getStockQuantity(companyId, sku, unitOfMeasureKey);
        return stockQuantity.subtract(this._commerceInventoryBookedQuantityLocalService.getCommerceInventoryBookedQuantity(companyId, sku, unitOfMeasureKey));
    }

    public boolean hasStockQuantity(long companyId, BigDecimal quantity, String sku, String unitOfMeasureKey) {
        return BigDecimalUtil.lte((BigDecimal)quantity, (BigDecimal)this.getStockQuantity(companyId, sku, unitOfMeasureKey));
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void increaseStockQuantity(long userId, long commerceInventoryWarehouseId, BigDecimal quantity, String sku, String unitOfMeasureKey) throws PortalException {
        CommerceInventoryWarehouseItem commerceInventoryWarehouseItem = this._commerceInventoryWarehouseItemLocalService.fetchCommerceInventoryWarehouseItem(commerceInventoryWarehouseId, sku, unitOfMeasureKey);
        try {
            BigDecimal commerceInventoryWarehouseItemQuantity = commerceInventoryWarehouseItem.getQuantity();
            this._commerceInventoryWarehouseItemLocalService.updateCommerceInventoryWarehouseItem(userId, commerceInventoryWarehouseItem.getCommerceInventoryWarehouseItemId(), commerceInventoryWarehouseItem.getMvccVersion(), commerceInventoryWarehouseItemQuantity.add(quantity), commerceInventoryWarehouseItem.getUnitOfMeasureKey());
        }
        catch (MVCCException mvccException) {
            _log.error((Throwable)mvccException);
            throw mvccException;
        }
        CommerceInventoryAuditType commerceInventoryAuditType = this._commerceInventoryAuditTypeRegistry.getCommerceInventoryAuditType("increase-quantity");
        this._commerceInventoryAuditLocalService.addCommerceInventoryAudit(userId, commerceInventoryAuditType.getType(), commerceInventoryAuditType.getLog(null), quantity, sku, unitOfMeasureKey);
        for (CommerceInventoryEngineContributor commerceInventoryEngineContributor : this._commerceInventoryEngineContributorRegistry.getCommerceInventoryEngineContributors()) {
            commerceInventoryEngineContributor.increaseStockQuantityContribute(userId, commerceInventoryWarehouseId, quantity, sku, unitOfMeasureKey);
        }
    }

    private String _getAvailabilityStatus(BigDecimal minStockQuantity, BigDecimal stockQuantity) {
        String availabilityStatus = "unavailable";
        boolean available = false;
        if (BigDecimalUtil.gt((BigDecimal)stockQuantity, (BigDecimal)minStockQuantity)) {
            available = true;
        }
        if (available) {
            availabilityStatus = "available";
        }
        return availabilityStatus;
    }
}

