/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.internal.method;

import com.liferay.commerce.inventory.internal.method.comparator.CommerceInventoryMethodOrderComparator;
import com.liferay.commerce.inventory.method.CommerceInventoryMethod;
import com.liferay.commerce.inventory.method.CommerceInventoryMethodRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={CommerceInventoryMethodRegistry.class})
public class CommerceInventoryMethodRegistryImpl
implements CommerceInventoryMethodRegistry {
    private static final Log _log = LogFactoryUtil.getLog(CommerceInventoryMethodRegistryImpl.class);
    private final Comparator<ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceInventoryMethod>> _commerceInventoryMethodServiceWrapperOrderComparator = new CommerceInventoryMethodOrderComparator();
    private ServiceTrackerMap<String, ServiceTrackerCustomizerFactory.ServiceWrapper<CommerceInventoryMethod>> _serviceTrackerMap;

    public CommerceInventoryMethod getCommerceInventoryMethod(String key) {
        ServiceTrackerCustomizerFactory.ServiceWrapper commerceInventoryMethodServiceWrapper = (ServiceTrackerCustomizerFactory.ServiceWrapper)this._serviceTrackerMap.getService((Object)key);
        if (commerceInventoryMethodServiceWrapper == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No commerce inventory method registered with key " + key));
            }
            return null;
        }
        return (CommerceInventoryMethod)commerceInventoryMethodServiceWrapper.getService();
    }

    public List<CommerceInventoryMethod> getCommerceInventoryMethods() {
        ArrayList<Object> commerceInventoryMethods = new ArrayList<Object>();
        List commerceInventoryMethodServiceWrappers = ListUtil.fromCollection((Collection)this._serviceTrackerMap.values());
        Collections.sort(commerceInventoryMethodServiceWrappers, this._commerceInventoryMethodServiceWrapperOrderComparator);
        for (ServiceTrackerCustomizerFactory.ServiceWrapper commerceInventoryMethodServiceWrapper : commerceInventoryMethodServiceWrappers) {
            commerceInventoryMethods.add(commerceInventoryMethodServiceWrapper.getService());
        }
        return Collections.unmodifiableList(commerceInventoryMethods);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CommerceInventoryMethod.class, (String)"commerce.inventory.method.key", (ServiceTrackerCustomizer)ServiceTrackerCustomizerFactory.serviceWrapper((BundleContext)bundleContext));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

