/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.persistence.impl;

import com.liferay.commerce.inventory.model.CommerceInventoryWarehouseItem;
import com.liferay.commerce.inventory.model.impl.CommerceInventoryWarehouseItemImpl;
import com.liferay.commerce.inventory.service.persistence.CommerceInventoryWarehouseItemFinder;
import com.liferay.commerce.inventory.service.persistence.impl.CommerceInventoryWarehouseItemFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class CommerceInventoryWarehouseItemFinderImpl
extends CommerceInventoryWarehouseItemFinderBaseImpl
implements CommerceInventoryWarehouseItemFinder {
    public static final String COUNT_ITEMS_BY_COMPANY_ID = CommerceInventoryWarehouseItemFinder.class.getName() + ".countItemsByCompanyId";
    public static final String COUNT_STOCK_QUANTITY_BY_C_S = CommerceInventoryWarehouseItemFinder.class.getName() + ".countStockQuantityByC_S";
    public static final String COUNT_STOCK_QUANTITY_BY_C_G_S = CommerceInventoryWarehouseItemFinder.class.getName() + ".countStockQuantityByC_G_S";
    public static final String COUNT_UPDATED_ITEMS_BY_C_M = CommerceInventoryWarehouseItemFinder.class.getName() + ".countUpdatedItemsByC_M";
    public static final String FIND_ITEMS_BY_COMPANY_ID = CommerceInventoryWarehouseItemFinder.class.getName() + ".findItemsByCompanyId";
    public static final String FIND_UPDATED_ITEMS_BY_C_M = CommerceInventoryWarehouseItemFinder.class.getName() + ".findUpdatedItemsByC_M";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countItemsByCompanyId(long companyId, String sku) {
        Session session = null;
        try {
            Long count;
            Iterator iterator;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_ITEMS_BY_COMPANY_ID);
            String[] keywords = this._customSQL.keywords(sku, true);
            if (Validator.isNotNull((String)sku)) {
                sql = this._customSQL.replaceKeywords(sql, "LOWER(CIWarehouseItem.sku)", "LIKE", true, keywords);
                sql = this._customSQL.replaceAndOperator(sql, false);
            } else {
                sql = StringUtil.removeSubstring((String)sql, (String)" AND (LOWER(CIWarehouseItem.sku) LIKE ? [$AND_OR_NULL_CHECK$])");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            if (Validator.isNotNull((String)sku)) {
                queryPos.add(keywords, 2);
            }
            if ((iterator = sqlQuery.iterate()).hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countStockQuantityByC_S(long companyId, String sku) {
        Session session = null;
        try {
            Integer sum;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_STOCK_QUANTITY_BY_C_S);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("SUM_VALUE", Type.INTEGER);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(sku);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (sum = (Integer)iterator.next()) != null) {
                int n = sum;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countStockQuantityByC_G_S(long companyId, long channelGroupId, String sku) {
        Session session = null;
        try {
            Integer sum;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_STOCK_QUANTITY_BY_C_G_S);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("SUM_VALUE", Type.INTEGER);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(channelGroupId);
            queryPos.add(sku);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (sum = (Integer)iterator.next()) != null) {
                int n = sum;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countUpdatedItemsByC_M(long companyId, Date startDate, Date endDate) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_UPDATED_ITEMS_BY_C_M);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(startDate);
            queryPos.add(endDate);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            int count = 0;
            Iterator iterator = sqlQuery.iterate();
            while (iterator.hasNext()) {
                Long l = (Long)iterator.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object[]> findItemsByCompanyId(long companyId, String sku, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String[] keywords = this._customSQL.keywords(sku, true);
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_ITEMS_BY_COMPANY_ID);
            sql = StringUtil.replace((String)sql, (String[])new String[]{"[$COMPANY_ID$]"}, (String[])new String[]{String.valueOf(companyId)});
            if (Validator.isNotNull((String)sku)) {
                sql = this._customSQL.replaceKeywords(sql, "LOWER(CIWarehouseItem.sku)", "LIKE", true, keywords);
                sql = this._customSQL.replaceAndOperator(sql, false);
            } else {
                sql = StringUtil.removeSubstring((String)sql, (String)" AND (LOWER(CIWarehouseItem.sku) LIKE ? [$AND_OR_NULL_CHECK$])");
            }
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("SKU", Type.STRING);
            sqlQuery.addScalar("SUM_STOCK", Type.INTEGER);
            sqlQuery.addScalar("SUM_BOOKED", Type.INTEGER);
            sqlQuery.addScalar("SUM_AWAITING", Type.INTEGER);
            if (Validator.isNotNull((String)sku)) {
                QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
                queryPos.add(keywords, 2);
            }
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<CommerceInventoryWarehouseItem> findUpdatedItemsByC_M(long companyId, Date startDate, Date endDate, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_UPDATED_ITEMS_BY_C_M);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("CIWarehouseItem", CommerceInventoryWarehouseItemImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(companyId);
            queryPos.add(startDate);
            queryPos.add(endDate);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

