/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.inventory.service.impl;

import com.liferay.commerce.inventory.exception.CommerceInventoryWarehouseActiveException;
import com.liferay.commerce.inventory.exception.CommerceInventoryWarehouseNameException;
import com.liferay.commerce.inventory.exception.DuplicateCommerceInventoryWarehouseException;
import com.liferay.commerce.inventory.exception.MVCCException;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.inventory.service.base.CommerceInventoryWarehouseLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommerceInventoryWarehouseLocalServiceImpl
extends CommerceInventoryWarehouseLocalServiceBaseImpl {
    private static final String[] _SELECTED_FIELD_NAMES = new String[]{"entryClassPK", "companyId"};

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse addCommerceInventoryWarehouse(String name, String description, boolean active, String street1, String street2, String street3, String city, String zip, String commerceRegionCode, String commerceCountryCode, double latitude, double longitude, String externalReferenceCode, ServiceContext serviceContext) throws PortalException {
        return this.addCommerceInventoryWarehouse(externalReferenceCode, name, description, active, street1, street2, street3, city, zip, commerceRegionCode, commerceCountryCode, latitude, longitude, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse addCommerceInventoryWarehouse(String externalReferenceCode, String name, String description, boolean active, String street1, String street2, String street3, String city, String zip, String commerceRegionCode, String commerceCountryCode, double latitude, double longitude, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        if (Validator.isBlank((String)externalReferenceCode)) {
            externalReferenceCode = null;
        } else {
            CommerceInventoryWarehouse commerceInventoryWarehouse = this.fetchCommerceInventoryWarehouseByReferenceCode(externalReferenceCode, user.getCompanyId());
            if (commerceInventoryWarehouse != null) {
                throw new DuplicateCommerceInventoryWarehouseException("Duplicated externalReferenceCode");
            }
        }
        this.validate(name, active, latitude, longitude);
        long commerceInventoryWarehouseId = this.counterLocalService.increment();
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.create(commerceInventoryWarehouseId);
        commerceInventoryWarehouse.setExternalReferenceCode(externalReferenceCode);
        commerceInventoryWarehouse.setCompanyId(user.getCompanyId());
        commerceInventoryWarehouse.setUserId(user.getUserId());
        commerceInventoryWarehouse.setUserName(user.getFullName());
        commerceInventoryWarehouse.setName(name);
        commerceInventoryWarehouse.setDescription(description);
        commerceInventoryWarehouse.setActive(active);
        commerceInventoryWarehouse.setStreet1(street1);
        commerceInventoryWarehouse.setStreet2(street2);
        commerceInventoryWarehouse.setStreet3(street3);
        commerceInventoryWarehouse.setCity(city);
        commerceInventoryWarehouse.setZip(zip);
        commerceInventoryWarehouse.setCommerceRegionCode(commerceRegionCode);
        commerceInventoryWarehouse.setCountryTwoLettersISOCode(commerceCountryCode);
        commerceInventoryWarehouse.setLatitude(latitude);
        commerceInventoryWarehouse.setLongitude(longitude);
        commerceInventoryWarehouse.setExpandoBridgeAttributes(serviceContext);
        commerceInventoryWarehouse = (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), CommerceInventoryWarehouse.class.getName(), commerceInventoryWarehouse.getCommerceInventoryWarehouseId(), false, false, false);
        return commerceInventoryWarehouse;
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public CommerceInventoryWarehouse deleteCommerceInventoryWarehouse(CommerceInventoryWarehouse commerceInventoryWarehouse) throws PortalException {
        this.commerceInventoryWarehousePersistence.remove((BaseModel)commerceInventoryWarehouse);
        this.commerceInventoryWarehouseItemLocalService.deleteCommerceInventoryWarehouseItems(commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        this.expandoRowLocalService.deleteRows(commerceInventoryWarehouse.getCommerceInventoryWarehouseId());
        this.resourceLocalService.deleteResource((AuditedModel)commerceInventoryWarehouse, 4);
        return commerceInventoryWarehouse;
    }

    public CommerceInventoryWarehouse fetchCommerceInventoryWarehouseByReferenceCode(String externalReferenceCode, long companyId) {
        if (Validator.isBlank((String)externalReferenceCode)) {
            return null;
        }
        return this.commerceInventoryWarehousePersistence.fetchByC_ERC(companyId, externalReferenceCode);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse geolocateCommerceInventoryWarehouse(long commerceInventoryWarehouseId, double latitude, double longitude) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.findByPrimaryKey(commerceInventoryWarehouseId);
        commerceInventoryWarehouse.setLatitude(latitude);
        commerceInventoryWarehouse.setLongitude(longitude);
        return (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId) {
        return this.commerceInventoryWarehousePersistence.findByCompanyId(companyId);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, boolean active, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) {
        return this.commerceInventoryWarehousePersistence.findByC_A(companyId, active, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, boolean active, String commerceCountryCode, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) {
        return this.commerceInventoryWarehousePersistence.findByC_A_C(companyId, active, commerceCountryCode, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, int start, int end, OrderByComparator<CommerceInventoryWarehouse> orderByComparator) {
        return this.commerceInventoryWarehousePersistence.findByCompanyId(companyId, start, end, orderByComparator);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long companyId, long groupId, boolean active) {
        return this.commerceInventoryWarehouseFinder.findByC_G_A(companyId, groupId, active);
    }

    public List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(long groupId, String sku) {
        return this.commerceInventoryWarehouseFinder.findByG_S(groupId, sku);
    }

    public int getCommerceInventoryWarehousesCount(long companyId) {
        return this.commerceInventoryWarehousePersistence.countByCompanyId(companyId);
    }

    public int getCommerceInventoryWarehousesCount(long companyId, boolean active) {
        return this.commerceInventoryWarehousePersistence.countByC_A(companyId, active);
    }

    public int getCommerceInventoryWarehousesCount(long companyId, boolean active, String commerceCountryCode) {
        if (Validator.isNotNull((String)commerceCountryCode)) {
            return this.commerceInventoryWarehousePersistence.countByC_A_C(companyId, active, commerceCountryCode);
        }
        return this.commerceInventoryWarehouseLocalService.getCommerceInventoryWarehousesCount(companyId, active);
    }

    public List<CommerceInventoryWarehouse> searchCommerceInventoryWarehouses(long companyId, Boolean active, String commerceCountryCode, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, active, commerceCountryCode, keywords, start, end, sort);
        searchContext.setKeywords(keywords);
        return this.searchCommerceInventoryWarehouses(searchContext);
    }

    public int searchCommerceInventoryWarehousesCount(long companyId, Boolean active, String commerceCountryCode, String keywords) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, active, commerceCountryCode, keywords, -1, -1, null);
        searchContext.setKeywords(keywords);
        return this.searchCommerceInventoryWarehousesCount(searchContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse setActive(long commerceInventoryWarehouseId, boolean active) throws PortalException {
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.findByPrimaryKey(commerceInventoryWarehouseId);
        this.validate(commerceInventoryWarehouse.getName(), active, commerceInventoryWarehouse.getLatitude(), commerceInventoryWarehouse.getLongitude());
        commerceInventoryWarehouse.setActive(active);
        return (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CommerceInventoryWarehouse updateCommerceInventoryWarehouse(long commerceInventoryWarehouseId, String name, String description, boolean active, String street1, String street2, String street3, String city, String zip, String commerceRegionCode, String commerceCountryCode, double latitude, double longitude, long mvccVersion, ServiceContext serviceContext) throws PortalException {
        this.validate(name, active, latitude, longitude);
        CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehousePersistence.findByPrimaryKey(commerceInventoryWarehouseId);
        if (commerceInventoryWarehouse.getMvccVersion() != mvccVersion) {
            throw new MVCCException();
        }
        commerceInventoryWarehouse.setName(name);
        commerceInventoryWarehouse.setDescription(description);
        commerceInventoryWarehouse.setActive(active);
        commerceInventoryWarehouse.setStreet1(street1);
        commerceInventoryWarehouse.setStreet2(street2);
        commerceInventoryWarehouse.setStreet3(street3);
        commerceInventoryWarehouse.setCity(city);
        commerceInventoryWarehouse.setZip(zip);
        commerceInventoryWarehouse.setCommerceRegionCode(commerceRegionCode);
        commerceInventoryWarehouse.setCountryTwoLettersISOCode(commerceCountryCode);
        commerceInventoryWarehouse.setLatitude(latitude);
        commerceInventoryWarehouse.setLongitude(longitude);
        commerceInventoryWarehouse.setExpandoBridgeAttributes(serviceContext);
        return (CommerceInventoryWarehouse)this.commerceInventoryWarehousePersistence.update((BaseModel)commerceInventoryWarehouse);
    }

    protected SearchContext buildSearchContext(long companyId, Boolean active, String commerceCountryCode, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        HashMap attributes = HashMapBuilder.put((Object)"city", (Object)keywords).put((Object)"street1", (Object)keywords).put((Object)"zip", (Object)keywords).put((Object)"description", (Object)keywords).put((Object)"entryClassPK", (Object)keywords).put((Object)"name", (Object)keywords).put((Object)"params", (Object)LinkedHashMapBuilder.put((Object)"keywords", (Object)keywords).build()).build();
        if (active != null) {
            attributes.put("active", active);
        }
        if (Validator.isNotNull((String)commerceCountryCode)) {
            attributes.put("countryTwoLettersISOCode", commerceCountryCode);
        }
        searchContext.setAttributes((Map)attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected List<CommerceInventoryWarehouse> getCommerceInventoryWarehouses(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<CommerceInventoryWarehouse> commerceInventoryWarehouses = new ArrayList<CommerceInventoryWarehouse>(documents.size());
        for (Document document : documents) {
            long commerceInventoryWarehouseId = GetterUtil.getLong((String)document.get("entryClassPK"));
            CommerceInventoryWarehouse commerceInventoryWarehouse = this.commerceInventoryWarehouseLocalService.fetchCommerceInventoryWarehouse(commerceInventoryWarehouseId);
            if (commerceInventoryWarehouse == null) {
                commerceInventoryWarehouses = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(CommerceInventoryWarehouse.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (commerceInventoryWarehouses == null) continue;
            commerceInventoryWarehouses.add(commerceInventoryWarehouse);
        }
        return commerceInventoryWarehouses;
    }

    protected List<CommerceInventoryWarehouse> searchCommerceInventoryWarehouses(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceInventoryWarehouse.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext, _SELECTED_FIELD_NAMES);
            List<CommerceInventoryWarehouse> commerceInventoryWarehouses = this.getCommerceInventoryWarehouses(hits);
            if (commerceInventoryWarehouses == null) continue;
            return commerceInventoryWarehouses;
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected int searchCommerceInventoryWarehousesCount(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(CommerceInventoryWarehouse.class);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    protected void validate(String name, boolean active, double latitude, double longitude) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CommerceInventoryWarehouseNameException();
        }
        if (active && latitude == 0.0 && longitude == 0.0) {
            throw new CommerceInventoryWarehouseActiveException();
        }
    }
}

